/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.amazonaws.services.kms.model.UnsupportedOperationException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.cloud.storage.AzureObjectSummariesIterator;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeAzureClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="others")
public class SnowflakeAzureClientLatestIT
extends BaseJDBCTest {
    @Test
    @DontRunOnGithubActions
    public void testAzureClientSetupInvalidEncryptionKeySize() throws SQLException {
        try (Connection connection = SnowflakeAzureClientLatestIT.getConnection("azureaccount");){
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            String putCommand = "put file:///dummy/path/file1.gz @~";
            SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
            RemoteStoreFileEncryptionMaterial content = new RemoteStoreFileEncryptionMaterial("EXAMPLEQUERYSTAGEMASTERKEY", "EXAMPLEQUERYID", Long.valueOf(123L));
            SnowflakeSQLLoggedException ex = (SnowflakeSQLLoggedException)Assertions.assertThrows(SnowflakeSQLLoggedException.class, () -> SnowflakeAzureClient.createSnowflakeAzureClient((StageInfo)sfAgent.getStageInfo(), (RemoteStoreFileEncryptionMaterial)content, (SFBaseSession)sfSession));
            Assertions.assertEquals((int)200001, (int)ex.getErrorCode());
        }
    }

    @Test
    public void testCloudExceptionTest() {
        ArrayList mockList = new ArrayList();
        AzureObjectSummariesIterator iterator = new AzureObjectSummariesIterator(mockList);
        AzureObjectSummariesIterator spyIterator = (AzureObjectSummariesIterator)Mockito.spy((Object)iterator);
        UnsupportedOperationException ex = (UnsupportedOperationException)Assertions.assertThrows(UnsupportedOperationException.class, () -> spyIterator.remove());
        Assertions.assertTrue((boolean)ex.getMessage().startsWith("remove() method not supported"));
    }
}

