/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.diagnostic;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.diagnostic.DiagnosticContext;
import net.snowflake.client.jdbc.diagnostic.SnowflakeEndpoint;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="diagnostic")
public class DiagnosticContextLatestIT {
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static String oldJvmNonProxyHosts;
    private static String oldJvmHttpProxyHost;
    private static String oldJvmHttpProxyPort;
    private static String oldJvmHttpsProxyHost;
    private static String oldJvmHttpsProxyPort;

    @BeforeAll
    public static void init() {
        oldJvmNonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        oldJvmHttpProxyHost = System.getProperty(HTTP_PROXY_HOST);
        oldJvmHttpProxyPort = System.getProperty(HTTP_PROXY_PORT);
        oldJvmHttpsProxyHost = System.getProperty(HTTPS_PROXY_HOST);
        oldJvmHttpsProxyPort = System.getProperty(HTTPS_PROXY_PORT);
    }

    @BeforeEach
    public void clearJvmProperties() {
        System.clearProperty(HTTP_NON_PROXY_HOSTS);
        System.clearProperty(HTTP_PROXY_HOST);
        System.clearProperty(HTTP_PROXY_PORT);
        System.clearProperty(HTTPS_PROXY_HOST);
        System.clearProperty(HTTPS_PROXY_PORT);
    }

    @Test
    public void parseAllowListFileTest() {
        HashMap connectionPropertiesMap = new HashMap();
        File allowlistFile = new File("src/test/resources/allowlist.json");
        DiagnosticContext diagnosticContext = new DiagnosticContext(allowlistFile.getAbsolutePath(), connectionPropertiesMap);
        List endpointsFromTestFile = diagnosticContext.getEndpoints();
        ArrayList<SnowflakeEndpoint> mockEndpoints = new ArrayList<SnowflakeEndpoint>();
        mockEndpoints.add(new SnowflakeEndpoint("SNOWFLAKE_DEPLOYMENT", "account_name.snowflakecomputing.com", 443));
        mockEndpoints.add(new SnowflakeEndpoint("SNOWFLAKE_DEPLOYMENT_REGIONLESS", "org-account_name.snowflakecomputing.com", 443));
        mockEndpoints.add(new SnowflakeEndpoint("STAGE", "stage-bucket.s3.amazonaws.com", 443));
        mockEndpoints.add(new SnowflakeEndpoint("STAGE", "stage-bucket.s3.us-west-2.amazonaws.com", 443));
        mockEndpoints.add(new SnowflakeEndpoint("STAGE", "stage-bucket.s3-us-west-2.amazonaws.com", 443));
        mockEndpoints.add(new SnowflakeEndpoint("SNOWSQL_REPO", "snowsql_repo.snowflakecomputing.com", 443));
        mockEndpoints.add(new SnowflakeEndpoint("OUT_OF_BAND_TELEMETRY", "out_of_band_telemetry.snowflakecomputing.com", 443));
        mockEndpoints.add(new SnowflakeEndpoint("OCSP_CACHE", "ocsp_cache.snowflakecomputing.com", 80));
        mockEndpoints.add(new SnowflakeEndpoint("DUO_SECURITY", "duo_security.duosecurity.com", 443));
        mockEndpoints.add(new SnowflakeEndpoint("OCSP_RESPONDER", "ocsp.rootg2.amazontrust.com", 80));
        mockEndpoints.add(new SnowflakeEndpoint("OCSP_RESPONDER", "o.ss2.us", 80));
        mockEndpoints.add(new SnowflakeEndpoint("OCSP_RESPONDER", "ocsp.sca1b.amazontrust.com", 80));
        mockEndpoints.add(new SnowflakeEndpoint("OCSP_RESPONDER", "ocsp.r2m01.amazontrust.com", 80));
        mockEndpoints.add(new SnowflakeEndpoint("OCSP_RESPONDER", "ocsp.rootca1.amazontrust.com", 80));
        mockEndpoints.add(new SnowflakeEndpoint("SNOWSIGHT_DEPLOYMENT", "snowsight_deployment.snowflake.com", 443));
        mockEndpoints.add(new SnowflakeEndpoint("SNOWSIGHT_DEPLOYMENT", "snowsight_deployment_2.snowflake.com", 443));
        String testFailedMessage = "The lists of SnowflakeEndpoints in mockEndpoints and endpointsFromTestFile should be identical";
        Assertions.assertTrue((boolean)endpointsFromTestFile.containsAll(mockEndpoints), (String)testFailedMessage);
    }

    @Test
    public void testEmptyProxyConfig() {
        HashMap connectionPropertiesMap = new HashMap();
        DiagnosticContext diagnosticContext = new DiagnosticContext(connectionPropertiesMap);
        Assertions.assertFalse((boolean)diagnosticContext.isProxyEnabled(), (String)"Proxy configurations should be empty");
        Assertions.assertTrue((boolean)diagnosticContext.getHttpProxyHost().isEmpty(), (String)"getHttpProxyHost() must return an empty string in the absence of proxy configuration");
        Assertions.assertEquals((int)-1, (int)diagnosticContext.getHttpProxyPort(), (String)"getHttpProxyPort() must return -1 in the absence of proxy configuration");
        Assertions.assertTrue((boolean)diagnosticContext.getHttpsProxyHost().isEmpty(), (String)"getHttpsProxyHost() must return an empty string in the absence of proxy configuration");
        Assertions.assertEquals((int)-1, (int)diagnosticContext.getHttpsProxyPort(), (String)"getHttpsProxyPort() must return -1 in the absence of proxy configuration");
        Assertions.assertTrue((boolean)diagnosticContext.getHttpNonProxyHosts().isEmpty(), (String)"getHttpNonProxyHosts() must return an empty string in the absence of proxy configuration");
    }

    @Test
    public void testProxyConfigSetOnJvm() {
        System.setProperty(HTTP_PROXY_HOST, "http.proxyHost.com");
        System.setProperty(HTTP_PROXY_PORT, "8080");
        System.setProperty(HTTPS_PROXY_HOST, "https.proxyHost.com");
        System.setProperty(HTTPS_PROXY_PORT, "8083");
        System.setProperty(HTTP_NON_PROXY_HOSTS, "*.domain.com|localhost");
        HashMap connectionPropertiesMap = new HashMap();
        DiagnosticContext diagnosticContext = new DiagnosticContext(connectionPropertiesMap);
        Assertions.assertTrue((boolean)diagnosticContext.isProxyEnabled());
        Assertions.assertTrue((boolean)diagnosticContext.isProxyEnabledOnJvm());
        Assertions.assertEquals((Object)diagnosticContext.getHttpProxyHost(), (Object)"http.proxyHost.com");
        Assertions.assertEquals((int)diagnosticContext.getHttpProxyPort(), (int)8080);
        Assertions.assertEquals((Object)diagnosticContext.getHttpsProxyHost(), (Object)"https.proxyHost.com");
        Assertions.assertEquals((int)diagnosticContext.getHttpsProxyPort(), (int)8083);
        Assertions.assertEquals((Object)diagnosticContext.getHttpNonProxyHosts(), (Object)"*.domain.com|localhost");
    }

    @Test
    public void testProxyOverrideWithConnectionParameter() {
        System.setProperty(HTTP_PROXY_HOST, "http.proxyHost.com");
        System.setProperty(HTTP_PROXY_PORT, "8080");
        System.setProperty(HTTPS_PROXY_HOST, "https.proxyHost.com");
        System.setProperty(HTTPS_PROXY_PORT, "8083");
        System.setProperty(HTTP_NON_PROXY_HOSTS, "*.domain.com|localhost");
        HashMap<SFSessionProperty, String> connectionPropertiesMap = new HashMap<SFSessionProperty, String>();
        connectionPropertiesMap.put(SFSessionProperty.PROXY_HOST, "override.proxyHost.com");
        connectionPropertiesMap.put(SFSessionProperty.PROXY_PORT, "80");
        connectionPropertiesMap.put(SFSessionProperty.NON_PROXY_HOSTS, "*.new_domain.com|localhost");
        DiagnosticContext diagnosticContext = new DiagnosticContext(connectionPropertiesMap);
        Assertions.assertTrue((boolean)diagnosticContext.isProxyEnabled());
        Assertions.assertFalse((boolean)diagnosticContext.isProxyEnabledOnJvm());
        Assertions.assertEquals((Object)diagnosticContext.getHttpProxyHost(), (Object)"override.proxyHost.com");
        Assertions.assertEquals((int)diagnosticContext.getHttpProxyPort(), (int)80);
        Assertions.assertEquals((Object)diagnosticContext.getHttpsProxyHost(), (Object)"override.proxyHost.com");
        Assertions.assertEquals((int)diagnosticContext.getHttpsProxyPort(), (int)80);
        Assertions.assertEquals((Object)diagnosticContext.getHttpNonProxyHosts(), (Object)"*.new_domain.com|localhost");
    }

    @Test
    public void testGetProxy() {
        System.setProperty(HTTP_PROXY_HOST, "http.proxyHost.com");
        System.setProperty(HTTP_PROXY_PORT, "8080");
        System.setProperty(HTTPS_PROXY_HOST, "https.proxyHost.com");
        System.setProperty(HTTPS_PROXY_PORT, "8083");
        System.setProperty(HTTP_NON_PROXY_HOSTS, "*.domain.com|localhost|*.snowflakecomputing.com");
        HashMap connectionPropertiesMap = new HashMap();
        DiagnosticContext diagnosticContext = new DiagnosticContext(connectionPropertiesMap);
        String httpProxyHost = diagnosticContext.getHttpProxyHost();
        int httpProxyPort = diagnosticContext.getHttpProxyPort();
        String httpsProxyHost = diagnosticContext.getHttpsProxyHost();
        int httpsProxyPort = diagnosticContext.getHttpsProxyPort();
        SnowflakeEndpoint httpsHostBypassingProxy = new SnowflakeEndpoint("SNOWFLAKE_DEPLOYMENT", "account_name.snowflakecomputing.com", 443);
        SnowflakeEndpoint httpHostBypassingProxy = new SnowflakeEndpoint("OCSP_CACHE", "ocsp_cache.snowflakecomputing.com", 80);
        SnowflakeEndpoint hostWithHttpProxy = new SnowflakeEndpoint("OCSP_RESPONDER", "ocsp.rootg2.amazontrust.com", 80);
        SnowflakeEndpoint hostWithHttpsProxy = new SnowflakeEndpoint("STAGE", "stage-bucket.s3-us-west-2.amazonaws.com", 443);
        Proxy byPassProxy = Proxy.NO_PROXY;
        Proxy httpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, httpProxyPort));
        Proxy httpsProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpsProxyHost, httpsProxyPort));
        Assertions.assertEquals((Object)byPassProxy, (Object)diagnosticContext.getProxy(httpsHostBypassingProxy));
        Assertions.assertEquals((Object)byPassProxy, (Object)diagnosticContext.getProxy(httpHostBypassingProxy));
        Assertions.assertEquals((Object)httpProxy, (Object)diagnosticContext.getProxy(hostWithHttpProxy));
        Assertions.assertEquals((Object)httpsProxy, (Object)diagnosticContext.getProxy(hostWithHttpsProxy));
    }

    @Test
    public void testGetHttpProxyOnly() {
        System.setProperty(HTTP_PROXY_HOST, "http.proxyHost.com");
        System.setProperty(HTTP_PROXY_PORT, "8080");
        HashMap connectionPropertiesMap = new HashMap();
        DiagnosticContext diagnosticContext = new DiagnosticContext(connectionPropertiesMap);
        System.clearProperty(HTTP_PROXY_HOST);
        System.clearProperty(HTTP_PROXY_PORT);
        String httpProxyHost = diagnosticContext.getHttpProxyHost();
        int httpProxyPort = diagnosticContext.getHttpProxyPort();
        Proxy noProxy = Proxy.NO_PROXY;
        Proxy httpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, httpProxyPort));
        SnowflakeEndpoint httpsHostDirectConnection = new SnowflakeEndpoint("SNOWFLAKE_DEPLOYMENT", "account_name.snowflakecomputing.com", 443);
        SnowflakeEndpoint httpHostProxy = new SnowflakeEndpoint("OCSP_CACHE", "ocsp_cache.snowflakecomputing.com", 80);
        Assertions.assertEquals((Object)noProxy, (Object)diagnosticContext.getProxy(httpsHostDirectConnection));
        Assertions.assertEquals((Object)httpProxy, (Object)diagnosticContext.getProxy(httpHostProxy));
    }

    @Test
    public void testGetHttpsProxyOnly() {
        System.setProperty(HTTPS_PROXY_HOST, "https.proxyHost.com");
        System.setProperty(HTTPS_PROXY_PORT, "8083");
        HashMap connectionPropertiesMap = new HashMap();
        DiagnosticContext diagnosticContext = new DiagnosticContext(connectionPropertiesMap);
        String httpsProxyHost = diagnosticContext.getHttpsProxyHost();
        int httpsProxyPort = diagnosticContext.getHttpsProxyPort();
        Proxy noProxy = Proxy.NO_PROXY;
        Proxy httpsProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpsProxyHost, httpsProxyPort));
        SnowflakeEndpoint httpsHostProxy = new SnowflakeEndpoint("SNOWFLAKE_DEPLOYMENT", "account_name.snowflakecomputing.com", 443);
        SnowflakeEndpoint httpHostDirectConnection = new SnowflakeEndpoint("OCSP_CACHE", "ocsp_cache.snowflakecomputing.com", 80);
        Assertions.assertEquals((Object)noProxy, (Object)diagnosticContext.getProxy(httpHostDirectConnection));
        Assertions.assertEquals((Object)httpsProxy, (Object)diagnosticContext.getProxy(httpsHostProxy));
    }

    @Test
    public void testgetNoProxyAfterOverridingJvm() {
        System.setProperty(HTTPS_PROXY_HOST, "https.proxyHost.com");
        System.setProperty(HTTPS_PROXY_PORT, "8083");
        System.setProperty(HTTP_PROXY_HOST, "http.proxyHost.com");
        System.setProperty(HTTP_PROXY_PORT, "8080");
        HashMap<SFSessionProperty, String> connectionPropertiesMap = new HashMap<SFSessionProperty, String>();
        connectionPropertiesMap.put(SFSessionProperty.PROXY_HOST, "override.proxyHost.com");
        connectionPropertiesMap.put(SFSessionProperty.PROXY_PORT, "80");
        connectionPropertiesMap.put(SFSessionProperty.NON_PROXY_HOSTS, "*");
        DiagnosticContext diagnosticContext = new DiagnosticContext(connectionPropertiesMap);
        Proxy noProxy = Proxy.NO_PROXY;
        SnowflakeEndpoint host1 = new SnowflakeEndpoint("SNOWFLAKE_DEPLOYMENT", "account_name.snowflakecomputing.com", 443);
        SnowflakeEndpoint host2 = new SnowflakeEndpoint("OCSP_CACHE", "ocsp_cache.snowflakecomputing.com", 80);
        SnowflakeEndpoint host3 = new SnowflakeEndpoint("SNOWFLAKE_DEPLOYMENT", "account_name.privatelink.snowflakecomputing.com", 443);
        SnowflakeEndpoint host4 = new SnowflakeEndpoint("STAGE", "stage-bucket.s3-us-west-2.amazonaws.com", 443);
        Assertions.assertEquals((Object)noProxy, (Object)diagnosticContext.getProxy(host1));
        Assertions.assertEquals((Object)noProxy, (Object)diagnosticContext.getProxy(host2));
        Assertions.assertEquals((Object)noProxy, (Object)diagnosticContext.getProxy(host3));
        Assertions.assertEquals((Object)noProxy, (Object)diagnosticContext.getProxy(host4));
    }

    @AfterEach
    public void restoreJvmArguments() {
        System.clearProperty(HTTP_NON_PROXY_HOSTS);
        System.clearProperty(HTTP_PROXY_HOST);
        System.clearProperty(HTTP_PROXY_PORT);
        System.clearProperty(HTTPS_PROXY_HOST);
        System.clearProperty(HTTPS_PROXY_PORT);
        if (oldJvmNonProxyHosts != null) {
            System.setProperty(HTTP_NON_PROXY_HOSTS, oldJvmNonProxyHosts);
        }
        if (oldJvmHttpProxyHost != null) {
            System.setProperty(HTTP_PROXY_HOST, oldJvmHttpProxyHost);
        }
        if (oldJvmHttpProxyPort != null) {
            System.setProperty(HTTP_PROXY_PORT, oldJvmHttpProxyPort);
        }
        if (oldJvmHttpsProxyHost != null) {
            System.setProperty(HTTPS_PROXY_HOST, oldJvmHttpsProxyHost);
        }
        if (oldJvmHttpsProxyPort != null) {
            System.getProperty(HTTPS_PROXY_PORT, oldJvmHttpsProxyPort);
        }
    }
}

