/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.structuredtypes;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import net.snowflake.client.TestUtil;
import net.snowflake.client.ThrowingConsumer;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.structs.SnowflakeObjectTypeFactories;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.ResultSetFormatType;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.structuredtypes.sqldata.AllTypesClass;
import net.snowflake.client.jdbc.structuredtypes.sqldata.NestedStructSqlData;
import net.snowflake.client.jdbc.structuredtypes.sqldata.NullableFieldsSqlData;
import net.snowflake.client.jdbc.structuredtypes.sqldata.SimpleClass;
import net.snowflake.client.jdbc.structuredtypes.sqldata.StringClass;
import net.snowflake.client.providers.ResultFormatProvider;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="resultSet")
public class ResultSetStructuredTypesLatestIT
extends BaseJDBCTest {
    @BeforeEach
    public void setup() {
        SnowflakeObjectTypeFactories.register(StringClass.class, StringClass::new);
        SnowflakeObjectTypeFactories.register(SimpleClass.class, SimpleClass::new);
        SnowflakeObjectTypeFactories.register(AllTypesClass.class, AllTypesClass::new);
        SnowflakeObjectTypeFactories.register(NullableFieldsSqlData.class, NullableFieldsSqlData::new);
    }

    @AfterEach
    public void clean() {
        SnowflakeObjectTypeFactories.unregister(StringClass.class);
        SnowflakeObjectTypeFactories.unregister(SimpleClass.class);
        SnowflakeObjectTypeFactories.unregister(AllTypesClass.class);
        SnowflakeObjectTypeFactories.unregister(NullableFieldsSqlData.class);
    }

    public Connection init(ResultSetFormatType format) throws SQLException {
        Connection conn = BaseJDBCTest.getConnection(0);
        try (Statement stmt = conn.createStatement();){
            stmt.execute("alter session set ENABLE_STRUCTURED_TYPES_IN_CLIENT_RESPONSE = true");
            stmt.execute("alter session set IGNORE_CLIENT_VESRION_IN_STRUCTURED_TYPES_RESPONSE = true");
            stmt.execute("ALTER SESSION SET TIMEZONE = 'Europe/Warsaw'");
            stmt.execute("alter session set jdbc_query_result_format = '" + format.sessionParameterTypeValue + "'");
            if (format == ResultSetFormatType.NATIVE_ARROW) {
                stmt.execute("alter session set ENABLE_STRUCTURED_TYPES_NATIVE_ARROW_FORMAT = true");
                stmt.execute("alter session set FORCE_ENABLE_STRUCTURED_TYPES_NATIVE_ARROW_FORMAT = true");
            }
        }
        return conn;
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapStructToObjectWithFactory(ResultSetFormatType format) throws SQLException {
        this.testMapJson(true, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapStructToObjectWithReflection(ResultSetFormatType format) throws SQLException {
        this.testMapJson(false, format);
        this.testMapJson(true, format);
    }

    private void testMapJson(boolean registerFactory, ResultSetFormatType format) throws SQLException {
        if (registerFactory) {
            SnowflakeObjectTypeFactories.register(StringClass.class, StringClass::new);
        } else {
            SnowflakeObjectTypeFactories.unregister(StringClass.class);
        }
        this.withFirstRow("select {'string':'a'}::OBJECT(string VARCHAR)", resultSet -> {
            StringClass object = resultSet.getObject(1, StringClass.class);
            Assertions.assertEquals((Object)"a", (Object)object.getString());
        }, format);
        SnowflakeObjectTypeFactories.register(StringClass.class, StringClass::new);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapNullStruct(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("select null::OBJECT(string VARCHAR)", resultSet -> {
            StringClass object = resultSet.getObject(1, StringClass.class);
            Assertions.assertNull((Object)object);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapStructAllTypes(ResultSetFormatType format) throws SQLException {
        try (Connection connection = this.init(format);
             Statement statement = connection.createStatement();){
            statement.execute("ALTER SESSION SET TIMEZONE = 'Europe/Warsaw'");
            try (ResultSet resultSet = statement.executeQuery(AllTypesClass.ALL_TYPES_QUERY);){
                resultSet.next();
                AllTypesClass object = resultSet.getObject(1, AllTypesClass.class);
                Assertions.assertEquals((Object)"a", (Object)object.getString());
                Assertions.assertEquals((Byte)new Byte("1"), (Byte)object.getB());
                Assertions.assertEquals((Short)Short.valueOf("2"), (Short)object.getS());
                Assertions.assertEquals((Integer)3, (Integer)object.getI());
                Assertions.assertEquals((Long)4L, (Long)object.getL());
                Assertions.assertEquals((double)Float.valueOf(1.1f).floatValue(), (double)object.getF().floatValue(), (double)0.01);
                Assertions.assertEquals((double)2.2, (double)object.getD(), (double)0.01);
                Assertions.assertEquals((Object)BigDecimal.valueOf(3.3), (Object)object.getBd());
                Assertions.assertEquals((Object)LocalDateTime.of(2021, 12, 22, 9, 43, 44).atZone(ZoneId.of("Europe/Warsaw")).toInstant(), (Object)object.getTimestampLtz().toInstant());
                Assertions.assertEquals((Object)Timestamp.valueOf(LocalDateTime.of(2021, 12, 23, 9, 44, 44)), (Object)object.getTimestampNtz());
                Assertions.assertEquals((Object)LocalDateTime.of(2021, 12, 24, 2, 45, 45).atZone(ZoneId.of("Europe/Warsaw")).toInstant(), (Object)object.getTimestampTz().toInstant());
                Assertions.assertEquals((Object)Time.valueOf(LocalTime.of(12, 34, 56)), (Object)object.getTime());
                Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 99}, (byte[])object.getBinary());
                Assertions.assertTrue((boolean)object.getBool());
                Assertions.assertEquals((Object)"b", (Object)object.getSimpleClass().getString());
                Assertions.assertEquals((Integer)2, (Integer)object.getSimpleClass().getIntValue());
                if (format == ResultSetFormatType.NATIVE_ARROW) {
                    String expectedArrowGetStringResult = "{\"string\": \"a\",\"b\": 1,\"s\": 2,\"i\": 3,\"l\": 4,\"f\": 1.1,\"d\": 2.2,\"bd\": 3.3,\"bool\": true,\"timestamp_ltz\": \"Wed, 22 Dec 2021 09:43:44 +0100\",\"timestamp_ntz\": \"Thu, 23 Dec 2021 09:44:44 Z\",\"timestamp_tz\": \"Fri, 24 Dec 2021 09:45:45 +0800\",\"date\": \"2023-12-24\",\"time\": \"12:34:56\",\"binary\": \"616263\",\"simpleClass\": {\"string\": \"b\",\"intValue\": 2}}";
                    Assertions.assertEquals((Object)expectedArrowGetStringResult, (Object)resultSet.getString(1));
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnStructAsStringIfTypeWasNotIndicated(ResultSetFormatType format) throws SQLException {
        Assumptions.assumeTrue((format != ResultSetFormatType.NATIVE_ARROW ? 1 : 0) != 0);
        try (Connection connection = this.init(format);
             Statement statement = connection.createStatement();){
            statement.execute("alter session set TIMEZONE='Europe/Warsaw',TIME_OUTPUT_FORMAT = 'HH24:MI:SS',DATE_OUTPUT_FORMAT = 'YYYY-MM-DD',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='YYYY-MM-DD HH24:MI:SS.FF3 TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='YYYY-MM-DD HH24:MI:SS.FF3 TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='YYYY-MM-DD HH24:MI:SS.FF3 TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='YYYY-MM-DD HH24:MI:SS.FF3'");
            try (ResultSet resultSet = statement.executeQuery(AllTypesClass.ALL_TYPES_QUERY);){
                resultSet.next();
                String object = (String)resultSet.getObject(1);
                String expectedJson = "{\n  \"string\": \"a\",\n  \"b\": 1,\n  \"s\": 2,\n  \"i\": 3,\n  \"l\": 4,\n  \"f\": 1.100000000000000e+00,\n  \"d\": 2.200000000000000e+00,\n  \"bd\": 3.300000000000000e+00,\n  \"bool\": true,\n  \"timestamp_ltz\": \"2021-12-22 09:43:44.000 +0100\",\n  \"timestamp_ntz\": \"2021-12-23 09:44:44.000\",\n  \"timestamp_tz\": \"2021-12-24 09:45:45.000 +0800\",\n  \"date\": \"2023-12-24\",\n  \"time\": \"12:34:56\",\n  \"binary\": \"616263\",\n  \"simpleClass\": {\n    \"string\": \"b\",\n    \"intValue\": 2\n  }\n}";
                String expectedJsonFromArrow = "{\"string\": \"a\",\"b\": 1,\"s\": 2,\"i\": 3,\"l\": 4,\"f\": 1.1,\"d\": 2.2,\"bd\": 3.3,\"bool\": true,\"timestamp_ltz\": \"2021-12-22 09:43:44.000 +0100\",\"timestamp_ntz\": \"2021-12-23 09:44:44.000\",\"timestamp_tz\": \"2021-12-24 09:45:45.000 +0800\",\"date\": \"2023-12-24\",\"time\": \"12:34:56\",\"binary\": \"616263\",\"simpleClass\": {\"string\": \"b\",\"intValue\": 2}}";
                if (format == ResultSetFormatType.NATIVE_ARROW) {
                    Assert.assertEquals((Object)expectedJsonFromArrow, (Object)object);
                } else {
                    Assert.assertEquals((Object)expectedJson, (Object)object);
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsArrayOfSqlData(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT({'string':'one'}, {'string':'two'}, {'string':'three'})::ARRAY(OBJECT(string VARCHAR))", resultSet -> {
            StringClass[] resultArray = (StringClass[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, StringClass.class);
            Assertions.assertEquals((Object)"one", (Object)resultArray[0].getString());
            Assertions.assertEquals((Object)"two", (Object)resultArray[1].getString());
            Assertions.assertEquals((Object)"three", (Object)resultArray[2].getString());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsArrayOfNullableFieldsInSqlData(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT OBJECT_CONSTRUCT_KEEP_NULL('string', null, 'nullableIntValue', null, 'nullableLongValue', null, 'date', null, 'bd', null, 'bytes', null, 'longValue', null)::OBJECT(string VARCHAR, nullableIntValue INTEGER, nullableLongValue INTEGER, date DATE, bd DOUBLE, bytes BINARY, longValue INTEGER)", resultSet -> {
            NullableFieldsSqlData result = resultSet.getObject(1, NullableFieldsSqlData.class);
            Assertions.assertNull((Object)result.getString());
            Assertions.assertNull((Object)result.getNullableIntValue());
            Assertions.assertNull((Object)result.getNullableLongValue());
            Assertions.assertNull((Object)result.getDate());
            Assertions.assertNull((Object)result.getBd());
            Assertions.assertNull((Object)result.getBytes());
            Assertions.assertEquals((Long)0L, (Long)result.getLongValue());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnNullsForAllTpesInSqlData(ResultSetFormatType format) throws SQLException {
        try (Connection connection = this.init(format);
             Statement statement = connection.createStatement();){
            statement.execute("ALTER SESSION SET TIMEZONE = 'Europe/Warsaw'");
            try (ResultSet resultSet = statement.executeQuery("SELECT OBJECT_CONSTRUCT_KEEP_NULL('string', null, 'b', null, 's', null, 'i', null, 'l', null, 'f', null,'d', null, 'bd', null, 'bool', null, 'timestamp_ltz', null, 'timestamp_ntz', null, 'timestamp_tz', null, 'date', null, 'time', null, 'binary', null, 'StringClass', null)::OBJECT(string VARCHAR, b TINYINT, s SMALLINT, i INTEGER, l BIGINT, f FLOAT, d DOUBLE, bd DOUBLE, bool BOOLEAN, timestamp_ltz TIMESTAMP_LTZ, timestamp_ntz TIMESTAMP_NTZ, timestamp_tz TIMESTAMP_TZ, date DATE, time TIME, binary BINARY, StringClass OBJECT(string VARCHAR))");){
                resultSet.next();
                AllTypesClass object = resultSet.getObject(1, AllTypesClass.class);
                Assertions.assertNull((Object)object.getString());
                Assertions.assertNull((Object)object.getB());
                Assertions.assertNull((Object)object.getS());
                Assertions.assertNull((Object)object.getI());
                Assertions.assertNull((Object)object.getL());
                Assertions.assertNull((Object)object.getF());
                Assertions.assertNull((Object)object.getD());
                Assertions.assertNull((Object)object.getBd());
                Assertions.assertNull((Object)object.getTimestampLtz());
                Assertions.assertNull((Object)object.getTimestampNtz());
                Assertions.assertNull((Object)object.getTimestampTz());
                Assertions.assertNull((Object)object.getDate());
                Assertions.assertNull((Object)object.getTime());
                Assertions.assertNull((Object)object.getBinary());
                Assertions.assertNull((Object)object.getBool());
                Assertions.assertNull((Object)object.getSimpleClass());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsArrayOfString(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT('one', 'two','three')::ARRAY(VARCHAR)", resultSet -> {
            String[] resultArray = (String[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, String.class);
            Assertions.assertEquals((Object)"one", (Object)resultArray[0]);
            Assertions.assertEquals((Object)"two", (Object)resultArray[1]);
            Assertions.assertEquals((Object)"three", (Object)resultArray[2]);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsArrayOfNullableString(ResultSetFormatType format) throws SQLException {
        Assumptions.assumeTrue((format == ResultSetFormatType.NATIVE_ARROW ? 1 : 0) != 0);
        this.withFirstRow("SELECT ARRAY_CONSTRUCT('one', 'two', null)::ARRAY(VARCHAR)", resultSet -> {
            String[] resultArray = (String[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, String.class);
            Assertions.assertEquals((Object)"one", (Object)resultArray[0]);
            Assertions.assertEquals((Object)"two", (Object)resultArray[1]);
            Assertions.assertNull((Object)resultArray[2]);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnNullAsArray(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT null::ARRAY(VARCHAR)", resultSet -> {
            String[] resultArray = (String[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, String.class);
            Assertions.assertNull((Object)resultArray);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsListOfIntegers(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(1,2,3)::ARRAY(INTEGER)", resultSet -> {
            List resultList = resultSet.unwrap(SnowflakeBaseResultSet.class).getList(1, Integer.class);
            Assertions.assertEquals((Integer)1, (Integer)((Integer)resultList.get(0)));
            Assertions.assertEquals((Integer)2, (Integer)((Integer)resultList.get(1)));
            Assertions.assertEquals((Integer)3, (Integer)((Integer)resultList.get(2)));
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsListOfFloat(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(1.1,2.2,3.3)::ARRAY(FLOAT)", resultSet -> {
            Float[] resultList = (Float[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, Float.class);
            Assertions.assertEquals((Float)Float.valueOf(1.1f), (Float)resultList[0]);
            Assertions.assertEquals((Float)Float.valueOf(2.2f), (Float)resultList[1]);
            Assertions.assertEquals((Float)Float.valueOf(3.3f), (Float)resultList[2]);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsListOfDouble(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(1.1,2.2,3.3)::ARRAY(DOUBLE)", resultSet -> {
            List resultList = resultSet.unwrap(SnowflakeBaseResultSet.class).getList(1, Double.class);
            Assertions.assertEquals((Double)1.1, (Double)((Double)resultList.get(0)));
            Assertions.assertEquals((Double)2.2, (Double)((Double)resultList.get(1)));
            Assertions.assertEquals((Double)3.3, (Double)((Double)resultList.get(2)));
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsMap(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("select {'x':{'string':'one'},'y':{'string':'two'},'z':{'string':'three'}}::MAP(VARCHAR, OBJECT(string VARCHAR));", resultSet -> {
            Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, StringClass.class);
            Assertions.assertEquals((Object)"one", (Object)((StringClass)map.get("x")).getString());
            Assertions.assertEquals((Object)"two", (Object)((StringClass)map.get("y")).getString());
            Assertions.assertEquals((Object)"three", (Object)((StringClass)map.get("z")).getString());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsMapByGetObject(ResultSetFormatType format) throws SQLException {
        Assumptions.assumeTrue((format != ResultSetFormatType.NATIVE_ARROW ? 1 : 0) != 0);
        this.withFirstRow("select {'x':{'string':'one'},'y':{'string':'two'},'z':{'string':'three'}}::MAP(VARCHAR, OBJECT(string VARCHAR));", resultSet -> {
            Map map = resultSet.getObject(1, Map.class);
            Assertions.assertEquals((Object)"one", ((Map)map.get("x")).get("string"));
            Assertions.assertEquals((Object)"two", ((Map)map.get("y")).get("string"));
            Assertions.assertEquals((Object)"three", ((Map)map.get("z")).get("string"));
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsMapWithNullableValues(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("select {'x':{'string':'one'},'y':null,'z':{'string':'three'}}::MAP(VARCHAR, OBJECT(string VARCHAR));", resultSet -> {
            Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, StringClass.class);
            Assertions.assertEquals((Object)"one", (Object)((StringClass)map.get("x")).getString());
            Assertions.assertNull(map.get("y"));
            Assertions.assertEquals((Object)"three", (Object)((StringClass)map.get("z")).getString());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnNullAsObjectOfTypeMap(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("select null::MAP(VARCHAR, OBJECT(string VARCHAR));", resultSet -> {
            Map map = (Map)resultSet.unwrap(SnowflakeBaseResultSet.class).getObject(1, Map.class);
            Assertions.assertNull((Object)map);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnNullAsMap(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("select null::MAP(VARCHAR, OBJECT(string VARCHAR));", resultSet -> {
            Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, StringClass.class);
            Assertions.assertNull((Object)map);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsMapOfTimestampsNtz(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT {'x': TO_TIMESTAMP_NTZ('2021-12-23 09:44:44'), 'y': TO_TIMESTAMP_NTZ('2021-12-24 09:55:55')}::MAP(VARCHAR, TIMESTAMP)", resultSet -> {
            Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, Timestamp.class);
            Assertions.assertEquals((Object)LocalDateTime.of(2021, 12, 23, 9, 44, 44).atZone(ZoneId.of("Europe/Warsaw")).toInstant(), (Object)((Timestamp)map.get("x")).toInstant());
            Assertions.assertEquals((Object)LocalDateTime.of(2021, 12, 24, 9, 55, 55).atZone(ZoneId.of("Europe/Warsaw")).toInstant(), (Object)((Timestamp)map.get("y")).toInstant());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsMapOfTimestampsLtz(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT {'x': TO_TIMESTAMP_LTZ('2021-12-23 09:44:44'), 'y': TO_TIMESTAMP_LTZ('2021-12-24 09:55:55')}::MAP(VARCHAR, TIMESTAMP_LTZ)", resultSet -> {
            Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, Timestamp.class);
            Assertions.assertEquals((Object)LocalDateTime.of(2021, 12, 23, 9, 44, 44).atZone(ZoneId.of("Europe/Warsaw")).toInstant(), (Object)((Timestamp)map.get("x")).toInstant());
            Assertions.assertEquals((Object)LocalDateTime.of(2021, 12, 24, 9, 55, 55).atZone(ZoneId.of("Europe/Warsaw")).toInstant(), (Object)((Timestamp)map.get("y")).toInstant());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsMapOfLong(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT {'x':1, 'y':2, 'z':3}::MAP(VARCHAR, BIGINT)", resultSet -> {
            Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, Long.class);
            Assertions.assertEquals((Long)1L, (Long)((Long)map.get("x")));
            Assertions.assertEquals((Long)2L, (Long)((Long)map.get("y")));
            Assertions.assertEquals((Long)3L, (Long)((Long)map.get("z")));
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsMapOfDate(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT {'x':'2023-12-24', 'y':'2023-12-25'}::MAP(VARCHAR, DATE)", resultSet -> {
            Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, Date.class);
            Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 12, 24)).toString(), (Object)((Date)map.get("x")).toString());
            Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 12, 25)).toString(), (Object)((Date)map.get("y")).toString());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsMapOfTime(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT {'x':'12:34:56', 'y':'12:34:58'}::MAP(VARCHAR, TIME)", resultSet -> {
            Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, Time.class);
            Assertions.assertEquals((Object)Time.valueOf(LocalTime.of(12, 34, 56)), map.get("x"));
            Assertions.assertEquals((Object)Time.valueOf(LocalTime.of(12, 34, 58)), map.get("y"));
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsMapOfBoolean(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT {'x':'true', 'y':0}::MAP(VARCHAR, BOOLEAN)", resultSet -> {
            Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, Boolean.class);
            Assertions.assertEquals((Object)Boolean.TRUE, map.get("x"));
            Assertions.assertEquals((Object)Boolean.FALSE, map.get("y"));
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testReturnAsList(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("select [{'string':'one'},{'string': 'two'}]::ARRAY(OBJECT(string varchar))", resultSet -> {
            List map = resultSet.unwrap(SnowflakeBaseResultSet.class).getList(1, StringClass.class);
            Assertions.assertEquals((Object)"one", (Object)((StringClass)map.get(0)).getString());
            Assertions.assertEquals((Object)"two", (Object)((StringClass)map.get(1)).getString());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapStructsFromChunks(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("select {'string':'a'}::OBJECT(string VARCHAR) FROM TABLE(GENERATOR(ROWCOUNT=>30000))", resultSet -> {
            while (resultSet.next()) {
                StringClass object = resultSet.getObject(1, StringClass.class);
                Assertions.assertEquals((Object)"a", (Object)object.getString());
            }
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapIntegerArray(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(10, 20, 30)::ARRAY(INTEGER)", resultSet -> {
            Long[] resultArray = (Long[])resultSet.getArray(1).getArray();
            Assertions.assertEquals((Long)10L, (Long)resultArray[0]);
            Assertions.assertEquals((Long)20L, (Long)resultArray[1]);
            Assertions.assertEquals((Long)30L, (Long)resultArray[2]);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapIntegerArrayGetObject(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(10, 20, 30)::ARRAY(INTEGER)", resultSet -> {
            Object resultArray = resultSet.getObject(1);
            TestUtil.assertEqualsIgnoringWhitespace("[10,20,30]", (String)resultArray);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapFixedToLongArray(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(10, 20, 30)::ARRAY(SMALLINT)", resultSet -> {
            Long[] resultArray = (Long[])resultSet.getArray(1).getArray();
            Assertions.assertEquals((Long)Long.valueOf("10"), (Long)resultArray[0]);
            Assertions.assertEquals((Long)Long.valueOf("20"), (Long)resultArray[1]);
            Assertions.assertEquals((Long)Long.valueOf("30"), (Long)resultArray[2]);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapDecimalArray(ResultSetFormatType format) throws SQLException {
        Number[] resultArray;
        ResultSet resultSet;
        Statement statement;
        try (Connection connection = this.init(format);){
            statement = connection.createStatement();
            try {
                resultSet = statement.executeQuery("SELECT ARRAY_CONSTRUCT(10.2, 20.02, 30)::ARRAY(DECIMAL(20,0))");
                try {
                    resultSet.next();
                    resultArray = (Long[])resultSet.getArray(1).getArray();
                    Assertions.assertEquals((Long)resultArray[0], (Long)10L);
                    Assertions.assertEquals((Long)resultArray[1], (Long)20L);
                    Assertions.assertEquals((Long)resultArray[2], (Long)30L);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        connection = this.init(format);
        try {
            statement = connection.createStatement();
            try {
                resultSet = statement.executeQuery("SELECT ARRAY_CONSTRUCT(10.2, 20.02, 30)::ARRAY(DECIMAL(20,2))");
                try {
                    resultSet.next();
                    BigDecimal[] resultArray2 = (BigDecimal[])resultSet.getArray(1).getArray();
                    Assertions.assertEquals((double)BigDecimal.valueOf(10.2).doubleValue(), (double)resultArray2[0].doubleValue(), (double)0.0);
                    Assertions.assertEquals((double)BigDecimal.valueOf(20.02).doubleValue(), (double)resultArray2[1].doubleValue(), (double)0.0);
                    Assertions.assertEquals((double)BigDecimal.valueOf(30.0).doubleValue(), (double)resultArray2[2].doubleValue(), (double)0.0);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.init(format);
        try {
            statement = connection.createStatement();
            try {
                statement.execute("alter session set jdbc_treat_decimal_as_int = false");
                resultSet = statement.executeQuery("SELECT ARRAY_CONSTRUCT(10.2, 20.02, 30)::ARRAY(DECIMAL(20,0))");
                try {
                    resultSet.next();
                    resultArray = (BigDecimal[])resultSet.getArray(1).getArray();
                    Assertions.assertEquals((Object)BigDecimal.valueOf(10L), (Object)resultArray[0]);
                    Assertions.assertEquals((Object)BigDecimal.valueOf(20L), (Object)resultArray[1]);
                    Assertions.assertEquals((Object)BigDecimal.valueOf(30L), (Object)resultArray[2]);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapVarcharArray(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT 'text', ARRAY_CONSTRUCT('10', '20','30')::ARRAY(VARCHAR)", resultSet -> {
            String t = resultSet.getString(1);
            String[] resultArray = (String[])resultSet.getArray(2).getArray();
            Assertions.assertEquals((Object)"10", (Object)resultArray[0]);
            Assertions.assertEquals((Object)"20", (Object)resultArray[1]);
            Assertions.assertEquals((Object)"30", (Object)resultArray[2]);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapDatesArray(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(to_date('2023-12-24', 'YYYY-MM-DD'), to_date('2023-12-25', 'YYYY-MM-DD'))::ARRAY(DATE)", resultSet -> {
            Date[] resultArray = (Date[])resultSet.getArray(1).getArray();
            Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 12, 24)).toString(), (Object)resultArray[0].toString());
            Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 12, 25)).toString(), (Object)resultArray[1].toString());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapTimeArray(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(to_time('15:39:20.123'), to_time('09:12:20.123'))::ARRAY(TIME)", resultSet -> {
            Time[] resultArray = (Time[])resultSet.getArray(1).getArray();
            Assertions.assertEquals((Object)Time.valueOf(LocalTime.of(15, 39, 20)).toString(), (Object)resultArray[0].toString());
            Assertions.assertEquals((Object)Time.valueOf(LocalTime.of(9, 12, 20)).toString(), (Object)resultArray[1].toString());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapTimestampArray(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(TO_TIMESTAMP_NTZ('2021-12-23 09:44:44'), TO_TIMESTAMP_NTZ('2021-12-24 09:55:55'))::ARRAY(TIMESTAMP)", resultSet -> {
            Timestamp[] resultArray = (Timestamp[])resultSet.getArray(1).getArray();
            Assertions.assertEquals((Object)LocalDateTime.of(2021, 12, 23, 9, 44, 44).atZone(ZoneId.of("Europe/Warsaw")).toInstant(), (Object)resultArray[0].toInstant());
            Assertions.assertEquals((Object)LocalDateTime.of(2021, 12, 24, 9, 55, 55).atZone(ZoneId.of("Europe/Warsaw")).toInstant(), (Object)resultArray[1].toInstant());
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapBooleanArray(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(true,false)::ARRAY(BOOLEAN)", resultSet -> {
            Boolean[] resultArray = (Boolean[])resultSet.getArray(1).getArray();
            Assertions.assertEquals((Object)true, (Object)resultArray[0]);
            Assertions.assertEquals((Object)false, (Object)resultArray[1]);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapBinaryArray(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(TO_BINARY('616263', 'HEX'),TO_BINARY('616263', 'HEX'))::ARRAY(BINARY)", resultSet -> {
            Byte[][] resultArray = (Byte[][])resultSet.getArray(1).getArray();
            Assertions.assertArrayEquals((Object[])new Byte[]{(byte)97, (byte)98, (byte)99}, (Object[])resultArray[0]);
            Assertions.assertArrayEquals((Object[])new Byte[]{(byte)97, (byte)98, (byte)99}, (Object[])resultArray[1]);
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapArrayOfStructToMap(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT({'x': 'abc', 'y': 1}, {'x': 'def', 'y': 2} )::ARRAY(OBJECT(x VARCHAR, y INTEGER))", resultSet -> {
            Map[] resultArray = (Map[])resultSet.getArray(1).getArray();
            Map firstEntry = resultArray[0];
            Map secondEntry = resultArray[1];
            Assertions.assertEquals((Object)firstEntry.get("x").toString(), (Object)"abc");
            Assertions.assertEquals((Object)firstEntry.get("y").toString(), (Object)"1");
            Assertions.assertEquals((Object)secondEntry.get("x").toString(), (Object)"def");
            Assertions.assertEquals((Object)secondEntry.get("y").toString(), (Object)"2");
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapArrayOfArrays(ResultSetFormatType format) throws SQLException {
        this.withFirstRow("SELECT ARRAY_CONSTRUCT(ARRAY_CONSTRUCT({'x': 'abc', 'y': 1}, {'x': 'def', 'y': 2}) )::ARRAY(ARRAY(OBJECT(x VARCHAR, y INTEGER)))", resultSet -> {
            Map[][] resultArray = (Map[][])resultSet.getArray(1).getArray();
            Map firstEntry = resultArray[0][0];
            Map secondEntry = resultArray[0][1];
            Assertions.assertEquals((Object)firstEntry.get("x").toString(), (Object)"abc");
            Assertions.assertEquals((Object)firstEntry.get("y").toString(), (Object)"1");
            Assertions.assertEquals((Object)secondEntry.get("x").toString(), (Object)"def");
            Assertions.assertEquals((Object)secondEntry.get("y").toString(), (Object)"2");
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testMapNestedStructures(ResultSetFormatType format) throws SQLException {
        String structSelectStatement = "SELECT {'simpleClass': {'string': 'a', 'intValue': 2}, 'simpleClasses': ARRAY_CONSTRUCT({'string': 'a', 'intValue': 2}, {'string': 'b', 'intValue': 2}), 'arrayOfSimpleClasses': ARRAY_CONSTRUCT({'string': 'a', 'intValue': 2}, {'string': 'b', 'intValue': 2}), 'mapOfSimpleClasses':{'x':{'string': 'c', 'intValue': 2}, 'y':{'string': 'd', 'intValue': 2}},'texts': ARRAY_CONSTRUCT('string', 'a'), 'arrayOfDates': ARRAY_CONSTRUCT(to_date('2023-12-24', 'YYYY-MM-DD'), to_date('2023-12-25', 'YYYY-MM-DD')), 'mapOfIntegers':{'x':3, 'y':4}}::OBJECT(simpleClass OBJECT(string VARCHAR, intValue INTEGER), simpleClasses ARRAY(OBJECT(string VARCHAR, intValue INTEGER)),arrayOfSimpleClasses ARRAY(OBJECT(string VARCHAR, intValue INTEGER)),mapOfSimpleClasses MAP(VARCHAR, OBJECT(string VARCHAR, intValue INTEGER)),texts ARRAY(VARCHAR),arrayOfDates ARRAY(DATE),mapOfIntegers MAP(VARCHAR, INTEGER))";
        String expectedQueryResult = "{\"simpleClass\": {\"string\": \"a\",\"intValue\": 2},\"simpleClasses\": [{\"string\": \"a\",\"intValue\": 2},{\"string\": \"b\",\"intValue\": 2}],\"arrayOfSimpleClasses\": [{\"string\": \"a\",\"intValue\": 2},{\"string\": \"b\",\"intValue\": 2}],\"mapOfSimpleClasses\": {\"x\": {\"string\": \"c\",\"intValue\": 2},\"y\": {\"string\": \"d\",\"intValue\": 2}},\"texts\": [\"string\",\"a\"],\"arrayOfDates\": [\"2023-12-24\",\"2023-12-25\"],\"mapOfIntegers\": {\"x\": 3,\"y\": 4}}";
        this.withFirstRow(structSelectStatement, resultSet -> {
            NestedStructSqlData nestedStructSqlData = resultSet.getObject(1, NestedStructSqlData.class);
            Assertions.assertEquals((Object)"a", (Object)nestedStructSqlData.getSimpleClass().getString());
            Assertions.assertEquals((Integer)2, (Integer)nestedStructSqlData.getSimpleClass().getIntValue());
            Assertions.assertEquals((Object)"a", (Object)nestedStructSqlData.getSimpleClassses().get(0).getString());
            Assertions.assertEquals((Integer)2, (Integer)nestedStructSqlData.getSimpleClassses().get(0).getIntValue());
            Assertions.assertEquals((Object)"b", (Object)nestedStructSqlData.getSimpleClassses().get(1).getString());
            Assertions.assertEquals((Integer)2, (Integer)nestedStructSqlData.getSimpleClassses().get(1).getIntValue());
            Assertions.assertEquals((Object)"a", (Object)nestedStructSqlData.getArrayOfSimpleClasses()[0].getString());
            Assertions.assertEquals((Integer)2, (Integer)nestedStructSqlData.getArrayOfSimpleClasses()[0].getIntValue());
            Assertions.assertEquals((Object)"b", (Object)nestedStructSqlData.getArrayOfSimpleClasses()[1].getString());
            Assertions.assertEquals((Integer)2, (Integer)nestedStructSqlData.getArrayOfSimpleClasses()[1].getIntValue());
            Assertions.assertEquals((Object)"c", (Object)nestedStructSqlData.getMapOfSimpleClasses().get("x").getString());
            Assertions.assertEquals((Integer)2, (Integer)nestedStructSqlData.getMapOfSimpleClasses().get("x").getIntValue());
            Assertions.assertEquals((Object)"d", (Object)nestedStructSqlData.getMapOfSimpleClasses().get("y").getString());
            Assertions.assertEquals((Integer)2, (Integer)nestedStructSqlData.getMapOfSimpleClasses().get("y").getIntValue());
            Assertions.assertEquals((Object)"string", (Object)nestedStructSqlData.getTexts().get(0));
            Assertions.assertEquals((Object)"a", (Object)nestedStructSqlData.getTexts().get(1));
            Assertions.assertEquals((Integer)3, (Integer)nestedStructSqlData.getMapOfIntegers().get("x"));
            Assertions.assertEquals((Integer)4, (Integer)nestedStructSqlData.getMapOfIntegers().get("y"));
            TestUtil.assertEqualsIgnoringWhitespace(expectedQueryResult, resultSet.getString(1));
        }, format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testColumnTypeWhenStructureTypeIsDisabled(ResultSetFormatType format) throws Exception {
        this.withFirstRow("SELECT {'string':'a'}", resultSet -> Assertions.assertEquals((int)12, (int)resultSet.getMetaData().getColumnType(1)), format);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testColumnTypeAndFieldsWhenStructureTypeIsReturned(ResultSetFormatType format) throws Exception {
        this.withFirstRow("SELECT {'string':'a'}::OBJECT(string VARCHAR)", resultSet -> {
            Assertions.assertEquals((int)2002, (int)resultSet.getMetaData().getColumnType(1));
            Assertions.assertEquals((int)1, (int)resultSet.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getColumnFields(1).size());
            Assertions.assertEquals((Object)"VARCHAR", (Object)((FieldMetadata)resultSet.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getColumnFields(1).get(0)).getTypeName());
            Assertions.assertEquals((Object)"string", (Object)((FieldMetadata)resultSet.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getColumnFields(1).get(0)).getName());
        }, format);
    }

    private void withFirstRow(String sqlText, ThrowingConsumer<ResultSet, SQLException> consumer, ResultSetFormatType format) throws SQLException {
        try (Connection connection = this.init(format);
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery(sqlText);){
            Assertions.assertTrue((boolean)rs.next());
            consumer.accept(rs);
        }
    }
}

