/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryOOB;

import java.util.HashMap;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TelemetryServiceTest {
    private boolean defaultState;

    @BeforeEach
    public void setUp() {
        TelemetryService service = TelemetryService.getInstance();
        this.defaultState = service.isEnabled();
        service.enable();
    }

    @AfterEach
    public void tearDown() throws InterruptedException {
        TelemetryService service = TelemetryService.getInstance();
        if (this.defaultState) {
            service.enable();
        } else {
            service.disable();
        }
    }

    @Test
    public void testTelemetryInitErrors() {
        TelemetryService service = TelemetryService.getInstance();
        MatcherAssert.assertThat((String)"Telemetry server failure count should be zero at first.", (Object)service.getServerFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"Telemetry client failure count should be zero at first.", (Object)service.getClientFailureCount(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testTelemetryEnableDisable() {
        TelemetryService service = TelemetryService.getInstance();
        MatcherAssert.assertThat((String)"Telemetry should be already enabled here.", (Object)service.isEnabled(), (Matcher)CoreMatchers.equalTo((Object)true));
        service.disable();
        MatcherAssert.assertThat((String)"Telemetry should be already disabled here.", (Object)service.isEnabled(), (Matcher)CoreMatchers.equalTo((Object)false));
        service.enable();
        MatcherAssert.assertThat((String)"Telemetry should be enabled back", (Object)service.isEnabled(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testTelemetryConnectionString() {
        String INVALID_CONNECTION_STRING = "://:-1";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uri", "jdbc:snowflake://snowflake.reg.local:8082");
        param.put("host", "snowflake.reg.local");
        param.put("port", "8082");
        param.put("account", "fakeaccount");
        param.put("user", "fakeuser");
        param.put("password", "fakepassword");
        param.put("database", "fakedatabase");
        param.put("schema", "fakeschema");
        param.put("role", "fakerole");
        TelemetryService service = TelemetryService.getInstance();
        service.updateContextForIT(param);
        MatcherAssert.assertThat((String)"Telemetry failed to generate sfConnectionStr.", (Object)service.getSnowflakeConnectionString().toString(), (Matcher)CoreMatchers.not((Object)INVALID_CONNECTION_STRING));
    }
}

