/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.loader.LoadResultListener;
import net.snowflake.client.loader.LoaderFactory;
import net.snowflake.client.loader.LoaderProperty;
import net.snowflake.client.loader.LoadingError;
import net.snowflake.client.loader.Operation;
import net.snowflake.client.loader.StreamLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="loader")
public class FlatfileReadMultithreadIT {
    private final int NUM_RECORDS = 100000;
    private static final String TARGET_STAGE = "STAGE_MULTITHREAD_LOADER";
    private static String TARGET_SCHEMA;
    private static String TARGET_DB;

    @BeforeAll
    public static void setUpClass() throws Throwable {
        try (Connection testConnection = AbstractDriverIT.getConnection();
             Statement statement = testConnection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE STAGE %s", TARGET_STAGE));
            TARGET_SCHEMA = testConnection.getSchema();
            TARGET_DB = testConnection.getCatalog();
        }
    }

    @AfterAll
    public static void tearDownClass() throws Throwable {
        try (Connection testConnection = AbstractDriverIT.getConnection();
             Statement statement = testConnection.createStatement();){
            statement.execute(String.format("DROP STAGE IF EXISTS %s", TARGET_STAGE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIssueSimpleDateFormat() throws Throwable {
        String targetTable = "TABLE_ISSUE_SIMPLEDATEFORMAT";
        try (Connection testConnection = AbstractDriverIT.getConnection();
             Statement statement = testConnection.createStatement();){
            try {
                statement.execute(String.format("CREATE OR REPLACE TABLE %s.%s.%s (ID int, C1 timestamp)", TARGET_DB, TARGET_SCHEMA, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
                Thread t1 = new Thread(new FlatfileRead(100000, TARGET_DB, TARGET_SCHEMA, TARGET_STAGE, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
                Thread t2 = new Thread(new FlatfileRead(100000, TARGET_DB, TARGET_SCHEMA, TARGET_STAGE, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
                t1.start();
                t2.start();
                t1.join();
                t2.join();
                try (ResultSet rs = statement.executeQuery(String.format("select count(*) from %s.%s.%s", TARGET_DB, TARGET_SCHEMA, "TABLE_ISSUE_SIMPLEDATEFORMAT"));){
                    rs.next();
                    MatcherAssert.assertThat((String)"total number of records", (Object)rs.getInt(1), (Matcher)CoreMatchers.equalTo((Object)200000));
                }
            }
            catch (Throwable throwable) {
                statement.execute(String.format("DROP TABLE IF EXISTS %s.%s.%s", TARGET_DB, TARGET_SCHEMA, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
                throw throwable;
            }
            statement.execute(String.format("DROP TABLE IF EXISTS %s.%s.%s", TARGET_DB, TARGET_SCHEMA, "TABLE_ISSUE_SIMPLEDATEFORMAT"));
        }
    }

    class FlatfileRead
    implements Runnable {
        private final int totalRows;
        private final String dbName;
        private final String schemaName;
        private final String tableName;
        private final String stageName;

        FlatfileRead(int totalRows, String dbName, String schemaName, String stageName, String tableName) {
            this.totalRows = totalRows;
            this.dbName = dbName;
            this.schemaName = schemaName;
            this.stageName = stageName;
            this.tableName = tableName;
        }

        @Override
        public void run() {
            try (Connection testConnection = AbstractDriverIT.getConnection();
                 Connection putConnection = AbstractDriverIT.getConnection();){
                ResultListener _resultListener = new ResultListener();
                HashMap<LoaderProperty, String> prop = new HashMap<LoaderProperty, String>();
                prop.put(LoaderProperty.tableName, this.tableName);
                prop.put(LoaderProperty.schemaName, this.schemaName);
                prop.put(LoaderProperty.databaseName, this.dbName);
                prop.put(LoaderProperty.remoteStage, this.stageName);
                prop.put(LoaderProperty.operation, (String)Operation.INSERT);
                StreamLoader underTest = (StreamLoader)LoaderFactory.createLoader(prop, (Connection)putConnection, (Connection)testConnection);
                underTest.setProperty(LoaderProperty.startTransaction, (Object)true);
                underTest.setProperty(LoaderProperty.truncateTable, (Object)false);
                underTest.setProperty(LoaderProperty.columns, Arrays.asList("ID", "C1"));
                underTest.setListener((LoadResultListener)_resultListener);
                underTest.start();
                Random rnd = new Random();
                for (int i = 0; i < this.totalRows; ++i) {
                    Object[] row = new Object[2];
                    row[0] = i;
                    long ms = -946771200000L + Math.abs(rnd.nextLong()) % 2207520000000L;
                    row[1] = new Date(ms);
                    underTest.submitRow(row);
                }
                try {
                    underTest.finish();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                underTest.close();
                MatcherAssert.assertThat((String)"must be no error", (Object)_resultListener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)0));
                MatcherAssert.assertThat((String)"total number of rows", (Object)_resultListener.getSubmittedRowCount(), (Matcher)CoreMatchers.equalTo((Object)this.totalRows));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }

        class ResultListener
        implements LoadResultListener {
            private final List<LoadingError> errors = new ArrayList<LoadingError>();
            private final AtomicInteger errorCount = new AtomicInteger(0);
            private final AtomicInteger errorRecordCount = new AtomicInteger(0);
            private final AtomicInteger counter = new AtomicInteger(0);
            private final AtomicInteger processed = new AtomicInteger(0);
            private final AtomicInteger deleted = new AtomicInteger(0);
            private final AtomicInteger updated = new AtomicInteger(0);
            private final AtomicInteger submittedRowCount = new AtomicInteger(0);
            private Object[] lastRecord = null;
            public boolean throwOnError = false;

            ResultListener() {
            }

            public boolean needErrors() {
                return true;
            }

            public boolean needSuccessRecords() {
                return true;
            }

            public void addError(LoadingError error) {
                this.errors.add(error);
            }

            public boolean throwOnError() {
                return this.throwOnError;
            }

            public List<LoadingError> getErrors() {
                return this.errors;
            }

            public void recordProvided(Operation op, Object[] record) {
                this.lastRecord = record;
            }

            public void addProcessedRecordCount(Operation op, int i) {
                this.processed.addAndGet(i);
            }

            public void addOperationRecordCount(Operation op, int i) {
                this.counter.addAndGet(i);
                if (op == Operation.DELETE) {
                    this.deleted.addAndGet(i);
                } else if (op == Operation.MODIFY || op == Operation.UPSERT) {
                    this.updated.addAndGet(i);
                }
            }

            public Object[] getLastRecord() {
                return this.lastRecord;
            }

            public int getErrorCount() {
                return this.errorCount.get();
            }

            public int getErrorRecordCount() {
                return this.errorRecordCount.get();
            }

            public void resetErrorCount() {
                this.errorCount.set(0);
            }

            public void resetErrorRecordCount() {
                this.errorRecordCount.set(0);
            }

            public void addErrorCount(int count) {
                this.errorCount.addAndGet(count);
            }

            public void addErrorRecordCount(int count) {
                this.errorRecordCount.addAndGet(count);
            }

            public void resetSubmittedRowCount() {
                this.submittedRowCount.set(0);
            }

            public void addSubmittedRowCount(int count) {
                this.submittedRowCount.addAndGet(count);
            }

            public int getSubmittedRowCount() {
                return this.submittedRowCount.get();
            }
        }
    }
}

