/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.loader.LoadResultListener;
import net.snowflake.client.loader.LoaderFactory;
import net.snowflake.client.loader.LoaderProperty;
import net.snowflake.client.loader.LoadingError;
import net.snowflake.client.loader.Operation;
import net.snowflake.client.loader.StreamLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

class TestDataConfigBuilder {
    static final String TARGET_TABLE_NAME = "LOADER_test_TABLE";
    private StreamLoader streamLoader;
    private final Connection testConnection;
    private final Connection putConnection;
    private Operation operation = Operation.INSERT;
    private boolean testMode = false;
    private int numberOfRows = 10000;
    private List<Object[]> dataSet;
    private List<String> columns = Arrays.asList("ID", "C1", "C3", "C4", "C5");
    private List<String> keys;
    private String tableName = "LOADER_test_TABLE";
    private String schemaName;
    private String databaseName;
    private String remoteStage = "~";
    private long csvFileBucketSize = 64L;
    private long csvFileSize = 0x3200000L;
    private String onError = "CONTINUE";
    private boolean startTransaction = false;
    private boolean truncateTable = true;
    private boolean preserveStageFile = false;
    private boolean useLocalTimezone = false;
    private boolean mapTimeToTimestamp = false;
    private boolean copyEmptyFieldAsEmpty = false;
    private boolean compressFileByPut = false;
    private boolean compressDataBeforePut = true;
    private long compressLevel = 1L;
    private ResultListener listener;

    TestDataConfigBuilder(Connection testConnection, Connection putConnection) throws Exception {
        this.testConnection = testConnection;
        this.putConnection = putConnection;
        this.databaseName = testConnection.getCatalog();
        this.schemaName = testConnection.getSchema();
    }

    TestDataConfigBuilder setTestMode(boolean testMode) {
        this.testMode = testMode;
        return this;
    }

    TestDataConfigBuilder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    TestDataConfigBuilder setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    TestDataConfigBuilder setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    TestDataConfigBuilder setRemoteStage(String remoteStage) {
        this.remoteStage = remoteStage;
        return this;
    }

    TestDataConfigBuilder setCsvFileBucketSize(long csvFileBucketSize) {
        this.csvFileBucketSize = csvFileBucketSize;
        return this;
    }

    TestDataConfigBuilder setCsvFileSize(long csvFileSize) {
        this.csvFileSize = csvFileSize;
        return this;
    }

    TestDataConfigBuilder setOnError(String onError) {
        this.onError = onError;
        return this;
    }

    TestDataConfigBuilder setNumberOfRows(int numberOfRows) {
        this.numberOfRows = numberOfRows;
        return this;
    }

    TestDataConfigBuilder setDataSet(List<Object[]> dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    TestDataConfigBuilder setColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    TestDataConfigBuilder setKeys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    TestDataConfigBuilder setOperation(Operation operation) {
        this.operation = operation;
        return this;
    }

    TestDataConfigBuilder setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
        return this;
    }

    TestDataConfigBuilder setPreserveStageFile(boolean preserveStageFile) {
        this.preserveStageFile = preserveStageFile;
        return this;
    }

    TestDataConfigBuilder setUseLocalTimezone(boolean useLocalTimezone) {
        this.useLocalTimezone = useLocalTimezone;
        return this;
    }

    TestDataConfigBuilder setMapTimeToTimestamp(boolean mapTimeToTimestamp) {
        this.mapTimeToTimestamp = mapTimeToTimestamp;
        return this;
    }

    TestDataConfigBuilder setStartTransaction(boolean startTransaction) {
        this.startTransaction = startTransaction;
        return this;
    }

    TestDataConfigBuilder setCopyEmptyFieldAsEmpty(boolean copyEmptyFieldAsEmpty) {
        this.copyEmptyFieldAsEmpty = copyEmptyFieldAsEmpty;
        return this;
    }

    TestDataConfigBuilder setCompressFileByPut(boolean compressFileByPut) {
        this.compressFileByPut = compressFileByPut;
        return this;
    }

    TestDataConfigBuilder setCompressDataBeforePut(boolean compressDataBeforePut) {
        this.compressDataBeforePut = compressDataBeforePut;
        return this;
    }

    TestDataConfigBuilder setCompressLevel(long compressLevel) {
        this.compressLevel = compressLevel;
        return this;
    }

    StreamLoader getStreamLoader() throws Exception {
        this.getListener();
        return this.streamLoader;
    }

    synchronized ResultListener getListener() throws Exception {
        if (this.listener == null) {
            Map<LoaderProperty, Object> prop = this.initLoaderProperties();
            this.listener = this.initLoader(prop);
        }
        return this.listener;
    }

    void populate() throws Exception {
        this.populate(false);
    }

    List<Object[]> populateReturnData() throws Exception {
        return this.populate(true);
    }

    List<Object[]> populate(boolean returnDataSet) throws Exception {
        this.getListener();
        this.streamLoader.start();
        Random rnd = new Random();
        ArrayList<Object[]> newDataSet = new ArrayList<Object[]>();
        if (this.dataSet == null) {
            for (int i = 0; i < this.numberOfRows; ++i) {
                String json = "{\"key\":" + rnd.nextInt() + ",\"bar\":" + i + "}";
                Object[] row = new Object[]{i, "foo_" + i, rnd.nextInt() / 3, new Date(), json};
                if (returnDataSet) {
                    newDataSet.add(row);
                }
                this.streamLoader.submitRow(row);
            }
        } else {
            for (Object[] row : this.dataSet) {
                this.streamLoader.submitRow(row);
            }
        }
        this.streamLoader.finish();
        int submitted = this.listener.getSubmittedRowCount();
        MatcherAssert.assertThat((String)"submitted rows", (Object)submitted, (Matcher)CoreMatchers.equalTo((Object)this.numberOfRows));
        MatcherAssert.assertThat((String)"_resultListener.counter is not correct", (Object)this.listener.counter.get(), (Matcher)CoreMatchers.equalTo((Object)this.numberOfRows));
        MatcherAssert.assertThat((String)"_resultListener.getErrors() was not 0", (Object)this.listener.getErrors().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        ResultSet rs = this.testConnection.createStatement().executeQuery(String.format("SELECT COUNT(*) AS N FROM \"%s\"", this.tableName));
        rs.next();
        int count = rs.getInt("N");
        MatcherAssert.assertThat((String)"count is not correct", (Object)count, (Matcher)CoreMatchers.equalTo((Object)this.numberOfRows));
        MatcherAssert.assertThat((String)"_resultListener.processed didn't match count", (Object)this.listener.processed.get(), (Matcher)CoreMatchers.equalTo((Object)count));
        MatcherAssert.assertThat((String)"_resultListener.counter didn't match count", (Object)this.listener.counter.get(), (Matcher)CoreMatchers.equalTo((Object)count));
        MatcherAssert.assertThat((String)"_resultListener.getErrors().size() was not 0", (Object)this.listener.getErrors().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"_resultListener.getLastRecord()[0] was not 9999", (Object)((Integer)this.listener.getLastRecord()[0]), (Matcher)CoreMatchers.equalTo((Object)(this.numberOfRows - 1)));
        return newDataSet;
    }

    private Map<LoaderProperty, Object> initLoaderProperties() {
        HashMap<LoaderProperty, Object> prop = new HashMap<LoaderProperty, Object>();
        prop.put(LoaderProperty.tableName, this.tableName);
        prop.put(LoaderProperty.schemaName, this.schemaName);
        prop.put(LoaderProperty.databaseName, this.databaseName);
        prop.put(LoaderProperty.remoteStage, this.remoteStage);
        prop.put(LoaderProperty.operation, this.operation);
        prop.put(LoaderProperty.columns, this.columns);
        prop.put(LoaderProperty.keys, this.keys);
        return prop;
    }

    private ResultListener initLoader(Map<LoaderProperty, Object> prop) throws Exception {
        ResultListener _resultListener = new ResultListener();
        this.streamLoader = (StreamLoader)LoaderFactory.createLoader(prop, (Connection)this.putConnection, (Connection)this.testConnection);
        this.streamLoader.setProperty(LoaderProperty.startTransaction, (Object)this.startTransaction);
        this.streamLoader.setProperty(LoaderProperty.truncateTable, (Object)this.truncateTable);
        this.streamLoader.setProperty(LoaderProperty.preserveStageFile, (Object)this.preserveStageFile);
        this.streamLoader.setProperty(LoaderProperty.useLocalTimezone, (Object)this.useLocalTimezone);
        this.streamLoader.setProperty(LoaderProperty.mapTimeToTimestamp, (Object)this.mapTimeToTimestamp);
        this.streamLoader.setProperty(LoaderProperty.copyEmptyFieldAsEmpty, (Object)this.copyEmptyFieldAsEmpty);
        this.streamLoader.setProperty(LoaderProperty.csvFileBucketSize, (Object)Long.toString(this.csvFileBucketSize));
        this.streamLoader.setProperty(LoaderProperty.csvFileSize, (Object)Long.toString(this.csvFileSize));
        this.streamLoader.setProperty(LoaderProperty.compressFileByPut, (Object)this.compressFileByPut);
        this.streamLoader.setProperty(LoaderProperty.compressDataBeforePut, (Object)this.compressDataBeforePut);
        this.streamLoader.setProperty(LoaderProperty.compressLevel, (Object)this.compressLevel);
        this.streamLoader.setProperty(LoaderProperty.onError, (Object)this.onError);
        this.streamLoader.setListener((LoadResultListener)_resultListener);
        this.streamLoader.setTestMode(this.testMode);
        this.putConnection.unwrap(SnowflakeConnectionV1.class).setInjectedDelay(5000);
        return _resultListener;
    }

    class ResultListener
    implements LoadResultListener {
        private final List<LoadingError> errors = new ArrayList<LoadingError>();
        private final AtomicInteger errorCount = new AtomicInteger(0);
        private final AtomicInteger errorRecordCount = new AtomicInteger(0);
        public final AtomicInteger counter = new AtomicInteger(0);
        public final AtomicInteger processed = new AtomicInteger(0);
        public final AtomicInteger deleted = new AtomicInteger(0);
        public final AtomicInteger updated = new AtomicInteger(0);
        private final AtomicInteger submittedRowCount = new AtomicInteger(0);
        private Object[] lastRecord = null;
        public boolean throwOnError = false;

        ResultListener() {
        }

        public boolean needErrors() {
            return true;
        }

        public boolean needSuccessRecords() {
            return true;
        }

        public void addError(LoadingError error) {
            this.errors.add(error);
        }

        public boolean throwOnError() {
            return this.throwOnError;
        }

        public List<LoadingError> getErrors() {
            return this.errors;
        }

        public void recordProvided(Operation op, Object[] record) {
            this.lastRecord = record;
        }

        public void addProcessedRecordCount(Operation op, int i) {
            this.processed.addAndGet(i);
        }

        public void addOperationRecordCount(Operation op, int i) {
            this.counter.addAndGet(i);
            if (op == Operation.DELETE) {
                this.deleted.addAndGet(i);
            } else if (op == Operation.MODIFY || op == Operation.UPSERT) {
                this.updated.addAndGet(i);
            }
        }

        public Object[] getLastRecord() {
            return this.lastRecord;
        }

        public int getErrorCount() {
            return this.errorCount.get();
        }

        public int getErrorRecordCount() {
            return this.errorRecordCount.get();
        }

        public void resetErrorCount() {
            this.errorCount.set(0);
        }

        public void resetErrorRecordCount() {
            this.errorRecordCount.set(0);
        }

        public void addErrorCount(int count) {
            this.errorCount.addAndGet(count);
        }

        public void addErrorRecordCount(int count) {
            this.errorRecordCount.addAndGet(count);
        }

        public void resetSubmittedRowCount() {
            this.submittedRowCount.set(0);
        }

        public void addSubmittedRowCount(int count) {
            this.submittedRowCount.addAndGet(count);
        }

        public int getSubmittedRowCount() {
            return this.submittedRowCount.get();
        }
    }
}

