/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import net.snowflake.client.log.CommonsLoggingWrapperMode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class CommonsLoggingWrapperModeTest {
    private String propertyValue;

    @BeforeEach
    public void setUp() {
        this.propertyValue = System.getProperty("net.snowflake.jdbc.commons_logging_wrapper");
    }

    @AfterEach
    public void tearDown() {
        if (this.propertyValue != null) {
            System.setProperty("net.snowflake.jdbc.commons_logging_wrapper", this.propertyValue);
        } else {
            System.clearProperty("net.snowflake.jdbc.commons_logging_wrapper");
        }
    }

    @ParameterizedTest
    @EnumSource(value=CommonsLoggingWrapperMode.class)
    public void shouldDetectMode(CommonsLoggingWrapperMode value) {
        System.setProperty("net.snowflake.jdbc.commons_logging_wrapper", value.name());
        Assertions.assertEquals((Object)value, (Object)CommonsLoggingWrapperMode.detect());
    }

    @Test
    public void shouldPickDefaultMode() {
        System.clearProperty("net.snowflake.jdbc.commons_logging_wrapper");
        Assertions.assertEquals((Object)CommonsLoggingWrapperMode.DEFAULT, (Object)CommonsLoggingWrapperMode.detect());
    }

    @Test
    public void shouldThrowOnUnknownMode() {
        System.setProperty("net.snowflake.jdbc.commons_logging_wrapper", "invalid");
        IllegalArgumentException illegalArgumentException = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, CommonsLoggingWrapperMode::detect);
        Assertions.assertEquals((Object)"Unknown commons logging wrapper value 'invalid', expected one of: ALL, DEFAULT, OFF", (Object)illegalArgumentException.getMessage());
    }
}

