/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.pooling;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.pooling.SnowflakeConnectionPoolDataSource;
import net.snowflake.client.pooling.SnowflakePooledConnection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="connection")
public class ConnectionPoolingDataSourceIT
extends AbstractDriverIT {
    @Test
    public void testPooledConnection() throws SQLException {
        Map<String, String> properties = ConnectionPoolingDataSourceIT.getConnectionParameters();
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource.setUrl(properties.get("uri"));
        poolDataSource.setPortNumber(Integer.parseInt(properties.get("port")));
        poolDataSource.setSsl("on".equals(properties.get("ssl")));
        poolDataSource.setAccount(properties.get("account"));
        poolDataSource.setUser(properties.get("user"));
        poolDataSource.setPassword(properties.get("password"));
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        TestingConnectionListener listener = new TestingConnectionListener();
        pooledConnection.addConnectionEventListener(listener);
        try (Connection connection = pooledConnection.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("select 1");
            SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> connection.setCatalog("nonexistent_database"));
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)2043));
        }
        List<ConnectionEvent> connectionClosedEvents = listener.getConnectionClosedEvents();
        List<ConnectionEvent> connectionErrorEvents = listener.getConnectionErrorEvents();
        MatcherAssert.assertThat((Object)connectionClosedEvents.size(), (Matcher)CoreMatchers.is((Object)1));
        ConnectionEvent closedEvent = connectionClosedEvents.get(0);
        MatcherAssert.assertThat((Object)closedEvent.getSQLException(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)closedEvent.getSource(), (Matcher)CoreMatchers.instanceOf(SnowflakePooledConnection.class));
        MatcherAssert.assertThat((Object)((PooledConnection)closedEvent.getSource()), (Matcher)CoreMatchers.sameInstance((Object)pooledConnection));
        MatcherAssert.assertThat((Object)connectionErrorEvents.size(), (Matcher)CoreMatchers.is((Object)1));
        ConnectionEvent errorEvent = connectionErrorEvents.get(0);
        MatcherAssert.assertThat((Object)errorEvent.getSource(), (Matcher)CoreMatchers.instanceOf(SnowflakePooledConnection.class));
        MatcherAssert.assertThat((Object)((PooledConnection)errorEvent.getSource()), (Matcher)CoreMatchers.sameInstance((Object)pooledConnection));
        MatcherAssert.assertThat((Object)errorEvent.getSQLException().getErrorCode(), (Matcher)CoreMatchers.is((Object)2043));
        Connection physicalConnection = ((SnowflakePooledConnection)pooledConnection).getPhysicalConnection();
        MatcherAssert.assertThat((Object)physicalConnection.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        pooledConnection.removeConnectionEventListener(listener);
        pooledConnection.close();
        MatcherAssert.assertThat((Object)physicalConnection.isClosed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testPooledConnectionUsernamePassword() throws SQLException {
        Map<String, String> properties = ConnectionPoolingDataSourceIT.getConnectionParameters();
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource.setUrl(properties.get("uri"));
        poolDataSource.setPortNumber(Integer.parseInt(properties.get("port")));
        poolDataSource.setSsl("on".equals(properties.get("ssl")));
        poolDataSource.setAccount(properties.get("account"));
        PooledConnection pooledConnection = poolDataSource.getPooledConnection(properties.get("user"), properties.get("password"));
        TestingConnectionListener listener = new TestingConnectionListener();
        pooledConnection.addConnectionEventListener(listener);
        try (Connection connection = pooledConnection.getConnection();){
            connection.createStatement().execute("select 1");
        }
        pooledConnection.close();
    }

    private static class TestingConnectionListener
    implements ConnectionEventListener {
        private List<ConnectionEvent> connectionClosedEvents = new ArrayList<ConnectionEvent>();
        private List<ConnectionEvent> connectionErrorEvents = new ArrayList<ConnectionEvent>();

        TestingConnectionListener() {
        }

        @Override
        public void connectionClosed(ConnectionEvent event) {
            this.connectionClosedEvents.add(event);
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent event) {
            this.connectionErrorEvents.add(event);
        }

        public List<ConnectionEvent> getConnectionClosedEvents() {
            return this.connectionClosedEvents;
        }

        public List<ConnectionEvent> getConnectionErrorEvents() {
            return this.connectionErrorEvents;
        }
    }
}

