/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.pooling;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.sql.PooledConnection;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.pooling.LogicalConnection;
import net.snowflake.client.pooling.SnowflakeConnectionPoolDataSource;
import net.snowflake.client.pooling.SnowflakePooledConnection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Tag(value="connection")
public class LogicalConnectionLatestIT
extends BaseJDBCTest {
    Map<String, String> properties = LogicalConnectionLatestIT.getConnectionParameters();

    @Test
    public void testLogicalConnection() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        Connection logicalConnection = pooledConnection.getConnection();
        try (Statement statement = logicalConnection.createStatement(1003, 1007, 2);
             ResultSet resultSet = statement.executeQuery("show parameters");){
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertFalse((boolean)logicalConnection.isClosed());
            Assertions.assertEquals((int)2, (int)logicalConnection.getHoldability());
        }
        logicalConnection.close();
        Assertions.assertTrue((boolean)logicalConnection.isClosed());
        pooledConnection.close();
    }

    @Test
    public void testNetworkTimeout() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            int millis = logicalConnection.getNetworkTimeout();
            Assertions.assertEquals((int)0, (int)millis);
            logicalConnection.setNetworkTimeout(null, 200);
            Assertions.assertEquals((int)200, (int)logicalConnection.getNetworkTimeout());
        }
        pooledConnection.close();
    }

    @Test
    public void testIsValid() throws Throwable {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Assertions.assertTrue((boolean)logicalConnection.isValid(10));
            Assertions.assertThrows(SQLException.class, () -> logicalConnection.isValid(-10));
        }
        pooledConnection.close();
    }

    @Test
    public void testConnectionClientInfo() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Properties property = logicalConnection.getClientInfo();
            Assertions.assertEquals((int)0, (int)property.size());
            Properties clientInfo = new Properties();
            clientInfo.setProperty("name", "Peter");
            clientInfo.setProperty("description", "SNOWFLAKE JDBC");
            this.expectSQLClientInfoException(() -> logicalConnection.setClientInfo(clientInfo));
            this.expectSQLClientInfoException(() -> logicalConnection.setClientInfo("ApplicationName", "valueA"));
            Assertions.assertNull((Object)logicalConnection.getClientInfo("Peter"));
        }
        pooledConnection.close();
    }

    @Test
    public void testAbort() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        Connection logicalConnection = pooledConnection.getConnection();
        Connection physicalConnection = ((SnowflakePooledConnection)pooledConnection).getPhysicalConnection();
        Assertions.assertTrue((!physicalConnection.isClosed() ? 1 : 0) != 0);
        logicalConnection.abort(null);
        Assertions.assertTrue((boolean)physicalConnection.isClosed());
    }

    @Test
    public void testNativeSQL() throws Throwable {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Assertions.assertEquals((Object)"select 1", (Object)logicalConnection.nativeSQL("select 1"));
        }
        pooledConnection.close();
    }

    @Test
    public void testUnwrapper() throws Throwable {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            boolean canUnwrap = logicalConnection.isWrapperFor(SnowflakeConnectionV1.class);
            Assertions.assertTrue((boolean)canUnwrap);
            SnowflakeConnectionV1 sfconnection = logicalConnection.unwrap(SnowflakeConnectionV1.class);
            sfconnection.createStatement();
            Assertions.assertThrows(SQLException.class, () -> logicalConnection.unwrap(SnowflakeDriver.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionStatement() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Statement statement;
            logicalConnection.setAutoCommit(false);
            Assertions.assertFalse((boolean)logicalConnection.getAutoCommit());
            logicalConnection.setTransactionIsolation(2);
            Assertions.assertEquals((int)2, (int)logicalConnection.getTransactionIsolation());
            try {
                statement = logicalConnection.createStatement();
                try {
                    statement.executeUpdate("create or replace table test_transaction (colA int, colB string)");
                    statement.executeUpdate("insert into test_transaction values (1, 'abc')");
                    logicalConnection.commit();
                    try (ResultSet resultSet = statement.executeQuery("select count(*) from test_transaction");){
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                    }
                    statement.executeUpdate("delete from test_transaction");
                    logicalConnection.rollback();
                    resultSet = statement.executeQuery("select count(*) from test_transaction");
                    try {
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                statement = logicalConnection.createStatement();
                try {
                    statement.execute("drop table if exists test_transaction");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }
        pooledConnection.close();
    }

    @Test
    public void testReadOnly() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Assertions.assertEquals((Object)false, (Object)logicalConnection.isReadOnly());
            logicalConnection.setReadOnly(true);
            Assertions.assertEquals((Object)false, (Object)logicalConnection.isReadOnly());
        }
        pooledConnection.close();
    }

    @Test
    public void testGetTypeMap() throws Throwable {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            Assertions.assertEquals(Collections.emptyMap(), logicalConnection.getTypeMap());
        }
        pooledConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreparedStatement() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();
             Statement statement = logicalConnection.createStatement();){
            statement.execute("create or replace table test_prep (colA int, colB varchar)");
            try (PreparedStatement preparedStatement = logicalConnection.prepareStatement("insert into test_prep values (?, ?)");){
                preparedStatement.setInt(1, 25);
                preparedStatement.setString(2, "hello world");
                preparedStatement.execute();
                int count = 0;
                try (ResultSet resultSet = statement.executeQuery("select * from test_prep");){
                    while (resultSet.next()) {
                        ++count;
                    }
                }
                Assertions.assertEquals((int)1, (int)count);
            }
            finally {
                statement.execute("drop table if exists test_prep");
            }
        }
        pooledConnection.close();
    }

    @Test
    public void testSetSchema() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            String schema = logicalConnection.getSchema();
            try (ResultSet rst = logicalConnection.createStatement().executeQuery("select current_schema()");){
                Assertions.assertTrue((boolean)rst.next());
                Assertions.assertEquals((Object)schema, (Object)rst.getString(1));
            }
            logicalConnection.setSchema("PUBLIC");
            rst = logicalConnection.createStatement().executeQuery("select current_schema()");
            try {
                Assertions.assertTrue((boolean)rst.next());
                Assertions.assertEquals((Object)"PUBLIC", (Object)rst.getString(1));
            }
            finally {
                if (rst != null) {
                    rst.close();
                }
            }
        }
        pooledConnection.close();
    }

    @Test
    public void testPrepareCall() throws SQLException {
        String procedure = "CREATE OR REPLACE PROCEDURE output_message(message VARCHAR)\nRETURNS VARCHAR NOT NULL\nLANGUAGE SQL\nAS\nBEGIN\n  RETURN message;\nEND;";
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();
             Statement statement = logicalConnection.createStatement();){
            ResultSet resultSet;
            statement.execute(procedure);
            try (CallableStatement callableStatement = logicalConnection.prepareCall("call output_message(?)");){
                callableStatement.setString(1, "hello world");
                resultSet = callableStatement.executeQuery();
                try {
                    resultSet.next();
                    Assertions.assertEquals((Object)"hello world", (Object)resultSet.getString(1));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            callableStatement = logicalConnection.prepareCall("call output_message('hello world')", 1003, 1007);
            try {
                resultSet = callableStatement.executeQuery();
                try {
                    resultSet.next();
                    Assertions.assertEquals((Object)"hello world", (Object)resultSet.getString(1));
                    Assertions.assertEquals((int)1003, (int)callableStatement.getResultSetType());
                    Assertions.assertEquals((int)1007, (int)callableStatement.getResultSetConcurrency());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            callableStatement = logicalConnection.prepareCall("call output_message('hello world')", 1003, 1007, 2);
            try {
                resultSet = callableStatement.executeQuery();
                try {
                    resultSet.next();
                    Assertions.assertEquals((int)2, (int)callableStatement.getResultSetHoldability());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            statement.execute("drop procedure if exists output_message(varchar)");
        }
    }

    @Test
    public void testClob() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            try (Statement statement = logicalConnection.createStatement();){
                statement.execute("create or replace table test_clob (colA text)");
            }
            try (PreparedStatement preparedStatement = logicalConnection.prepareStatement("insert into test_clob values (?)");){
                Clob clob = logicalConnection.createClob();
                clob.setString(1L, "hello world");
                preparedStatement.setClob(1, clob);
                preparedStatement.execute();
            }
            statement = logicalConnection.createStatement();
            try {
                statement.execute("select * from test_clob");
                try (ResultSet resultSet = statement.getResultSet();){
                    resultSet.next();
                    Assertions.assertEquals((Object)"hello world", (Object)resultSet.getString("COLA"));
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testDatabaseMetaData() throws SQLException {
        SnowflakeConnectionPoolDataSource poolDataSource = new SnowflakeConnectionPoolDataSource();
        poolDataSource = this.setProperties(poolDataSource);
        PooledConnection pooledConnection = poolDataSource.getPooledConnection();
        try (Connection logicalConnection = pooledConnection.getConnection();){
            DatabaseMetaData databaseMetaData = logicalConnection.getMetaData();
            Assertions.assertEquals((Object)"Snowflake", (Object)databaseMetaData.getDatabaseProductName());
            Assertions.assertEquals((Object)this.properties.get("user"), (Object)databaseMetaData.getUserName());
        }
    }

    @Test
    public void testLogicalConnectionWhenPhysicalConnectionThrowsErrors() throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        SnowflakePooledConnection snowflakePooledConnection = (SnowflakePooledConnection)Mockito.mock(SnowflakePooledConnection.class);
        Mockito.when((Object)snowflakePooledConnection.getPhysicalConnection()).thenReturn((Object)connection);
        SQLException sqlException = new SQLException("mocking error");
        Mockito.when((Object)connection.createStatement()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.createStatement(1, 2, 3)).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.prepareStatement("mocksql")).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.prepareCall("mocksql")).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.prepareCall("mocksql", 1, 2, 3)).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.nativeSQL("mocksql")).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getAutoCommit()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getMetaData()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.isReadOnly()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getCatalog()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getTransactionIsolation()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getWarnings()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.prepareCall("mocksql", 1, 2)).thenThrow(new Throwable[]{sqlException});
        Mockito.when(connection.getTypeMap()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getHoldability()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.createClob()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getClientInfo("mocksql")).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getClientInfo()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.createArrayOf("mock", null)).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getSchema()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.getNetworkTimeout()).thenThrow(new Throwable[]{sqlException});
        Mockito.when((Object)connection.isWrapperFor(Connection.class)).thenThrow(new Throwable[]{sqlException});
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{sqlException}).when((Object)connection)).setAutoCommit(false);
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{sqlException}).when((Object)connection)).commit();
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{sqlException}).when((Object)connection)).rollback();
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{sqlException}).when((Object)connection)).setReadOnly(false);
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{sqlException}).when((Object)connection)).clearWarnings();
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{sqlException}).when((Object)connection)).setSchema(null);
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{sqlException}).when((Object)connection)).abort(null);
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{sqlException}).when((Object)connection)).setNetworkTimeout(null, 1);
        LogicalConnection logicalConnection = new LogicalConnection(snowflakePooledConnection);
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).createStatement());
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.createStatement(1, 2, 3));
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.nativeSQL("mocksql"));
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getAutoCommit());
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getMetaData());
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).isReadOnly());
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getCatalog());
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getTransactionIsolation());
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getWarnings());
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.prepareCall("mocksql"));
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getTypeMap());
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getHoldability());
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).createClob());
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.getClientInfo("mocksql"));
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getClientInfo());
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.createArrayOf("mock", null));
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getSchema());
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).getNetworkTimeout());
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.isWrapperFor(Connection.class));
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.setAutoCommit(false));
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).rollback());
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.setReadOnly(false));
        Assertions.assertThrows(SQLException.class, () -> ((LogicalConnection)logicalConnection).clearWarnings());
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.setSchema(null));
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.abort(null));
        Assertions.assertThrows(SQLException.class, () -> logicalConnection.setNetworkTimeout(null, 1));
        ((SnowflakePooledConnection)Mockito.verify((Object)snowflakePooledConnection, (VerificationMode)Mockito.times((int)26))).fireConnectionErrorEvent(sqlException);
    }

    private SnowflakeConnectionPoolDataSource setProperties(SnowflakeConnectionPoolDataSource poolDataSource) {
        poolDataSource.setUrl(this.properties.get("uri"));
        poolDataSource.setPortNumber(Integer.parseInt(this.properties.get("port")));
        poolDataSource.setSsl("on".equals(this.properties.get("ssl")));
        poolDataSource.setAccount(this.properties.get("account"));
        poolDataSource.setUser(this.properties.get("user"));
        poolDataSource.setPassword(this.properties.get("password"));
        poolDataSource.setDatabaseName(this.properties.get("database"));
        poolDataSource.setSchema(this.properties.get("schema"));
        poolDataSource.setWarehouse(this.properties.get("warehouse"));
        return poolDataSource;
    }
}

