package net.snowflake.client.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * This context is opaque to the JDBC driver. It is generated by the Cloud service and pushed back
 * on each request invocation.
 */
public class OpaqueContextDTO {
  @JsonInclude(JsonInclude.Include.NON_NULL)
  private String base64Data;

  @JsonCreator
  public OpaqueContextDTO(@JsonProperty("base64Data") String base64Data) {
    this.base64Data = base64Data;
  }

  public String getBase64Data() {
    return base64Data;
  }

  public void setBase64Data(String base64Data) {
    this.base64Data = base64Data;
  }
}
