/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.util.Base64;
import java.io.InputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

public final class ConnectorSFStageManager$ {
    public static final ConnectorSFStageManager$ MODULE$;
    private final String DUMMY_LOCATION;
    private final String AES;
    private final int DEFAULT_PARALLELISM;
    private final int S3_MAX_RETRIES;
    private final String CREATE_TEMP_STAGE_STMT;
    private final String AMZ_KEY;
    private final String AMZ_IV;
    private final String DATA_CIPHER;
    private final String KEY_CIPHER;
    private final String AMZ_MATDESC;

    static {
        new ConnectorSFStageManager$();
    }

    public final String DUMMY_LOCATION() {
        return "file:///tmp/dummy_location_spark_connector_tmp/";
    }

    public final String AES() {
        return "AES";
    }

    public final int DEFAULT_PARALLELISM() {
        return 10;
    }

    public final int S3_MAX_RETRIES() {
        return 3;
    }

    public final String CREATE_TEMP_STAGE_STMT() {
        return this.CREATE_TEMP_STAGE_STMT;
    }

    public final String AMZ_KEY() {
        return this.AMZ_KEY;
    }

    public final String AMZ_IV() {
        return this.AMZ_IV;
    }

    public final String DATA_CIPHER() {
        return this.DATA_CIPHER;
    }

    public final String KEY_CIPHER() {
        return this.KEY_CIPHER;
    }

    public final String AMZ_MATDESC() {
        return "x-amz-matdesc";
    }

    public final Tuple2<String, String> extractBucketNameAndPath(String stageLocation) {
        String bucketName = stageLocation;
        String s3path = "";
        if (stageLocation.contains("/")) {
            bucketName = stageLocation.substring(0, stageLocation.indexOf("/"));
            s3path = stageLocation.substring(stageLocation.indexOf("/") + 1);
        }
        return new Tuple2((Object)bucketName, (Object)s3path);
    }

    public final String TEMP_STAGE_LOCATION() {
        return new StringBuilder().append((Object)"spark_connector_unload_stage_").append((Object)Random$.MODULE$.alphanumeric().take(10).mkString("")).toString();
    }

    public final AmazonS3Client createS3Client(boolean is256, String masterKey, String queryId, String smkId, String awsId, String awsKey, String awsToken, Option<Object> parallel) {
        AmazonS3Client amazonS3Client;
        int parallelism2 = BoxesRunTime.unboxToInt((Object)parallel.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 10;
            }
        }));
        byte[] decodedKey = Base64.decode((String)masterKey);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        BasicAWSCredentials awsCredentials = awsToken == null ? new BasicAWSCredentials(awsId, awsKey) : new BasicSessionCredentials(awsId, awsKey, awsToken);
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(parallelism2);
        clientConfig.setMaxErrorRetry(3);
        if (is256) {
            CryptoConfiguration cryptoConfig = new CryptoConfiguration(CryptoMode.EncryptionOnly);
            EncryptionMaterials encryptionMaterials = new EncryptionMaterials((SecretKey)queryStageMasterKey);
            encryptionMaterials.addDescription("queryId", queryId);
            encryptionMaterials.addDescription("smkId", smkId);
            amazonS3Client = new AmazonS3EncryptionClient((AWSCredentials)awsCredentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConfig);
        } else {
            amazonS3Client = new AmazonS3Client((AWSCredentials)awsCredentials, clientConfig);
        }
        return amazonS3Client;
    }

    public final Option<Object> createS3Client$default$8() {
        return None$.MODULE$;
    }

    public final InputStream getDecryptedStream(InputStream stream, String masterKey, ObjectMetadata meta) {
        Map metaData = meta.getUserMetadata();
        byte[] decodedKey = Base64.decode((String)masterKey);
        Tuple2 tuple2 = new Tuple2(metaData.get(this.AMZ_KEY()), metaData.get(this.AMZ_IV()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String key = (String)tuple2._1();
            String iv = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)key, (Object)iv);
            String key2 = (String)tuple23._1();
            String iv2 = (String)tuple23._2();
            if (key2 == null || iv2 == null) {
                throw new SnowflakeSQLException("XX000", Predef$.MODULE$.Integer2int(ErrorCode.INTERNAL_ERROR.getMessageCode()), new Object[]{"File metadata incomplete"});
            }
            byte[] keyBytes = Base64.decode((String)key2);
            byte[] ivBytes = Base64.decode((String)iv2);
            SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
            Cipher keyCipher = Cipher.getInstance(this.KEY_CIPHER());
            keyCipher.init(2, queryStageMasterKey);
            byte[] fileKeyBytes = keyCipher.doFinal(keyBytes);
            SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, decodedKey.length, "AES");
            Cipher dataCipher = Cipher.getInstance(this.DATA_CIPHER());
            IvParameterSpec ivy = new IvParameterSpec(ivBytes);
            dataCipher.init(2, (Key)fileKey, ivy);
            return new CipherInputStream(stream, dataCipher);
        }
        throw new MatchError((Object)tuple2);
    }

    public final Tuple2<Cipher, ObjectMetadata> getCipherAndMetadata(String masterKey, String queryId, String smkId) {
        byte[] decodedKey = Base64.decode((String)masterKey);
        int keySize = decodedKey.length;
        byte[] fileKeyBytes = new byte[keySize];
        Cipher fileCipher = Cipher.getInstance(this.DATA_CIPHER());
        int blockSz = fileCipher.getBlockSize();
        byte[] ivData = new byte[blockSz];
        SecureRandom secRnd = SecureRandom.getInstance("SHA1PRNG", "SUN");
        secRnd.nextBytes(new byte[10]);
        secRnd.nextBytes(ivData);
        IvParameterSpec iv = new IvParameterSpec(ivData);
        secRnd.nextBytes(fileKeyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, keySize, "AES");
        fileCipher.init(1, (Key)fileKey, iv);
        Cipher keyCipher = Cipher.getInstance(this.KEY_CIPHER());
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, keySize, "AES");
        keyCipher.init(1, queryStageMasterKey);
        byte[] encKeK = keyCipher.doFinal(fileKeyBytes);
        MatDesc matDesc = new MatDesc(new StringOps(Predef$.MODULE$.augmentString(smkId)).toLong(), queryId, keySize * 8);
        ObjectMetadata meta = new ObjectMetadata();
        meta.addUserMetadata("x-amz-matdesc", matDesc.toString());
        meta.addUserMetadata(this.AMZ_KEY(), Base64.encodeAsString((byte[])encKeK));
        meta.addUserMetadata(this.AMZ_IV(), Base64.encodeAsString((byte[])ivData));
        return new Tuple2((Object)fileCipher, (Object)meta);
    }

    private ConnectorSFStageManager$() {
        MODULE$ = this;
        this.CREATE_TEMP_STAGE_STMT = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE OR REPLACE TEMP STAGE "})).s((Seq)Nil$.MODULE$);
        this.AMZ_KEY = "x-amz-key";
        this.AMZ_IV = "x-amz-iv";
        this.DATA_CIPHER = "AES/CBC/PKCS5Padding";
        this.KEY_CIPHER = "AES/ECB/PKCS5Padding";
    }
}

