/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class FilterPushdown$ {
    public static final FilterPushdown$ MODULE$;
    private final Logger log;

    static {
        new FilterPushdown$();
    }

    private Logger log() {
        return this.log;
    }

    public String buildWhereClause(StructType schema2, Seq<Filter> filters) {
        String filterExpressions = ((TraversableOnce)filters.flatMap((Function1)new Serializable(schema2){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Iterable<String> apply(Filter f) {
                return Option$.MODULE$.option2Iterable(FilterPushdown$.MODULE$.buildFilterExpression(this.schema$1, f));
            }
            {
                this.schema$1 = schema$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        return filterExpressions.isEmpty() ? "" : new StringBuilder().append((Object)"WHERE ").append((Object)filterExpressions).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<String> buildFilterExpression(StructType schema2, Filter filter) {
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            return this.buildComparison$1(attr, value, "=", schema2);
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            return this.buildComparison$1(attr, value, "<", schema2);
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            return this.buildComparison$1(attr, value, ">", schema2);
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            return this.buildComparison$1(attr, value, "<=", schema2);
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            return this.buildComparison$1(attr, value, ">=", schema2);
        }
        if (filter2 instanceof In) {
            In in = (In)filter2;
            String attr = in.attribute();
            Object[] values = in.values();
            if (values != null) {
                Object[] objectArray = values;
                DataType dataType = (DataType)this.getTypeForAttribute(schema2, attr).get();
                String valueStrings = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1)new Serializable(dataType){
                    public static final long serialVersionUID = 0L;
                    private final DataType dataType$1;

                    public final String apply(Object v) {
                        return FilterPushdown$.MODULE$.net$snowflake$spark$snowflake$FilterPushdown$$buildValueWithType$1(this.dataType$1, v);
                    }
                    {
                        this.dataType$1 = dataType$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
                return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " IN (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr, valueStrings})));
            }
        }
        if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " IS NULL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr})));
        }
        if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " IS NOT NULL)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr})));
        }
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            return this.buildBinaryFilter$1(left, right, "AND", schema2);
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            return this.buildBinaryFilter$1(left, right, "OR", schema2);
        }
        if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter child = not.child();
            Option<String> childStr = this.buildFilterExpression(schema2, child);
            return childStr.isEmpty() ? None$.MODULE$ : new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(NOT (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childStr.get()})));
        }
        if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attr = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"STARTSWITH(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr, this.buildValue$1(value)})));
        }
        if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attr = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ENDSWITH(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr, this.buildValue$1(value)})));
        }
        if (!(filter2 instanceof StringContains)) return None$.MODULE$;
        StringContains stringContains = (StringContains)filter2;
        String attr = stringContains.attribute();
        String value = stringContains.value();
        return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONTAINS(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr, this.buildValue$1(value)})));
    }

    private Option<DataType> getTypeForAttribute(StructType schema2, String attribute) {
        return Predef$.MODULE$.refArrayOps((Object[])schema2.fieldNames()).contains((Object)attribute) ? new Some((Object)schema2.apply(attribute).dataType()) : None$.MODULE$;
    }

    public final String net$snowflake$spark$snowflake$FilterPushdown$$buildValueWithType$1(DataType dataType, Object value) {
        DataType dataType2 = dataType;
        String string = StringType$.MODULE$.equals(dataType2) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value.toString().replace("'", "''").replace("\\", "\\\\")})) : (DateType$.MODULE$.equals(dataType2) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'::DATE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Date)value})) : (TimestampType$.MODULE$.equals(dataType2) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'::TIMESTAMP(3)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Timestamp)value})) : value.toString()));
        return string;
    }

    private final String buildValue$1(Object value) {
        Object object = value;
        String string = object instanceof String ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value.toString().replace("'", "''").replace("\\", "\\\\")})) : (object instanceof Date ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'::DATE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Date)value})) : (object instanceof Timestamp ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'::TIMESTAMP(3)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Timestamp)value})) : value.toString()));
        return string;
    }

    private final Option buildComparison$1(String attr, Object value, String comparisonOp, StructType schema$2) {
        Option<DataType> dataType = this.getTypeForAttribute(schema$2, attr);
        if (dataType.isEmpty()) {
            return None$.MODULE$;
        }
        String sqlEscapedValue = this.net$snowflake$spark$snowflake$FilterPushdown$$buildValueWithType$1((DataType)dataType.get(), value);
        return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr, comparisonOp, sqlEscapedValue})));
    }

    private final Option buildBinaryFilter$1(Filter left, Filter right, String op, StructType schema$2) {
        Option<String> leftStr = this.buildFilterExpression(schema$2, left);
        Option<String> rightStr = this.buildFilterExpression(schema$2, right);
        return leftStr.isEmpty() || rightStr.isEmpty() ? None$.MODULE$ : new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((", ") ", " (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftStr.get(), op, rightStr.get()})));
    }

    private FilterPushdown$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

