/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import java.io.InputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.TimeZone;
import java.util.UUID;
import net.snowflake.spark.snowflake.FSType$;
import net.snowflake.spark.snowflake.JDBCWrapper;
import net.snowflake.spark.snowflake.Parameters;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private final String SNOWFLAKE_SOURCE_NAME;
    private final Logger net$snowflake$spark$snowflake$Utils$$log;
    private String lastSelect;
    private String lastPutCommand;
    private String lastGetCommand;

    static {
        new Utils$();
    }

    public String SNOWFLAKE_SOURCE_NAME() {
        return this.SNOWFLAKE_SOURCE_NAME;
    }

    public Logger net$snowflake$spark$snowflake$Utils$$log() {
        return this.net$snowflake$spark$snowflake$Utils$$log;
    }

    public Class<?> classForName(String className) {
        ClassLoader classLoader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ClassLoader apply() {
                return Utils$.MODULE$.getClass().getClassLoader();
            }
        });
        return Class.forName(className, true, classLoader);
    }

    public String joinUrls(String a, String b) {
        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(a)).stripSuffix("/")).append((Object)"/").append((Object)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(b)).stripPrefix("/"))).stripSuffix("/")).append((Object)"/").toString();
    }

    public String fixS3Url(String url) {
        return url.replaceAll("s3[an]://", "s3://");
    }

    public String fixUrlForCopyCommand(String url) {
        String string;
        if (url.startsWith("wasb://") || url.startsWith("wasbs://")) {
            URI pathUri = URI.create(url);
            string = new StringBuilder().append((Object)"azure://").append((Object)pathUri.getHost()).append((Object)"/").append((Object)pathUri.getUserInfo()).append((Object)pathUri.getPath()).toString();
        } else {
            string = this.fixS3Url(url);
        }
        return string;
    }

    public URI removeCredentialsFromURI(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public String makeTempPath(String tempRoot) {
        return this.joinUrls(tempRoot, UUID.randomUUID().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkThatBucketHasObjectLifecycleConfiguration(String tempDir, Enumeration.Value tempDirStorageType, AmazonS3Client s3Client) {
        BoxedUnit boxedUnit;
        block6: {
            Enumeration.Value value = tempDirStorageType;
            Enumeration.Value value2 = FSType$.MODULE$.S3();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                try {
                    AmazonS3URI s3URI = new AmazonS3URI(this.fixS3Url(tempDir));
                    String bucket = s3URI.getBucket();
                    BucketLifecycleConfiguration bucketLifecycleConfiguration = s3Client.getBucketLifecycleConfiguration(bucket);
                    String key = (String)Option$.MODULE$.apply((Object)s3URI.getKey()).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                    boolean someRuleMatchesTempDir = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(bucketLifecycleConfiguration.getRules()).asScala()).exists((Function1)new Serializable(key){
                        public static final long serialVersionUID = 0L;
                        private final String key$1;

                        public final boolean apply(BucketLifecycleConfiguration.Rule rule) {
                            String string = rule.getStatus();
                            String string2 = "Enabled";
                            return !(string != null ? !string.equals(string2) : string2 != null) && this.key$1.startsWith(rule.getPrefix());
                        }
                        {
                            this.key$1 = key$1;
                        }
                    });
                    if (someRuleMatchesTempDir) {
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    this.net$snowflake$spark$snowflake$Utils$$log().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The S3 bucket ", " does not have an object lifecycle configuration to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket}))).append((Object)"ensure cleanup of temporary files. Consider configuring `tempdir` to point to a ").append((Object)"bucket with an object lifecycle policy that automatically deletes files after an ").append((Object)"expiration period. For more information, see ").append((Object)"https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html").toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.net$snowflake$spark$snowflake$Utils$$log().warn("An error occurred while trying to read the S3 bucket lifecycle configuration", e);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit4 = boxedUnit;
    }

    public void checkFileSystem(URI uri, Configuration hadoopConfig) {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConfig);
        String string = fs.getClass().getCanonicalName();
        String string2 = "org.apache.hadoop.fs.s3.S3FileSystem";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("spark-snowflakedb does not support the S3 Block FileSystem. Please reconfigure `tempdir` touse a s3n:// or s3a:// scheme.");
        }
    }

    public Map<String, String> readMapFromFile(SparkContext sc, String file) {
        FileSystem fs = FileSystem.get((URI)URI.create(file), (Configuration)sc.hadoopConfiguration());
        FSDataInputStream is = fs.open(Path.getPathWithoutSchemeAndAuthority((Path)new Path(file)));
        BufferedSource src = Source$.MODULE$.fromInputStream((InputStream)is, Codec$.MODULE$.fallbackSystemCodec());
        return this.mapFromSource((Source)src);
    }

    public Map<String, String> readMapFromString(String string) {
        Source src = Source$.MODULE$.fromString(string);
        return this.mapFromSource(src);
    }

    private Map<String, String> mapFromSource(Source src) {
        ObjectRef map = ObjectRef.create((Object)new HashMap());
        src.getLines().foreach((Function1)new Serializable(map){
            public static final long serialVersionUID = 0L;
            private final ObjectRef map$1;

            public final Object apply(String line) {
                String[] tokens = line.split("=");
                Predef$.MODULE$.assert(tokens.length == 2, (Function0)new Serializable(this, line){
                    public static final long serialVersionUID = 0L;
                    private final String line$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Can't parse this line: ").append((Object)this.line$1).toString();
                    }
                    {
                        this.line$1 = line$1;
                    }
                });
                String key = tokens[0].trim().toLowerCase();
                String value = tokens[1].trim();
                return key.startsWith("#") ? BoxedUnit.UNIT : ((HashMap)this.map$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
            }
            {
                this.map$1 = map$1;
            }
        });
        return ((HashMap)map.elem).toMap(Predef$.MODULE$.$conforms());
    }

    public Connection getJDBCConnection(Map<String, String> params) {
        JDBCWrapper wrapper = new JDBCWrapper();
        Map lcParams = (Map)params.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)key.toLowerCase(), (Object)value);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        Parameters.MergedParameters mergedParams = new Parameters.MergedParameters((Map<String, String>)lcParams);
        return wrapper.getConnector(mergedParams);
    }

    private String lastSelect() {
        return this.lastSelect;
    }

    private void lastSelect_$eq(String x$1) {
        this.lastSelect = x$1;
    }

    private String lastPutCommand() {
        return this.lastPutCommand;
    }

    private void lastPutCommand_$eq(String x$1) {
        this.lastPutCommand = x$1;
    }

    private String lastGetCommand() {
        return this.lastGetCommand;
    }

    private void lastGetCommand_$eq(String x$1) {
        this.lastGetCommand = x$1;
    }

    public void setLastSelect(String select) {
        this.lastSelect_$eq(select);
    }

    public String getLastSelect() {
        return this.lastSelect();
    }

    public void setLastPutCommand(String set) {
        this.lastPutCommand_$eq(set);
    }

    public String getLastPutCommand() {
        return this.lastPutCommand();
    }

    public void setLastGetCommand(String get) {
        this.lastGetCommand_$eq(get);
    }

    public String getLastGetCommand() {
        return this.lastGetCommand();
    }

    public String genPrologueSql(Parameters.MergedParameters params) {
        Option<String> tz = params.sfTimezone();
        String timezoneSetString = "";
        if (params.isTimezoneSpark()) {
            String tzStr = TimeZone.getDefault().getID();
            timezoneSetString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timezone = '", "',"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tzStr}));
        } else if (!params.isTimezoneSnowflake()) {
            timezoneSetString = params.isTimezoneSnowflakeDefault() ? "timezone = default," : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timezone = '", "',"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tz.get()}));
        }
        this.net$snowflake$spark$snowflake$Utils$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sfTimezone: '", "'   timezoneSetString '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tz, timezoneSetString})));
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |alter session set\n       |  ", "\n       |  date_output_format = 'YYYY-MM-DD',\n       |  timestamp_ntz_output_format = 'YYYY-MM-DD HH24:MI:SS.FF3',\n       |  timestamp_ltz_output_format = 'TZHTZM YYYY-MM-DD HH24:MI:SS.FF3',\n       |  timestamp_tz_output_format = 'TZHTZM YYYY-MM-DD HH24:MI:SS.FF3';\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timezoneSetString})))).stripMargin().trim();
    }

    public String genEpilogueSql(Parameters.MergedParameters params) {
        String timezoneUnsetString = "";
        if (!params.isTimezoneSnowflake()) {
            timezoneUnsetString = "timezone,";
        }
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |alter session unset\n       |  ", "\n       |  date_output_format,\n       |  timestamp_ntz_output_format,\n       |  timestamp_ltz_output_format,\n       |  timestamp_tz_output_format;\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timezoneUnsetString})))).stripMargin().trim();
    }

    public void executePreActions(JDBCWrapper jdbcWrapper, Connection conn, Parameters.MergedParameters params) {
        Predef$.MODULE$.refArrayOps((Object[])params.preActions()).foreach((Function1)new Serializable(jdbcWrapper, conn, params){
            public static final long serialVersionUID = 0L;
            private final JDBCWrapper jdbcWrapper$1;
            private final Connection conn$1;
            private final Parameters.MergedParameters params$1;

            public final Object apply(String action) {
                Object object;
                if (action == null || action.trim().isEmpty()) {
                    object = BoxedUnit.UNIT;
                } else {
                    String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$1.table().get()})) : action;
                    Utils$.MODULE$.net$snowflake$spark$snowflake$Utils$$log().info(new StringBuilder().append((Object)"Executing preAction: ").append((Object)actionSql).toString());
                    object = BoxesRunTime.boxToBoolean((boolean)this.jdbcWrapper$1.executePreparedInterruptibly(this.conn$1.prepareStatement(actionSql)));
                }
                return object;
            }
            {
                this.jdbcWrapper$1 = jdbcWrapper$1;
                this.conn$1 = conn$1;
                this.params$1 = params$1;
            }
        });
    }

    public void executePostActions(JDBCWrapper jdbcWrapper, Connection conn, Parameters.MergedParameters params) {
        Predef$.MODULE$.refArrayOps((Object[])params.postActions()).foreach((Function1)new Serializable(jdbcWrapper, conn, params){
            public static final long serialVersionUID = 0L;
            private final JDBCWrapper jdbcWrapper$2;
            private final Connection conn$2;
            private final Parameters.MergedParameters params$2;

            public final Object apply(String action) {
                Object object;
                if (action == null || action.trim().isEmpty()) {
                    object = BoxedUnit.UNIT;
                } else {
                    String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$2.table().get()})) : action;
                    Utils$.MODULE$.net$snowflake$spark$snowflake$Utils$$log().info(new StringBuilder().append((Object)"Executing postAction: ").append((Object)actionSql).toString());
                    object = BoxesRunTime.boxToBoolean((boolean)this.jdbcWrapper$2.executePreparedInterruptibly(this.conn$2.prepareStatement(actionSql)));
                }
                return object;
            }
            {
                this.jdbcWrapper$2 = jdbcWrapper$2;
                this.conn$2 = conn$2;
                this.params$2 = params$2;
            }
        });
    }

    public ResultSet runQuery(Map<String, String> params, String query2) {
        Connection conn = this.getJDBCConnection(params);
        return conn.createStatement().executeQuery(query2);
    }

    public void printQuery(Map<String, String> params, String query2) {
        System.out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query2})));
        ResultSet res = this.runQuery(params, query2);
        int columnCount = res.getMetaData().getColumnCount();
        int rowCnt = 0;
        while (res.next()) {
            ++rowCnt;
            StringBuilder s = package$.MODULE$.StringBuilder().newBuilder();
            s.append("| ");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), columnCount).foreach((Function1)new Serializable(res, s){
                public static final long serialVersionUID = 0L;
                private final ResultSet res$1;
                private final StringBuilder s$1;

                public final StringBuilder apply(int i) {
                    Object object = i > 1 ? this.s$1.append(" | ") : BoxedUnit.UNIT;
                    return this.s$1.append(this.res$1.getString(i));
                }
                {
                    this.res$1 = res$1;
                    this.s$1 = s$1;
                }
            });
            s.append(" |");
            System.out.println(s);
        }
        System.out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TOTAL: ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rowCnt)})));
    }

    public String sanitizeQueryText(String q) {
        return new StringBuilder().append((Object)"<SANITIZED> ").append((Object)q.replaceAll("(AWS_KEY_ID|AWS_SECRET_KEY|AZURE_SAS_TOKEN)='[^']+'", "$1='\u2744\u2603\u2744\u263a\u2744\u2603\u2744'").replaceAll("(sfaccount|sfurl|sfuser|sfpassword|sfwarehouse|sfdatabase|sfschema|sfrole|awsaccesskey|awssecretkey) \"[^\"]+\"", "$1 \"\u2744\u2603\u2744\u263a\u2744\u2603\u2744\"")).toString();
    }

    private Utils$() {
        MODULE$ = this;
        this.SNOWFLAKE_SOURCE_NAME = "net.snowflake.spark.snowflake";
        this.net$snowflake$spark$snowflake$Utils$$log = LoggerFactory.getLogger(this.getClass());
    }
}

