/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.s3upload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConvertibleOutputStream
extends ByteArrayOutputStream {
    private static final Logger log = LoggerFactory.getLogger(ConvertibleOutputStream.class);

    public ConvertibleOutputStream(int n) {
        super(n);
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }

    public ConvertibleOutputStream split(int n, int n2) {
        int n3 = this.count - n;
        log.debug("Splitting stream of size {} into parts with sizes {} and {}", new Object[]{this.count, n, n3});
        n2 = Math.max(n2, n3);
        ConvertibleOutputStream convertibleOutputStream = new ConvertibleOutputStream(n2);
        convertibleOutputStream.write(this.buf, n, n3);
        this.count = n;
        return convertibleOutputStream;
    }

    public void append(ConvertibleOutputStream convertibleOutputStream) {
        try {
            convertibleOutputStream.writeTo(this);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }
}

