/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.s3upload;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.snowflake.spark.snowflake.s3upload.ExecutorServiceResultsHandler;
import net.snowflake.spark.snowflake.s3upload.MultiPartOutputStream;
import net.snowflake.spark.snowflake.s3upload.StreamPart;
import net.snowflake.spark.snowflake.s3upload.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTransferManager {
    private static final Logger log = LoggerFactory.getLogger(StreamTransferManager.class);
    protected final String bucketName;
    protected final String putKey;
    protected final AmazonS3 s3Client;
    protected final String uploadId;
    private final List<PartETag> partETags;
    private final List<MultiPartOutputStream> multiPartOutputStreams;
    private final ExecutorServiceResultsHandler<Void> executorServiceResultsHandler;
    private final BlockingQueue<StreamPart> queue;
    private int finishedCount = 0;
    private StreamPart leftoverStreamPart = null;
    private final Object leftoverStreamPartLock = new Object();
    private boolean isAborting = false;
    private static final int MAX_PART_NUMBER = 10000;

    public StreamTransferManager(String string, String string2, AmazonS3 amazonS3, ObjectMetadata objectMetadata, int n, int n2, int n3, int n4) {
        if (n <= 0) {
            throw new IllegalArgumentException("There must be at least one stream");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("There must be at least one upload thread");
        }
        if ((n4 *= 0x100000) < 0x500000) {
            throw new IllegalArgumentException(String.format("The given part size (%d) is less than 5 MB.", n4));
        }
        this.bucketName = string;
        this.putKey = string2;
        this.s3Client = amazonS3;
        this.queue = new ArrayBlockingQueue<StreamPart>(n3);
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(string, string2);
        initiateMultipartUploadRequest.setObjectMetadata(objectMetadata);
        this.customiseInitiateRequest(initiateMultipartUploadRequest);
        InitiateMultipartUploadResult initiateMultipartUploadResult = amazonS3.initiateMultipartUpload(initiateMultipartUploadRequest);
        this.uploadId = initiateMultipartUploadResult.getUploadId();
        try {
            int n5;
            this.partETags = new ArrayList<PartETag>();
            this.multiPartOutputStreams = new ArrayList<MultiPartOutputStream>();
            ExecutorService executorService = Executors.newFixedThreadPool(n);
            int n6 = 1;
            for (n5 = 0; n5 < n; ++n5) {
                int n7 = (n5 + 1) * 10000 / n + 1;
                MultiPartOutputStream multiPartOutputStream = new MultiPartOutputStream(n6, n7, n4, this.queue);
                n6 = n7;
                this.multiPartOutputStreams.add(multiPartOutputStream);
            }
            this.executorServiceResultsHandler = new ExecutorServiceResultsHandler(executorService);
            for (n5 = 0; n5 < n2; ++n5) {
                this.executorServiceResultsHandler.submit(new UploadTask());
            }
            this.executorServiceResultsHandler.finishedSubmitting();
        }
        catch (Throwable throwable) {
            this.abort(throwable);
            throw new RuntimeException("Unexpected error occurred while setting up streams and threads for upload: this likely indicates a bug in this class.", throwable);
        }
    }

    public List<MultiPartOutputStream> getMultiPartOutputStreams() {
        return this.multiPartOutputStreams;
    }

    public void complete() {
        try {
            this.executorServiceResultsHandler.awaitCompletion();
            if (this.leftoverStreamPart != null) {
                this.uploadStreamPart(this.leftoverStreamPart);
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucketName, this.putKey, this.uploadId, this.partETags);
            this.customiseCompleteRequest(completeMultipartUploadRequest);
            this.s3Client.completeMultipartUpload(completeMultipartUploadRequest);
        }
        catch (Throwable throwable) {
            this.abort(throwable);
            throw new RuntimeException(throwable);
        }
    }

    public void abort(Throwable throwable) {
        this.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        StreamTransferManager streamTransferManager = this;
        synchronized (streamTransferManager) {
            if (this.isAborting) {
                return;
            }
            this.isAborting = true;
        }
        this.executorServiceResultsHandler.abort();
        streamTransferManager = new AbortMultipartUploadRequest(this.bucketName, this.putKey, this.uploadId);
        this.s3Client.abortMultipartUpload((AbortMultipartUploadRequest)streamTransferManager);
    }

    private void uploadStreamPart(StreamPart streamPart) {
        UploadPartRequest uploadPartRequest = new UploadPartRequest().withBucketName(this.bucketName).withKey(this.putKey).withUploadId(this.uploadId).withPartNumber(streamPart.getPartNumber()).withInputStream(streamPart.getInputStream()).withPartSize(streamPart.size());
        this.customiseUploadPartRequest(uploadPartRequest);
        UploadPartResult uploadPartResult = this.s3Client.uploadPart(uploadPartRequest);
        PartETag partETag = uploadPartResult.getPartETag();
        this.partETags.add(partETag);
    }

    public String toString() {
        return String.format("[Manager uploading to %s/%s with id %s]", this.bucketName, this.putKey, Utils.skipMiddle(this.uploadId, 21));
    }

    public void customiseInitiateRequest(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
    }

    public void customiseUploadPartRequest(UploadPartRequest uploadPartRequest) {
    }

    public void customiseCompleteRequest(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
    }

    private class UploadTask
    implements Callable<Void> {
        private UploadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            try {
                while (true) {
                    StreamPart streamPart;
                    Object object = StreamTransferManager.this.queue;
                    synchronized (object) {
                        if (StreamTransferManager.this.finishedCount < StreamTransferManager.this.multiPartOutputStreams.size()) {
                            streamPart = (StreamPart)StreamTransferManager.this.queue.take();
                            if (streamPart == StreamPart.POISON) {
                                StreamTransferManager.this.finishedCount++;
                                continue;
                            }
                        } else {
                            break;
                        }
                    }
                    if (streamPart.size() < 0x500000L) {
                        object = streamPart;
                        streamPart = null;
                        Object object2 = StreamTransferManager.this.leftoverStreamPartLock;
                        synchronized (object2) {
                            if (StreamTransferManager.this.leftoverStreamPart == null) {
                                StreamTransferManager.this.leftoverStreamPart = (StreamPart)object;
                            } else {
                                if (StreamTransferManager.this.leftoverStreamPart.getPartNumber() > ((StreamPart)object).getPartNumber()) {
                                    Object object3 = object;
                                    object = StreamTransferManager.this.leftoverStreamPart;
                                    StreamTransferManager.this.leftoverStreamPart = (StreamPart)object3;
                                }
                                StreamTransferManager.this.leftoverStreamPart.getOutputStream().append(((StreamPart)object).getOutputStream());
                                if (StreamTransferManager.this.leftoverStreamPart.size() >= 0x500000L) {
                                    streamPart = StreamTransferManager.this.leftoverStreamPart;
                                    StreamTransferManager.this.leftoverStreamPart = null;
                                }
                            }
                        }
                    }
                    if (streamPart == null) continue;
                    StreamTransferManager.this.uploadStreamPart(streamPart);
                }
            }
            catch (Throwable throwable) {
                StreamTransferManager.this.abort(throwable);
                throw new RuntimeException(throwable);
            }
            return null;
        }
    }
}

