/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.sql.Statement;
import net.snowflake.spark.snowflake.RunningQuery;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.ServerConnection$;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SparkConnectorContext$ {
    public static final SparkConnectorContext$ MODULE$ = new SparkConnectorContext$();
    private static final Map<String, Set<RunningQuery>> runningQueries = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private static final HashSet<String> closedApplicationIDs = HashSet$.MODULE$.empty();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static boolean isConfigLogged = false;
    private static final Object locker = new Object();

    private Map<String, Set<RunningQuery>> runningQueries() {
        return runningQueries;
    }

    public HashSet<String> closedApplicationIDs() {
        return closedApplicationIDs;
    }

    public Map<String, Set<RunningQuery>> getRunningQueries() {
        return this.runningQueries();
    }

    public void registerSparkListenerIfNotYet(SparkContext sparkContext) {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String appId = sparkContext.applicationId();
            if (!MODULE$.runningQueries().keySet().contains((Object)appId)) {
                MODULE$.logger().info(new StringBuilder(39).append("Spark connector register listener for: ").append(appId).toString());
                MODULE$.runningQueries().put((Object)appId, Set$.MODULE$.empty());
                sparkContext.addSparkListener((SparkListenerInterface)new SparkListener(appId){
                    private final String appId$1;

                    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
                        SparkConnectorContext$.MODULE$.closedApplicationIDs().add((Object)this.appId$1);
                        try {
                            SparkConnectorContext$.MODULE$.cancelRunningQueries(this.appId$1);
                            ServerConnection$.MODULE$.closeAllCachedConnections();
                        }
                        finally {
                            super.onApplicationEnd(applicationEnd);
                        }
                    }
                    {
                        this.appId$1 = appId$1;
                    }
                });
                return;
            }
        });
    }

    public void cancelRunningQueries(String appId) {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Option queries = MODULE$.runningQueries().get((Object)appId);
            if (queries.nonEmpty()) {
                ((IterableOnceOps)queries.get()).foreach((Function1 & Serializable)rq -> {
                    SparkConnectorContext$.$anonfun$cancelRunningQueries$2(rq);
                    return BoxedUnit.UNIT;
                });
                MODULE$.logger().warn(new StringBuilder(34).append("Finish cancelling all queries for ").append(appId).toString());
                MODULE$.runningQueries().remove((Object)appId);
                return;
            }
            MODULE$.logger().info(new StringBuilder(22).append("No running query for: ").append(appId).toString());
        });
    }

    public void addRunningQuery(SparkContext sparkContext, ServerConnection conn, String queryID) {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.registerSparkListenerIfNotYet(sparkContext);
            String appId = sparkContext.applicationId();
            String sessionID = conn.getSessionID();
            MODULE$.logger().info(new StringBuilder(42).append("Add running query for ").append(appId).append(" session: ").append(sessionID).append(" queryId: ").append(queryID).toString());
            Option queries = MODULE$.runningQueries().get((Object)appId);
            queries.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.add((Object)new RunningQuery(conn, queryID))));
        });
    }

    public void removeRunningQuery(SparkContext sparkContext, ServerConnection conn, String queryID) {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            String appId = sparkContext.applicationId();
            String sessionID = conn.getSessionID();
            MODULE$.logger().info(new StringBuilder(45).append("Remove running query for ").append(appId).append(" session: ").append(sessionID).append(" queryId: ").append(queryID).toString());
            Option queries = MODULE$.runningQueries().get((Object)appId);
            queries.foreach((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.remove((Object)new RunningQuery(conn, queryID))));
        });
    }

    public Logger logger() {
        return logger;
    }

    private boolean isConfigLogged() {
        return isConfigLogged;
    }

    private void isConfigLogged_$eq(boolean x$1) {
        isConfigLogged = x$1;
    }

    private Object locker() {
        return locker;
    }

    public void recordConfig() {
        this.withSyncAndDoNotThrowException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (!MODULE$.isConfigLogged()) {
                MODULE$.isConfigLogged_$eq(true);
                MODULE$.logger().info(new StringBuilder(31).append("Spark Connector system config: ").append(SnowflakeTelemetry$.MODULE$.getClientConfig().toPrettyString()).toString());
                return;
            }
        });
    }

    private void withSyncAndDoNotThrowException(Function0<BoxedUnit> block) {
        try {
            Object object = this.locker();
            synchronized (object) {
                block.apply$mcV$sp();
            }
        }
        catch (Throwable th) {
            this.logger().warn(new StringBuilder(25).append("Hit un-caught exception: ").append(th.getMessage()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$cancelRunningQueries$2(RunningQuery rq) {
        try {
            if (!rq.conn().isClosed()) {
                Statement statement = rq.conn().createStatement();
                String sessionID = rq.conn().getSessionID();
                MODULE$.logger().warn(new StringBuilder(30).append("Canceling query ").append(rq.queryID()).append(" for session: ").append(sessionID).toString());
                statement.execute(new StringBuilder(30).append("select SYSTEM$CANCEL_QUERY('").append(rq.queryID()).append("')").toString());
                statement.close();
            }
        }
        catch (Throwable th) {
            MODULE$.logger().warn("Fail to cancel running queries: ", th);
        }
    }

    private SparkConnectorContext$() {
    }
}

