/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.io;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSStaticCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicSessionCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.client.builder.AwsClientBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.retry.PredefinedRetryPolicies;
import net.snowflake.client.jdbc.internal.amazonaws.retry.RetryPolicy;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3ClientBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentials;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsAnonymous;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobClient;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.ProxyInfo;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.SnowflakeConnectorFeatureNotSupportException;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.io.ExternalAzureStorage;
import net.snowflake.spark.snowflake.io.ExternalS3Storage;
import net.snowflake.spark.snowflake.io.ExternalS3Storage$;
import net.snowflake.spark.snowflake.io.InternalAzureStorage;
import net.snowflake.spark.snowflake.io.InternalGcsStorage;
import net.snowflake.spark.snowflake.io.InternalS3Storage;
import net.snowflake.spark.snowflake.io.InternalS3Storage$;
import net.snowflake.spark.snowflake.io.SFInternalStage;
import net.snowflake.spark.snowflake.io.SFInternalStage$;
import net.snowflake.spark.snowflake.io.SupportedFormat$;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.util.Random$;
import scala.util.matching.Regex;

public final class CloudStorageOperations$ {
    public static final CloudStorageOperations$ MODULE$ = new CloudStorageOperations$();
    private static final int DEFAULT_PARALLELISM = 10;
    private static final int S3_MAX_RETRIES = 6;
    private static final int S3_MAX_TIMEOUT_MS = 30000;
    private static final String AES = "AES";
    private static final String AMZ_KEY = "x-amz-key";
    private static final String AMZ_IV = "x-amz-iv";
    private static final String DATA_CIPHER = "AES/CBC/PKCS5Padding";
    private static final String KEY_CIPHER = "AES/ECB/PKCS5Padding";
    private static final String AMZ_MATDESC = "x-amz-matdesc";
    private static final String AZ_ENCRYPTIONDATA = "encryptiondata";
    private static final String AZ_IV = "ContentEncryptionIV";
    private static final String AZ_KEY_WRAP = "WrappedContentKey";
    private static final String AZ_KEY = "EncryptedKey";
    private static final String AZ_MATDESC = "matdesc";
    private static final Logger log = LoggerFactory.getLogger(MODULE$.getClass());

    public int DEFAULT_PARALLELISM() {
        return DEFAULT_PARALLELISM;
    }

    public int S3_MAX_RETRIES() {
        return S3_MAX_RETRIES;
    }

    public int S3_MAX_TIMEOUT_MS() {
        return S3_MAX_TIMEOUT_MS;
    }

    public String AES() {
        return AES;
    }

    public String AMZ_KEY() {
        return AMZ_KEY;
    }

    public String AMZ_IV() {
        return AMZ_IV;
    }

    public String DATA_CIPHER() {
        return DATA_CIPHER;
    }

    public String KEY_CIPHER() {
        return KEY_CIPHER;
    }

    public String AMZ_MATDESC() {
        return AMZ_MATDESC;
    }

    public String AZ_ENCRYPTIONDATA() {
        return AZ_ENCRYPTIONDATA;
    }

    public String AZ_IV() {
        return AZ_IV;
    }

    public String AZ_KEY_WRAP() {
        return AZ_KEY_WRAP;
    }

    public String AZ_KEY() {
        return AZ_KEY;
    }

    public String AZ_MATDESC() {
        return AZ_MATDESC;
    }

    public Logger log() {
        return log;
    }

    public final InputStream getDecryptedStream(InputStream stream, String masterKey, Map<String, String> metaData, StageInfo.StageType stageType) {
        Tuple2<String, String> tuple2;
        byte[] decodedKey = Base64.decode((String)masterKey);
        StageInfo.StageType stageType2 = stageType;
        if (StageInfo.StageType.S3.equals(stageType2)) {
            tuple2 = new Tuple2<String, String>((Object)metaData.get(this.AMZ_KEY()), (Object)metaData.get(this.AMZ_IV()));
        } else if (StageInfo.StageType.AZURE.equals(stageType2)) {
            tuple2 = this.parseEncryptionData(metaData.get(this.AZ_ENCRYPTIONDATA()));
        } else {
            throw new UnsupportedOperationException(new StringBuilder(44).append("Only support s3 or azure stage. Stage Type: ").append(stageType).toString());
        }
        Tuple2<String, String> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        String key = (String)tuple22._1();
        String iv = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)key, (Object)iv);
        String key2 = (String)tuple23._1();
        String iv2 = (String)tuple23._2();
        if (key2 == null || iv2 == null) {
            throw new SnowflakeSQLException("XX000", Predef$.MODULE$.Integer2int(ErrorCode.INTERNAL_ERROR.getMessageCode()), new Object[]{"File metadata incomplete"});
        }
        byte[] keyBytes = Base64.decode((String)key2);
        byte[] ivBytes = Base64.decode((String)iv2);
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, this.AES());
        Cipher keyCipher = Cipher.getInstance(this.KEY_CIPHER());
        keyCipher.init(2, queryStageMasterKey);
        byte[] fileKeyBytes = keyCipher.doFinal(keyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, decodedKey.length, this.AES());
        Cipher dataCipher = Cipher.getInstance(this.DATA_CIPHER());
        IvParameterSpec ivy = new IvParameterSpec(ivBytes);
        dataCipher.init(2, (Key)fileKey, ivy);
        return new CipherInputStream(stream, dataCipher);
    }

    public final Tuple2<String, String> parseEncryptionData(String jsonEncryptionData) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode encryptionDataNode = mapper.readTree(jsonEncryptionData);
        String iv = encryptionDataNode.findValue(this.AZ_IV()).asText();
        String key = encryptionDataNode.findValue(this.AZ_KEY_WRAP()).findValue(this.AZ_KEY()).asText();
        return new Tuple2((Object)key, (Object)iv);
    }

    public final Tuple2<Cipher, ObjectMetadata> getCipherAndS3Metadata(String masterKey, String queryId, String smkId) {
        Tuple4<Cipher, String, String, String> tuple4 = this.getCipherAndMetadata(masterKey, queryId, smkId);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Cipher cipher = (Cipher)tuple4._1();
        String matDesc = (String)tuple4._2();
        String encKeK = (String)tuple4._3();
        String ivData = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)cipher, (Object)matDesc, (Object)encKeK, (Object)ivData);
        Cipher cipher2 = (Cipher)tuple42._1();
        String matDesc2 = (String)tuple42._2();
        String encKeK2 = (String)tuple42._3();
        String ivData2 = (String)tuple42._4();
        ObjectMetadata meta = new ObjectMetadata();
        meta.addUserMetadata(this.AMZ_MATDESC(), matDesc2);
        meta.addUserMetadata(this.AMZ_KEY(), encKeK2);
        meta.addUserMetadata(this.AMZ_IV(), ivData2);
        return new Tuple2((Object)cipher2, (Object)meta);
    }

    public final Tuple2<Cipher, HashMap<String, String>> getCipherAndAZMetaData(String masterKey, String queryId, String smkId) {
        Tuple4<Cipher, String, String, String> tuple4 = this.getCipherAndMetadata(masterKey, queryId, smkId);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Cipher cipher = (Cipher)tuple4._1();
        String matDesc = (String)tuple4._2();
        String enKeK = (String)tuple4._3();
        String ivData = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)cipher, (Object)matDesc, (Object)enKeK, (Object)ivData);
        Cipher cipher2 = (Cipher)tuple42._1();
        String matDesc2 = (String)tuple42._2();
        String enKeK2 = (String)tuple42._3();
        String ivData2 = (String)tuple42._4();
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put(this.AZ_MATDESC(), matDesc2);
        meta.put(this.AZ_ENCRYPTIONDATA(), CloudStorageOperations$.buildEncryptionMetadataJSON$1(ivData2, enKeK2));
        return new Tuple2((Object)cipher2, meta);
    }

    public final Tuple4<Cipher, String, String, String> getCipherAndMetadata(String masterKey, String queryId, String smkId) {
        byte[] decodedKey = Base64.decode((String)masterKey);
        int keySize = decodedKey.length;
        byte[] fileKeyBytes = new byte[keySize];
        Cipher fileCipher = Cipher.getInstance(this.DATA_CIPHER());
        int blockSz = fileCipher.getBlockSize();
        byte[] ivData = new byte[blockSz];
        SecureRandom secRnd = SecureRandom.getInstance("SHA1PRNG", "SUN");
        secRnd.nextBytes(new byte[10]);
        secRnd.nextBytes(ivData);
        IvParameterSpec iv = new IvParameterSpec(ivData);
        secRnd.nextBytes(fileKeyBytes);
        SecretKeySpec fileKey = new SecretKeySpec(fileKeyBytes, 0, keySize, this.AES());
        fileCipher.init(1, (Key)fileKey, iv);
        Cipher keyCipher = Cipher.getInstance(this.KEY_CIPHER());
        SecretKeySpec queryStageMasterKey = new SecretKeySpec(decodedKey, 0, keySize, this.AES());
        keyCipher.init(1, queryStageMasterKey);
        byte[] encKeK = keyCipher.doFinal(fileKeyBytes);
        MatDesc matDesc = new MatDesc(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(smkId)), queryId, keySize * 8);
        return new Tuple4((Object)fileCipher, (Object)matDesc.toString(), (Object)Base64.encodeAsString((byte[])encKeK), (Object)Base64.encodeAsString((byte[])ivData));
    }

    public CloudStorage createStorageClientFromStage(Parameters.MergedParameters param, ServerConnection conn, String stageName, Option<String> dir, boolean temporary) {
        DefaultJDBCWrapper.DataBaseOperations qual$1 = DefaultJDBCWrapper$.MODULE$.DataBaseOperations(conn);
        String x$1 = stageName;
        boolean x$2 = temporary;
        Option<String> x$3 = qual$1.createStage$default$2();
        Option<String> x$4 = qual$1.createStage$default$3();
        Option<String> x$5 = qual$1.createStage$default$4();
        Option<String> x$6 = qual$1.createStage$default$5();
        boolean x$7 = qual$1.createStage$default$6();
        boolean x$8 = qual$1.createStage$default$8();
        qual$1.createStage(x$1, x$3, x$4, x$5, x$6, x$7, x$2, x$8);
        SFInternalStage stageManager = new SFInternalStage(false, param, stageName, conn, SFInternalStage$.MODULE$.$lessinit$greater$default$5());
        StageInfo.StageType stageType = stageManager.stageType();
        if (StageInfo.StageType.S3.equals(stageType)) {
            return new InternalS3Storage(param, stageName, conn, InternalS3Storage$.MODULE$.apply$default$4());
        }
        if (StageInfo.StageType.AZURE.equals(stageType)) {
            return new InternalAzureStorage(param, stageName, conn);
        }
        if (StageInfo.StageType.GCS.equals(stageType)) {
            return new InternalGcsStorage(param, stageName, conn, stageManager);
        }
        throw new UnsupportedOperationException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(80).append("Only support s3, Azure or Gcs stage,\n             | stage types: ").append(stageManager.stageType()).append("\n             |").toString())));
    }

    public Tuple2<CloudStorage, String> createStorageClient(Parameters.MergedParameters param, ServerConnection conn, boolean tempStage, Option<String> stage, String operation) {
        Option option;
        Option option2;
        Option option3;
        Regex azure_url = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("wasbs?://([^@]+)@([^.]+)\\.([^/]+)/(.*)"));
        Regex s3_url = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("s3[an]://([^/]+)/(.*)"));
        Regex gcs_url = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("gcs://([^/]+)/(.*)"));
        String stageName = (String)stage.getOrElse((Function0 & Serializable)() -> new StringBuilder(23).append("spark_connector_").append(operation).append("_stage_").append(Random$.MODULE$.alphanumeric().take(10).mkString("")).toString());
        String string = param.rootTempDir();
        if (string != null && !(option3 = azure_url.unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(4) == 0) {
            String container = (String)((LinearSeqOps)option3.get()).apply(0);
            String account = (String)((LinearSeqOps)option3.get()).apply(1);
            String endpoint = (String)((LinearSeqOps)option3.get()).apply(2);
            String path = (String)((LinearSeqOps)option3.get()).apply(3);
            Predef$.MODULE$.require(param.azureSAS().isDefined(), (Function0 & Serializable)() -> "missing Azure SAS");
            String azureSAS = (String)param.azureSAS().get();
            String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(147).append("\n             |create or replace ").append((Object)(tempStage ? "temporary" : "")).append(" stage ").append(stageName).append("\n             |url = 'azure://").append(account).append(".").append(endpoint).append("/").append(container).append("/").append(path).append("'\n             |credentials =\n             |(azure_sas_token='").append(azureSAS).append("')\n         ").toString()));
            DefaultJDBCWrapper$.MODULE$.executeQueryInterruptibly(conn, sql);
            return new Tuple2((Object)new ExternalAzureStorage(container, account, endpoint, azureSAS, param.proxyInfo(), param.maxRetryCount(), param.sfURL(), param.useExponentialBackoff(), param.expectedPartitionCount(), path, conn), (Object)stageName);
        }
        if (string != null && !(option2 = s3_url.unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0) {
            String bucket = (String)((LinearSeqOps)option2.get()).apply(0);
            String prefix = (String)((LinearSeqOps)option2.get()).apply(1);
            Predef$.MODULE$.require(param.awsAccessKey().isDefined(), (Function0 & Serializable)() -> "missing aws access key");
            Predef$.MODULE$.require(param.awsSecretKey().isDefined(), (Function0 & Serializable)() -> "missing aws secret key");
            String sql = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n             |create or replace ").append((Object)(tempStage ? "temporary" : "")).append(" stage ").append(stageName).append("\n             |url = 's3://").append(bucket).append("/").append(prefix).append("'\n             |credentials =\n             |(aws_key_id='").append(param.awsAccessKey().get()).append("' aws_secret_key='").append(param.awsSecretKey().get()).append("')\n         ").toString()));
            DefaultJDBCWrapper$.MODULE$.executeQueryInterruptibly(conn, sql);
            String x$1 = bucket;
            String x$2 = (String)param.awsAccessKey().get();
            String x$3 = (String)param.awsSecretKey().get();
            Option<ProxyInfo> x$4 = param.proxyInfo();
            int x$5 = param.maxRetryCount();
            String x$6 = param.sfURL();
            boolean x$7 = param.useExponentialBackoff();
            int x$8 = param.expectedPartitionCount();
            String x$9 = prefix;
            ServerConnection x$10 = conn;
            None$ x$11 = None$.MODULE$;
            None$ x$12 = None$.MODULE$;
            None$ x$13 = None$.MODULE$;
            Option<String> x$14 = ExternalS3Storage$.MODULE$.apply$default$9();
            int x$15 = ExternalS3Storage$.MODULE$.apply$default$12();
            return new Tuple2((Object)new ExternalS3Storage(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$14, x$9, x$10, x$15, (Option<String>)x$11, (Option<String>)x$12, (Option<String>)x$13), (Object)stageName);
        }
        if (string != null && !(option = gcs_url.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            throw new SnowflakeConnectorFeatureNotSupportException(new StringBuilder(41).append("Doesn't support GCS external stage. url: ").append(param.rootTempDir()).toString());
        }
        return new Tuple2((Object)this.createStorageClientFromStage(param, conn, stageName, (Option<String>)None$.MODULE$, tempStage), (Object)stageName);
    }

    public Option<String> createStorageClientFromStage$default$4() {
        return None$.MODULE$;
    }

    public boolean createStorageClientFromStage$default$5() {
        return false;
    }

    public boolean createStorageClient$default$3() {
        return true;
    }

    public Option<String> createStorageClient$default$4() {
        return None$.MODULE$;
    }

    public String createStorageClient$default$5() {
        return "unload";
    }

    public List<String> saveToStorage(RDD<String> data, Enumeration.Value format, Option<String> dir, boolean compress, CloudStorage storage) {
        return storage.upload(data, format, dir, compress).map((Function1 & Serializable)x$4 -> x$4.fileName());
    }

    public Enumeration.Value saveToStorage$default$2() {
        return SupportedFormat$.MODULE$.CSV();
    }

    public Option<String> saveToStorage$default$3() {
        return None$.MODULE$;
    }

    public boolean saveToStorage$default$4() {
        return true;
    }

    public void deleteFiles(List<String> files, CloudStorage storage, ServerConnection connection) {
        storage.deleteFiles(files);
    }

    public AmazonS3 createS3Client(String awsId, String awsKey, Option<String> awsToken, int parallelism, Option<ProxyInfo> proxyInfo, Option<String> useRegionUrl, Option<String> regionName, Option<String> stageEndPoint) {
        BasicAWSCredentials basicAWSCredentials;
        Option<String> option = awsToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            String token = (String)some.value();
            basicAWSCredentials = new BasicSessionCredentials(awsId, awsKey, token);
        } else if (None$.MODULE$.equals(option)) {
            basicAWSCredentials = new BasicAWSCredentials(awsId, awsKey);
        } else {
            throw new MatchError(option);
        }
        BasicAWSCredentials awsCredentials = basicAWSCredentials;
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(parallelism);
        clientConfig.setMaxErrorRetry(this.S3_MAX_RETRIES());
        clientConfig.setRetryPolicy(new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY, this.S3_MAX_RETRIES(), true));
        clientConfig.setConnectionTimeout(this.S3_MAX_TIMEOUT_MS());
        Option<ProxyInfo> option2 = proxyInfo;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            ProxyInfo proxyInfoValue = (ProxyInfo)some.value();
            proxyInfoValue.setProxyForS3(clientConfig);
        } else if (None$.MODULE$.equals(option2)) {
        } else {
            throw new MatchError(option2);
        }
        if (useRegionUrl.isEmpty()) {
            return new AmazonS3Client((AWSCredentials)awsCredentials, clientConfig);
        }
        AmazonS3ClientBuilder s3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials)).withClientConfiguration(clientConfig);
        AwsClientBuilder awsClientBuilder = stageEndPoint.nonEmpty() ? s3ClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration((String)stageEndPoint.get(), (String)regionName.get())) : (StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)useRegionUrl.get())) ? s3ClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(new StringBuilder(17).append("s3.").append(regionName.get()).append(".amazonaws.com").toString(), (String)regionName.get())) : s3ClientBuilder.withRegion((String)regionName.get()));
        return (AmazonS3)s3ClientBuilder.build();
    }

    public final CloudBlobClient createAzureClient(String storageAccount, String endpoint, Option<String> sas, Option<ProxyInfo> proxyInfo) {
        URI storageEndpoint = new URI("https", new StringBuilder(2).append(storageAccount).append(".").append(endpoint).append("/").toString(), null, null);
        StorageCredentials azCreds = sas.isDefined() ? new StorageCredentialsSharedAccessSignature((String)sas.get()) : StorageCredentialsAnonymous.ANONYMOUS;
        Option<ProxyInfo> option = proxyInfo;
        if (option instanceof Some) {
            Some some = (Some)option;
            ProxyInfo proxyInfoValue = (ProxyInfo)some.value();
            proxyInfoValue.setProxyForAzure();
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        return new CloudBlobClient(storageEndpoint, azCreds);
    }

    public final Option<String> createAzureClient$default$3() {
        return None$.MODULE$;
    }

    private static final String buildEncryptionMetadataJSON$1(String iv64, String key64) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n         | {\"EncryptionMode\":\"FullBlob\",\n         | \"WrappedContentKey\":\n         | {\"KeyId\":\"symmKey1\",\"EncryptedKey\":\"").append(key64).append("\",\"Algorithm\":\"AES_CBC_256\"},\n         | \"EncryptionAgent\":{\"Protocol\":\"1.0\",\"EncryptionAlgorithm\":\"AES_CBC_256\"},\n         | \"ContentEncryptionIV\":\"").append(iv64).append("\",\n         | \"KeyWrappingMetadata\":{\"EncryptionLibrary\":\"Java 5.3.0\"}}\n       ").toString()));
    }

    private CloudStorageOperations$() {
    }
}

