/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty;

import java.util.concurrent.Executor;
import net.solarnetwork.common.mqtt.MqttConnection;
import net.solarnetwork.common.mqtt.MqttConnectionConfig;
import net.solarnetwork.common.mqtt.MqttConnectionFactory;
import net.solarnetwork.common.mqtt.WireLoggingSupport;
import net.solarnetwork.common.mqtt.netty.NettyMqttConnection;
import org.springframework.scheduling.TaskScheduler;

public class NettyMqttConnectionFactory
implements MqttConnectionFactory,
WireLoggingSupport {
    private final Executor executor;
    private final TaskScheduler scheduler;
    private int ioThreadCount = 2;
    private boolean wireLogging = false;

    public NettyMqttConnectionFactory(Executor executor, TaskScheduler scheduler) {
        this.executor = executor;
        this.scheduler = scheduler;
    }

    public MqttConnection createConnection(MqttConnectionConfig config) {
        NettyMqttConnection conn = new NettyMqttConnection(this.executor, this.scheduler, config);
        conn.setIoThreadCount(this.ioThreadCount);
        conn.setWireLoggingEnabled(this.wireLogging);
        return conn;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public void setIoThreadCount(int ioThreadCount) {
        this.ioThreadCount = ioThreadCount;
    }

    public boolean isWireLoggingEnabled() {
        return this.wireLogging;
    }

    public void setWireLoggingEnabled(boolean wireLogging) {
        this.wireLogging = wireLogging;
    }
}

