/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty;

import io.netty.handler.codec.mqtt.MqttQoS;
import net.solarnetwork.common.mqtt.MqttQos;

public final class NettyMqttUtils {
    private NettyMqttUtils() {
    }

    public static MqttQos qosLevel(MqttQoS qos) {
        if (qos == null) {
            return MqttQos.AtLeastOnce;
        }
        switch (qos) {
            case EXACTLY_ONCE: {
                return MqttQos.ExactlyOnce;
            }
            case AT_LEAST_ONCE: {
                return MqttQos.AtLeastOnce;
            }
        }
        return MqttQos.AtMostOnce;
    }

    public static MqttQoS qos(MqttQos qosLevel) {
        if (qosLevel == null) {
            return MqttQoS.AT_LEAST_ONCE;
        }
        switch (qosLevel) {
            case ExactlyOnce: {
                return MqttQoS.EXACTLY_ONCE;
            }
            case AtLeastOnce: {
                return MqttQoS.AT_LEAST_ONCE;
            }
        }
        return MqttQoS.AT_MOST_ONCE;
    }
}

