/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.solarnetwork.common.mqtt.BasicMqttTopicAliases;
import net.solarnetwork.common.mqtt.MqttMessage;
import net.solarnetwork.common.mqtt.MqttTopicAliases;
import net.solarnetwork.common.mqtt.NoOpMqttTopicAliases;
import net.solarnetwork.common.mqtt.netty.NettyMqttMessage;
import net.solarnetwork.common.mqtt.netty.client.MqttClientConfig;
import net.solarnetwork.common.mqtt.netty.client.MqttClientImpl;
import net.solarnetwork.common.mqtt.netty.client.MqttConnectResult;
import net.solarnetwork.common.mqtt.netty.client.MqttIncomingQos2Publish;
import net.solarnetwork.common.mqtt.netty.client.MqttPendingPublish;
import net.solarnetwork.common.mqtt.netty.client.MqttPendingSubscription;
import net.solarnetwork.common.mqtt.netty.client.MqttPendingUnsubscription;
import net.solarnetwork.common.mqtt.netty.client.MqttPubackReasonCode;
import net.solarnetwork.common.mqtt.netty.client.MqttSubscription;
import net.solarnetwork.service.RemoteServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MqttChannelHandler
extends SimpleChannelInboundHandler<io.netty.handler.codec.mqtt.MqttMessage> {
    private static final Logger log = LoggerFactory.getLogger(MqttChannelHandler.class);
    private final MqttClientImpl client;
    private final Promise<MqttConnectResult> connectFuture;
    private final MqttTopicAliases serverAliases;

    MqttChannelHandler(MqttClientImpl client, Promise<MqttConnectResult> connectFuture) {
        this.client = client;
        this.connectFuture = connectFuture;
        this.serverAliases = client.getClientConfig().getProtocolVersion().protocolLevel() > 4 ? new BasicMqttTopicAliases(0) : new NoOpMqttTopicAliases();
    }

    protected void channelRead0(ChannelHandlerContext ctx, io.netty.handler.codec.mqtt.MqttMessage msg) throws Exception {
        switch (msg.fixedHeader().messageType()) {
            case CONNACK: {
                this.handleConack(ctx.channel(), (MqttConnAckMessage)msg);
                break;
            }
            case SUBACK: {
                this.handleSubAck((MqttSubAckMessage)msg);
                break;
            }
            case PUBLISH: {
                this.handlePublish(ctx.channel(), (MqttPublishMessage)msg);
                break;
            }
            case UNSUBACK: {
                this.handleUnsuback((MqttUnsubAckMessage)msg);
                break;
            }
            case PUBACK: {
                this.handlePuback((MqttPubAckMessage)msg);
                break;
            }
            case PUBREC: {
                this.handlePubrec(ctx.channel(), msg);
                break;
            }
            case PUBREL: {
                this.handlePubrel(ctx.channel(), msg);
                break;
            }
            case PUBCOMP: {
                this.handlePubcomp(msg);
                break;
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.CONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttClientConfig config = this.client.getClientConfig();
        MqttConnectVariableHeader variableHeader = new MqttConnectVariableHeader(config.getProtocolVersion().protocolName(), (int)config.getProtocolVersion().protocolLevel(), config.getUsername() != null, config.getPassword() != null, config.getLastWill() != null && config.getLastWill().isRetain(), config.getLastWill() != null ? config.getLastWill().getQos().value() : 0, config.getLastWill() != null, config.isCleanSession(), config.getTimeoutSeconds(), config.getConnectionProperties());
        MqttConnectPayload payload = new MqttConnectPayload(config.getClientId(), config.getLastWill() != null ? config.getLastWill().getTopic() : null, config.getLastWill() != null ? config.getLastWill().getMessage().getBytes(CharsetUtil.UTF_8) : null, config.getUsername(), config.getPassword() != null ? config.getPassword().getBytes(CharsetUtil.UTF_8) : null);
        ctx.channel().writeAndFlush((Object)new MqttConnectMessage(fixedHeader, variableHeader, payload));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        log.debug("Clearing topic aliases for server (max {}) and client (max {})", (Object)this.serverAliases.getMaximumAliasCount(), (Object)this.client.getTopicAliases().getMaximumAliasCount());
        this.serverAliases.setMaximumAliasCount(0);
        this.client.getTopicAliases().setMaximumAliasCount(0);
    }

    private void invokeHandlersForIncomingPublish(MqttPublishMessage message) {
        MqttProperties.MqttProperty prop;
        boolean handlerInvoked = false;
        String msgTopic = message.variableHeader().topicName();
        MqttProperties props = message.variableHeader().properties();
        Integer topicAlias = null;
        if (props != null && (prop = props.getProperty(MqttProperties.MqttPropertyType.TOPIC_ALIAS.value())) instanceof MqttProperties.IntegerProperty) {
            topicAlias = (Integer)((MqttProperties.IntegerProperty)prop).value();
        }
        String topic = this.serverAliases.aliasedTopic(msgTopic, topicAlias);
        if (log.isDebugEnabled() && topicAlias != null) {
            log.debug("Received message {} resolved topic [{}] with alias {} as [{}]", new Object[]{message.variableHeader().packetId(), msgTopic, topicAlias, topic});
        }
        for (MqttSubscription subscription : new LinkedHashSet(this.client.getSubscriptions().values().stream().flatMap(Collection::stream).collect(Collectors.toList()))) {
            if (!subscription.matches(topic) || subscription.isOnce() && subscription.isCalled()) continue;
            message.payload().markReaderIndex();
            subscription.setCalled(true);
            subscription.getHandler().onMqttMessage((MqttMessage)new NettyMqttMessage(topic, message.fixedHeader().isRetain(), message.fixedHeader().qosLevel(), message.payload()));
            if (subscription.isOnce()) {
                this.client.off(subscription.getTopic(), subscription.getHandler());
            }
            message.payload().resetReaderIndex();
            handlerInvoked = true;
        }
        if (!handlerInvoked && this.client.getDefaultHandler() != null) {
            this.client.getDefaultHandler().onMqttMessage((MqttMessage)new NettyMqttMessage(topic, message.fixedHeader().isRetain(), message.fixedHeader().qosLevel(), message.payload()));
        }
        message.payload().release();
    }

    private void handleConack(Channel channel, MqttConnAckMessage message) {
        Integer max;
        MqttProperties.MqttProperty prop;
        MqttProperties props = message.variableHeader().properties();
        int maxPublishTopicAliases = 0;
        if (props != null && (prop = props.getProperty(MqttProperties.MqttPropertyType.TOPIC_ALIAS_MAXIMUM.value())) instanceof MqttProperties.IntegerProperty && (max = (Integer)((MqttProperties.IntegerProperty)prop).value()) != null) {
            maxPublishTopicAliases = max;
        }
        switch (message.variableHeader().connectReturnCode()) {
            case CONNECTION_ACCEPTED: {
                this.client.getTopicAliases().setMaximumAliasCount(maxPublishTopicAliases);
                int maxSubscribeTopicAliases = this.client.getClientConfig().getProtocolVersion().protocolLevel() > 4 ? this.client.getClientConfig().getMaximumTopicAliases() : 0;
                this.serverAliases.setMaximumAliasCount(maxSubscribeTopicAliases);
                log.debug("MQTT connection {} allowable topic aliases for server: {}; client: {}", new Object[]{this.client.getServerUri(), maxSubscribeTopicAliases, maxPublishTopicAliases});
                this.connectFuture.setSuccess((Object)new MqttConnectResult(true, MqttConnectReturnCode.CONNECTION_ACCEPTED, channel.closeFuture()));
                this.client.getPendingSubscriptions().entrySet().stream().filter(e -> !((MqttPendingSubscription)e.getValue()).isSent()).forEach(e -> {
                    channel.write((Object)((MqttPendingSubscription)e.getValue()).getSubscribeMessage());
                    ((MqttPendingSubscription)e.getValue()).setSent(true);
                });
                this.client.getPendingPublishes().forEach((id, publish) -> {
                    if (publish.isSent()) {
                        return;
                    }
                    channel.write((Object)publish.getMessage());
                    publish.setSent(true);
                    if (publish.getQos() == MqttQoS.AT_MOST_ONCE) {
                        publish.getFuture().setSuccess(null);
                        this.client.getPendingPublishes().remove(publish.getMessageId());
                    }
                });
                channel.flush();
                if (!this.client.isReconnect()) break;
                this.client.onSuccessfulReconnect();
                break;
            }
            case CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD: 
            case CONNECTION_REFUSED_IDENTIFIER_REJECTED: 
            case CONNECTION_REFUSED_NOT_AUTHORIZED: 
            case CONNECTION_REFUSED_SERVER_UNAVAILABLE: 
            case CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION: 
            case CONNECTION_REFUSED_BAD_AUTHENTICATION_METHOD: 
            case CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD: 
            case CONNECTION_REFUSED_BANNED: 
            case CONNECTION_REFUSED_CLIENT_IDENTIFIER_NOT_VALID: 
            case CONNECTION_REFUSED_CONNECTION_RATE_EXCEEDED: 
            case CONNECTION_REFUSED_IMPLEMENTATION_SPECIFIC: 
            case CONNECTION_REFUSED_MALFORMED_PACKET: 
            case CONNECTION_REFUSED_NOT_AUTHORIZED_5: 
            case CONNECTION_REFUSED_PACKET_TOO_LARGE: 
            case CONNECTION_REFUSED_PAYLOAD_FORMAT_INVALID: 
            case CONNECTION_REFUSED_PROTOCOL_ERROR: 
            case CONNECTION_REFUSED_QOS_NOT_SUPPORTED: 
            case CONNECTION_REFUSED_QUOTA_EXCEEDED: 
            case CONNECTION_REFUSED_RETAIN_NOT_SUPPORTED: 
            case CONNECTION_REFUSED_SERVER_BUSY: 
            case CONNECTION_REFUSED_SERVER_MOVED: 
            case CONNECTION_REFUSED_SERVER_UNAVAILABLE_5: 
            case CONNECTION_REFUSED_TOPIC_NAME_INVALID: 
            case CONNECTION_REFUSED_UNSPECIFIED_ERROR: 
            case CONNECTION_REFUSED_UNSUPPORTED_PROTOCOL_VERSION: 
            case CONNECTION_REFUSED_USE_ANOTHER_SERVER: {
                this.connectFuture.setSuccess((Object)new MqttConnectResult(false, message.variableHeader().connectReturnCode(), channel.closeFuture()));
                channel.close();
            }
        }
    }

    private void handleSubAck(MqttSubAckMessage message) {
        MqttPendingSubscription pendingSubscription = (MqttPendingSubscription)this.client.getPendingSubscriptions().remove(message.variableHeader().messageId());
        if (pendingSubscription == null) {
            return;
        }
        pendingSubscription.onSubackReceived();
        for (MqttPendingSubscription.MqttPendingHandler handler : pendingSubscription.getHandlers()) {
            MqttSubscription subscription = new MqttSubscription(pendingSubscription.getTopic(), handler.getHandler(), handler.isOnce());
            CopyOnWriteArrayList l = (CopyOnWriteArrayList)this.client.getSubscriptions().computeIfAbsent((Object)pendingSubscription.getTopic(), k -> new CopyOnWriteArrayList());
            l.addIfAbsent(subscription);
            l = (CopyOnWriteArrayList)this.client.getHandlerToSubscribtion().computeIfAbsent((Object)handler.getHandler(), k -> new CopyOnWriteArrayList());
            l.addIfAbsent(subscription);
        }
        this.client.getPendingSubscribeTopics().remove(pendingSubscription.getTopic());
        this.client.getServerSubscriptions().add(pendingSubscription.getTopic());
        if (!pendingSubscription.getFuture().isDone()) {
            pendingSubscription.getFuture().setSuccess(null);
        }
    }

    private void handlePublish(Channel channel, MqttPublishMessage message) {
        switch (message.fixedHeader().qosLevel()) {
            case AT_MOST_ONCE: {
                this.invokeHandlersForIncomingPublish(message);
                break;
            }
            case AT_LEAST_ONCE: {
                this.invokeHandlersForIncomingPublish(message);
                if (message.variableHeader().packetId() == -1) break;
                MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
                MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)message.variableHeader().packetId());
                channel.writeAndFlush((Object)new MqttPubAckMessage(fixedHeader, variableHeader));
                break;
            }
            case EXACTLY_ONCE: {
                if (message.variableHeader().packetId() == -1) break;
                MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREC, false, MqttQoS.AT_MOST_ONCE, false, 0);
                MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)message.variableHeader().packetId());
                io.netty.handler.codec.mqtt.MqttMessage pubrecMessage = new io.netty.handler.codec.mqtt.MqttMessage(fixedHeader, (Object)variableHeader);
                MqttIncomingQos2Publish incomingQos2Publish = new MqttIncomingQos2Publish(message, pubrecMessage);
                this.client.getQos2PendingIncomingPublishes().put(message.variableHeader().packetId(), (Object)incomingQos2Publish);
                message.payload().retain();
                incomingQos2Publish.startPubrecRetransmitTimer(this.client.getEventLoop().next(), this.client::sendAndFlushPacket);
                channel.writeAndFlush((Object)pubrecMessage);
                break;
            }
        }
    }

    private void handleUnsuback(MqttUnsubAckMessage message) {
        MqttPendingUnsubscription unsubscription = (MqttPendingUnsubscription)this.client.getPendingServerUnsubscribes().get(message.variableHeader().messageId());
        if (unsubscription == null) {
            return;
        }
        unsubscription.onUnsubackReceived();
        this.client.getServerSubscriptions().remove(unsubscription.getTopic());
        unsubscription.getFuture().setSuccess(null);
        this.client.getPendingServerUnsubscribes().remove(message.variableHeader().messageId());
    }

    private void handlePuback(MqttPubAckMessage message) {
        MqttPendingPublish pendingPublish = (MqttPendingPublish)this.client.getPendingPublishes().get(message.variableHeader().messageId());
        if (pendingPublish == null) {
            return;
        }
        pendingPublish.onPubackReceived();
        this.client.getPendingPublishes().remove(message.variableHeader().messageId());
        byte reasonCode = 0;
        if (message.variableHeader() instanceof MqttPubReplyMessageVariableHeader) {
            MqttPubReplyMessageVariableHeader rep = (MqttPubReplyMessageVariableHeader)message.variableHeader();
            reasonCode = rep.reasonCode();
        }
        if (reasonCode != 0) {
            MqttPubackReasonCode r = null;
            try {
                r = MqttPubackReasonCode.forCode(reasonCode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String msg = r != null ? String.format("Unsuccessful PUBACK reason code %d (%s) on message %d", new Object[]{Byte.toUnsignedInt(reasonCode), r, message.variableHeader().messageId()}) : String.format("Unsuccessful PUBACK reason code %d on message %d", Byte.toUnsignedInt(reasonCode), message.variableHeader().messageId());
            RemoteServiceException ex = new RemoteServiceException(msg);
            pendingPublish.getFuture().setFailure((Throwable)ex);
        } else {
            String topic = pendingPublish.getMessage().variableHeader().topicName();
            if (topic != null && !topic.isEmpty() && this.client.getTopicAliases().getMaximumAliasCount() > 0) {
                this.client.getTopicAliases().confirmTopicAlias(topic);
            }
            pendingPublish.getFuture().setSuccess(null);
        }
        pendingPublish.getPayload().release();
    }

    private void handlePubrec(Channel channel, io.netty.handler.codec.mqtt.MqttMessage message) {
        MqttPendingPublish pendingPublish = (MqttPendingPublish)this.client.getPendingPublishes().get(((MqttMessageIdVariableHeader)message.variableHeader()).messageId());
        pendingPublish.onPubackReceived();
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)message.variableHeader();
        io.netty.handler.codec.mqtt.MqttMessage pubrelMessage = new io.netty.handler.codec.mqtt.MqttMessage(fixedHeader, (Object)variableHeader);
        channel.writeAndFlush((Object)pubrelMessage);
        pendingPublish.setPubrelMessage(pubrelMessage);
        pendingPublish.startPubrelRetransmissionTimer(this.client.getEventLoop().next(), this.client::sendAndFlushPacket);
    }

    private void handlePubrel(Channel channel, io.netty.handler.codec.mqtt.MqttMessage message) {
        if (this.client.getQos2PendingIncomingPublishes().containsKey(((MqttMessageIdVariableHeader)message.variableHeader()).messageId())) {
            MqttIncomingQos2Publish incomingQos2Publish = (MqttIncomingQos2Publish)this.client.getQos2PendingIncomingPublishes().get(((MqttMessageIdVariableHeader)message.variableHeader()).messageId());
            this.invokeHandlersForIncomingPublish(incomingQos2Publish.getIncomingPublish());
            incomingQos2Publish.onPubrelReceived();
            this.client.getQos2PendingIncomingPublishes().remove(incomingQos2Publish.getIncomingPublish().variableHeader().packetId());
        }
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)((MqttMessageIdVariableHeader)message.variableHeader()).messageId());
        channel.writeAndFlush((Object)new io.netty.handler.codec.mqtt.MqttMessage(fixedHeader, (Object)variableHeader));
    }

    private void handlePubcomp(io.netty.handler.codec.mqtt.MqttMessage message) {
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)message.variableHeader();
        MqttPendingPublish pendingPublish = (MqttPendingPublish)this.client.getPendingPublishes().get(variableHeader.messageId());
        pendingPublish.getFuture().setSuccess(null);
        this.client.getPendingPublishes().remove(variableHeader.messageId());
        pendingPublish.getPayload().release();
        pendingPublish.onPubcompReceived();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (log.isWarnEnabled() && !this.client.isDisconnected()) {
            if (cause instanceof IOException) {
                log.warn("Communication problem in MQTT connection {}: {}", (Object)this.client.getServerUri(), (Object)cause.getMessage());
            } else {
                log.warn("Exception in MQTT connection {}: {}", new Object[]{this.client.getServerUri(), cause.toString(), cause});
            }
        }
    }
}

