/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.net.URI;
import java.util.concurrent.Future;
import net.solarnetwork.common.mqtt.MqttMessageHandler;
import net.solarnetwork.common.mqtt.MqttProperties;
import net.solarnetwork.common.mqtt.MqttTopicAliases;
import net.solarnetwork.common.mqtt.netty.client.MqttClientCallback;
import net.solarnetwork.common.mqtt.netty.client.MqttClientConfig;
import net.solarnetwork.common.mqtt.netty.client.MqttClientImpl;
import net.solarnetwork.common.mqtt.netty.client.MqttConnectResult;

public interface MqttClient {
    public void setWireLogging(boolean var1);

    public io.netty.util.concurrent.Future<MqttConnectResult> connect(String var1);

    public io.netty.util.concurrent.Future<MqttConnectResult> connect(String var1, int var2);

    public boolean isConnected();

    public URI getServerUri();

    public io.netty.util.concurrent.Future<MqttConnectResult> reconnect();

    public EventLoopGroup getEventLoop();

    public void setEventLoop(EventLoopGroup var1);

    public io.netty.util.concurrent.Future<Void> on(String var1, MqttMessageHandler var2);

    public io.netty.util.concurrent.Future<Void> on(String var1, MqttMessageHandler var2, MqttQoS var3);

    public io.netty.util.concurrent.Future<Void> once(String var1, MqttMessageHandler var2);

    public io.netty.util.concurrent.Future<Void> once(String var1, MqttMessageHandler var2, MqttQoS var3);

    public io.netty.util.concurrent.Future<Void> off(String var1, MqttMessageHandler var2);

    public io.netty.util.concurrent.Future<Void> off(String var1);

    public io.netty.util.concurrent.Future<Void> publish(String var1, ByteBuf var2);

    public io.netty.util.concurrent.Future<Void> publish(String var1, ByteBuf var2, MqttQoS var3);

    public io.netty.util.concurrent.Future<Void> publish(String var1, ByteBuf var2, boolean var3);

    public io.netty.util.concurrent.Future<Void> publish(String var1, ByteBuf var2, MqttQoS var3, boolean var4);

    public io.netty.util.concurrent.Future<Void> publish(String var1, ByteBuf var2, MqttQoS var3, boolean var4, MqttProperties var5);

    public MqttClientConfig getClientConfig();

    public static MqttClient create(MqttClientConfig config, MqttMessageHandler defaultHandler) {
        return new MqttClientImpl(config, defaultHandler);
    }

    public Future<?> disconnect();

    public boolean isDisconnected();

    public void setCallback(MqttClientCallback var1);

    public MqttTopicAliases getTopicAliases();
}

