/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.handler.ssl.SslContext;
import java.util.Random;
import net.solarnetwork.common.mqtt.netty.client.MqttLastWill;

public final class MqttClientConfig {
    private final SslContext sslContext;
    private final String randomClientId;
    private final MqttProperties connectionProperties = new MqttProperties();
    private String clientId;
    private int timeoutSeconds = 60;
    private int readTimeoutSeconds = -1;
    private int writeTimeoutSeconds = -1;
    private MqttVersion protocolVersion = MqttVersion.MQTT_3_1;
    private String username = null;
    private String password = null;
    private boolean cleanSession = true;
    private MqttLastWill lastWill;
    private Class<? extends Channel> channelClass = NioSocketChannel.class;
    private boolean reconnect = true;
    private long reconnectDelay = 1L;
    private int maxBytesInMessage = 8092;

    public MqttClientConfig() {
        this(null);
    }

    public MqttClientConfig(SslContext sslContext) {
        this.sslContext = sslContext;
        Random random = new Random();
        String id = "netty-mqtt/";
        String[] options = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".split("");
        for (int i = 0; i < 8; ++i) {
            id = id + options[random.nextInt(options.length)];
        }
        this.clientId = id;
        this.randomClientId = id;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId == null ? this.randomClientId : clientId;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        if (timeoutSeconds != -1 && timeoutSeconds <= 0) {
            throw new IllegalArgumentException("timeoutSeconds must be > 0 or -1");
        }
        this.timeoutSeconds = timeoutSeconds;
    }

    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    public int getWriteTimeoutSeconds() {
        return this.writeTimeoutSeconds;
    }

    public void setWriteTimeoutSeconds(int writeTimeoutSeconds) {
        this.writeTimeoutSeconds = writeTimeoutSeconds;
    }

    public MqttVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(MqttVersion protocolVersion) {
        if (protocolVersion == null) {
            throw new NullPointerException("protocolVersion");
        }
        this.protocolVersion = protocolVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public MqttLastWill getLastWill() {
        return this.lastWill;
    }

    public void setLastWill(MqttLastWill lastWill) {
        this.lastWill = lastWill;
    }

    public Class<? extends Channel> getChannelClass() {
        return this.channelClass;
    }

    public void setChannelClass(Class<? extends Channel> channelClass) {
        this.channelClass = channelClass;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        if (reconnectDelay <= 0L) {
            throw new IllegalArgumentException("reconnectDelay must be > 0");
        }
        this.reconnectDelay = reconnectDelay;
    }

    public int getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public void setMaxBytesInMessage(int maxBytesInMessage) {
        if (maxBytesInMessage <= 0 || maxBytesInMessage > 256000000) {
            throw new IllegalArgumentException("maxBytesInMessage must be > 0 or < 256_000_000");
        }
        this.maxBytesInMessage = maxBytesInMessage;
    }

    public MqttProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setMaximumTopicAliases(int max) {
        this.connectionProperties.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.TOPIC_ALIAS_MAXIMUM.value(), Integer.valueOf(max)));
    }

    public int getMaximumTopicAliases() {
        MqttProperties.MqttProperty prop = this.connectionProperties.getProperty(MqttProperties.MqttPropertyType.TOPIC_ALIAS_MAXIMUM.value());
        return prop instanceof MqttProperties.IntegerProperty ? (Integer)((MqttProperties.IntegerProperty)prop).value() : 0;
    }
}

