/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.solarnetwork.common.mqtt.BasicMqttTopicAliases;
import net.solarnetwork.common.mqtt.MqttMessageHandler;
import net.solarnetwork.common.mqtt.MqttProperties;
import net.solarnetwork.common.mqtt.MqttProperty;
import net.solarnetwork.common.mqtt.MqttTopicAliases;
import net.solarnetwork.common.mqtt.netty.client.ChannelClosedException;
import net.solarnetwork.common.mqtt.netty.client.MqttChannelHandler;
import net.solarnetwork.common.mqtt.netty.client.MqttClient;
import net.solarnetwork.common.mqtt.netty.client.MqttClientCallback;
import net.solarnetwork.common.mqtt.netty.client.MqttClientConfig;
import net.solarnetwork.common.mqtt.netty.client.MqttConnectResult;
import net.solarnetwork.common.mqtt.netty.client.MqttIncomingQos2Publish;
import net.solarnetwork.common.mqtt.netty.client.MqttPendingPublish;
import net.solarnetwork.common.mqtt.netty.client.MqttPendingSubscription;
import net.solarnetwork.common.mqtt.netty.client.MqttPendingUnsubscription;
import net.solarnetwork.common.mqtt.netty.client.MqttPingHandler;
import net.solarnetwork.common.mqtt.netty.client.MqttSubscription;
import net.solarnetwork.domain.KeyValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

final class MqttClientImpl
implements MqttClient {
    public static final int READ_TIMEOUT_FACTOR = 2;
    private static final Logger log = LoggerFactory.getLogger(MqttClientImpl.class);
    private final Set<String> serverSubscriptions = new HashSet<String>();
    private final IntObjectHashMap<MqttPendingUnsubscription> pendingServerUnsubscribes = new IntObjectHashMap();
    private final IntObjectHashMap<MqttIncomingQos2Publish> qos2PendingIncomingPublishes = new IntObjectHashMap();
    private final ConcurrentMap<Integer, MqttPendingPublish> pendingPublishes = new ConcurrentHashMap<Integer, MqttPendingPublish>(16, 0.7f, 2);
    private final MultiValueMap<String, MqttSubscription> subscriptions = new LinkedMultiValueMap();
    private final IntObjectHashMap<MqttPendingSubscription> pendingSubscriptions = new IntObjectHashMap();
    private final Set<String> pendingSubscribeTopics = new HashSet<String>();
    private final MultiValueMap<MqttMessageHandler, MqttSubscription> handlerToSubscribtion = new LinkedMultiValueMap();
    private final AtomicInteger nextMessageId = new AtomicInteger(0);
    private final MqttTopicAliases clientAliases = new BasicMqttTopicAliases(0);
    private final MqttClientConfig clientConfig;
    private final MqttMessageHandler defaultHandler;
    private EventLoopGroup eventLoop;
    private volatile Channel channel;
    private volatile boolean disconnected = false;
    private volatile boolean reconnect = false;
    private boolean wireLogging = false;
    private String host;
    private int port;
    private MqttClientCallback callback;
    private boolean publishRetransmit = false;
    private int pendingAbortTimeoutMinutes = 60;

    public MqttClientImpl(MqttMessageHandler defaultHandler) {
        this.clientConfig = new MqttClientConfig();
        this.defaultHandler = defaultHandler;
    }

    public MqttClientImpl(MqttClientConfig clientConfig, MqttMessageHandler defaultHandler) {
        this.clientConfig = clientConfig;
        this.defaultHandler = defaultHandler;
    }

    @Override
    public io.netty.util.concurrent.Future<MqttConnectResult> connect(String host) {
        return this.connect(host, 1883);
    }

    @Override
    public io.netty.util.concurrent.Future<MqttConnectResult> connect(String host, int port) {
        return this.connect(host, port, false);
    }

    private io.netty.util.concurrent.Future<MqttConnectResult> connect(String host, int port, boolean reconnect) {
        if (this.eventLoop == null) {
            NioEventLoopGroup el = new NioEventLoopGroup();
            this.setEventLoop((EventLoopGroup)el);
        }
        this.host = host;
        this.port = port;
        DefaultPromise connectFuture = new DefaultPromise((EventExecutor)this.eventLoop.next());
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.eventLoop);
        bootstrap.channel(this.clientConfig.getChannelClass());
        bootstrap.remoteAddress(host, port);
        bootstrap.handler((ChannelHandler)new MqttChannelInitializer((Promise<MqttConnectResult>)connectFuture, host, port, this.clientConfig.getSslContext()));
        ChannelFuture future = bootstrap.connect();
        future.addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (f.isSuccess()) {
                this.channel = f.channel();
                this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                    if (this.isConnected()) {
                        return;
                    }
                    ChannelClosedException e = new ChannelClosedException("Channel is closed!");
                    if (this.callback != null) {
                        try {
                            this.callback.connectionLost(e);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.pendingSubscriptions.clear();
                    this.serverSubscriptions.clear();
                    this.subscriptions.clear();
                    this.pendingServerUnsubscribes.clear();
                    this.qos2PendingIncomingPublishes.clear();
                    this.pendingPublishes.clear();
                    this.pendingSubscribeTopics.clear();
                    this.handlerToSubscribtion.clear();
                    this.clientAliases.setMaximumAliasCount(0);
                    this.scheduleConnectIfRequired(host, port, true);
                }));
            } else {
                this.scheduleConnectIfRequired(host, port, reconnect);
            }
        }));
        return connectFuture;
    }

    private void scheduleConnectIfRequired(String host, int port, boolean reconnect) {
        if (this.clientConfig.isReconnect() && !this.disconnected) {
            if (reconnect) {
                this.reconnect = true;
            }
            this.eventLoop.schedule(() -> this.connect(host, port, reconnect), this.clientConfig.getReconnectDelay(), TimeUnit.SECONDS);
        }
    }

    private void cleanup() {
        int timeoutMins = this.getPendingAbortTimeoutMinutes();
        long timeout = TimeUnit.MINUTES.toMillis(timeoutMins);
        if (timeout < 1L) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator itr = this.getPendingPublishes().values().iterator();
        while (itr.hasNext()) {
            MqttPendingPublish pending = (MqttPendingPublish)itr.next();
            if (pending.getDate() + timeout >= now) continue;
            log.warn("Timeout on pending publish message {}: aborting publish.", (Object)pending.getMessageId());
            pending.stop();
            pending.getFuture().setFailure((Throwable)new TimeoutException("Failed to publish message within " + timeoutMins + " minutes"));
            pending.getPayload().release();
            itr.remove();
        }
    }

    @Override
    public URI getServerUri() {
        String host = this.host;
        if (host == null || host.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder("mqtt");
        if (this.clientConfig.getSslContext() != null) {
            buf.append("s");
        }
        buf.append("://").append(host).append(":").append(this.port);
        try {
            return new URI(buf.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad URI syntax from [" + buf + "]", e);
        }
    }

    @Override
    public boolean isConnected() {
        return !this.disconnected && this.channel != null && this.channel.isActive();
    }

    @Override
    public io.netty.util.concurrent.Future<MqttConnectResult> reconnect() {
        if (this.host == null) {
            throw new IllegalStateException("Cannot reconnect. Call connect() first");
        }
        return this.connect(this.host, this.port);
    }

    @Override
    public EventLoopGroup getEventLoop() {
        return this.eventLoop;
    }

    @Override
    public void setEventLoop(EventLoopGroup eventLoop) {
        this.eventLoop = eventLoop;
        eventLoop.scheduleWithFixedDelay(this::cleanup, 30L, 30L, TimeUnit.MINUTES);
    }

    @Override
    public io.netty.util.concurrent.Future<Void> on(String topic, MqttMessageHandler handler) {
        return this.on(topic, handler, MqttQoS.AT_MOST_ONCE);
    }

    @Override
    public io.netty.util.concurrent.Future<Void> on(String topic, MqttMessageHandler handler, MqttQoS qos) {
        return this.createSubscription(topic, handler, false, qos);
    }

    @Override
    public io.netty.util.concurrent.Future<Void> once(String topic, MqttMessageHandler handler) {
        return this.once(topic, handler, MqttQoS.AT_MOST_ONCE);
    }

    @Override
    public io.netty.util.concurrent.Future<Void> once(String topic, MqttMessageHandler handler, MqttQoS qos) {
        return this.createSubscription(topic, handler, true, qos);
    }

    @Override
    public io.netty.util.concurrent.Future<Void> off(String topic, MqttMessageHandler handler) {
        DefaultPromise future = new DefaultPromise((EventExecutor)this.eventLoop.next());
        List subs = (List)this.handlerToSubscribtion.get((Object)handler);
        if (subs != null) {
            for (MqttSubscription subscription : new ArrayList(subs)) {
                if (!topic.equals(subscription.getTopic())) continue;
                this.subscriptions.computeIfPresent((Object)topic, (k, v) -> {
                    if (v != null) {
                        v.remove(subscription);
                    }
                    return v;
                });
                subs.remove(subscription);
            }
        }
        this.handlerToSubscribtion.computeIfPresent((Object)handler, (k, v) -> {
            if (v != null && v.isEmpty()) {
                v = null;
            }
            return v;
        });
        this.checkSubscribtions(topic, (Promise<Void>)future);
        return future;
    }

    @Override
    public io.netty.util.concurrent.Future<Void> off(String topic) {
        DefaultPromise future = new DefaultPromise((EventExecutor)this.eventLoop.next());
        LinkedHashSet subscriptions = new LinkedHashSet((Collection)this.subscriptions.get((Object)topic));
        for (MqttSubscription subscription : subscriptions) {
            for (MqttSubscription handSub : (List)this.handlerToSubscribtion.get((Object)subscription.getHandler())) {
                this.subscriptions.computeIfPresent((Object)topic, (k, v) -> {
                    if (v != null) {
                        v.remove(handSub);
                    }
                    return v;
                });
            }
            this.handlerToSubscribtion.computeIfPresent((Object)subscription.getHandler(), (k, v) -> {
                if (v != null) {
                    v.remove(subscription);
                }
                return v;
            });
        }
        this.checkSubscribtions(topic, (Promise<Void>)future);
        return future;
    }

    @Override
    public io.netty.util.concurrent.Future<Void> publish(String topic, ByteBuf payload) {
        return this.publish(topic, payload, MqttQoS.AT_MOST_ONCE, false, null);
    }

    @Override
    public io.netty.util.concurrent.Future<Void> publish(String topic, ByteBuf payload, MqttQoS qos) {
        return this.publish(topic, payload, qos, false, null);
    }

    @Override
    public io.netty.util.concurrent.Future<Void> publish(String topic, ByteBuf payload, boolean retain) {
        return this.publish(topic, payload, MqttQoS.AT_MOST_ONCE, retain, null);
    }

    @Override
    public io.netty.util.concurrent.Future<Void> publish(String topic, ByteBuf payload, MqttQoS qos, boolean retain) {
        return this.publish(topic, payload, qos, retain, null);
    }

    @Override
    public io.netty.util.concurrent.Future<Void> publish(String topic, ByteBuf payload, MqttQoS qos, boolean retain, MqttProperties properties) {
        DefaultPromise future = new DefaultPromise((EventExecutor)this.eventLoop.next());
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, qos, retain, 0);
        io.netty.handler.codec.mqtt.MqttProperties props = io.netty.handler.codec.mqtt.MqttProperties.NO_PROPERTIES;
        if (properties != null && !properties.isEmpty()) {
            props = new io.netty.handler.codec.mqtt.MqttProperties();
            this.copyProperties(properties, props);
        }
        if (this.clientConfig.getProtocolVersion().protocolLevel() >= MqttVersion.MQTT_5.protocolLevel()) {
            io.netty.handler.codec.mqtt.MqttProperties p = props == io.netty.handler.codec.mqtt.MqttProperties.NO_PROPERTIES ? new io.netty.handler.codec.mqtt.MqttProperties() : props;
            topic = this.clientAliases.topicAlias(topic, a -> p.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.TOPIC_ALIAS.value(), a)));
            props = p;
        }
        boolean retransmit = this.publishRetransmit && qos != MqttQoS.AT_MOST_ONCE || qos == MqttQoS.EXACTLY_ONCE;
        MqttPublishVariableHeader variableHeader = new MqttPublishVariableHeader(topic, this.getNewMessageId().messageId(), props);
        MqttPublishMessage message = new MqttPublishMessage(fixedHeader, variableHeader, payload);
        MqttPendingPublish pendingPublish = new MqttPendingPublish(variableHeader.packetId(), (Promise<Void>)future, payload.retain(), message, qos, retransmit);
        this.pendingPublishes.put(pendingPublish.getMessageId(), pendingPublish);
        ChannelFuture channelFuture = this.sendAndFlushPacket(message);
        if (channelFuture != null) {
            pendingPublish.setSent(true);
            if (channelFuture.cause() != null) {
                future.setFailure(channelFuture.cause());
                this.pendingPublishes.remove(pendingPublish.getMessageId());
                payload.release();
                return future;
            }
        }
        if (pendingPublish.isSent() && pendingPublish.getQos() == MqttQoS.AT_MOST_ONCE) {
            pendingPublish.getFuture().setSuccess(null);
            this.pendingPublishes.remove(pendingPublish.getMessageId());
            payload.release();
        } else if (pendingPublish.isSent() && retransmit) {
            pendingPublish.startPublishRetransmissionTimer(this.eventLoop.next(), this::sendAndFlushPacket);
        }
        return future;
    }

    private void copyProperties(MqttProperties properties, io.netty.handler.codec.mqtt.MqttProperties props) {
        if (properties == null) {
            return;
        }
        for (MqttProperty p : properties) {
            MqttProperties.IntegerProperty prop = null;
            Class valueType = p.getType().getValueType();
            if (Integer.class.isAssignableFrom(valueType)) {
                prop = new MqttProperties.IntegerProperty(p.getType().getKey().intValue(), (Integer)p.getValue());
            } else if (String.class.isAssignableFrom(valueType)) {
                prop = new MqttProperties.StringProperty(p.getType().getKey().intValue(), p.getValue().toString());
            } else if (byte[].class.isAssignableFrom(valueType)) {
                prop = new MqttProperties.BinaryProperty(p.getType().getKey().intValue(), (byte[])p.getValue());
            } else if (KeyValuePair.class.isAssignableFrom(valueType)) {
                KeyValuePair kp = (KeyValuePair)p.getValue();
                prop = new MqttProperties.UserProperty(kp.getKey(), kp.getValue());
            }
            if (prop == null) continue;
            props.add((MqttProperties.MqttProperty)prop);
        }
    }

    @Override
    public MqttClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Override
    public Future<?> disconnect() {
        this.disconnected = true;
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (this.channel != null) {
            this.reconnect = false;
            MqttMessage message = new MqttMessage(new MqttFixedHeader(MqttMessageType.DISCONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0));
            this.sendAndFlushPacket(message).addListener(future1 -> this.channel.close().addListener(closeFuture -> {
                if (closeFuture.isSuccess()) {
                    result.complete(null);
                } else {
                    result.completeExceptionally(closeFuture.cause());
                }
            }));
        } else {
            result.complete(null);
        }
        return result;
    }

    @Override
    public boolean isDisconnected() {
        return this.disconnected;
    }

    @Override
    public void setCallback(MqttClientCallback callback) {
        this.callback = callback;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public void onSuccessfulReconnect() {
        if (this.callback != null) {
            this.callback.onSuccessfulReconnect();
        }
    }

    ChannelFuture sendAndFlushPacket(Object message) {
        if (this.channel == null) {
            return null;
        }
        if (this.channel.isActive()) {
            return this.channel.writeAndFlush(message);
        }
        return this.channel.newFailedFuture((Throwable)new ChannelClosedException("Channel is closed!"));
    }

    private MqttMessageIdVariableHeader getNewMessageId() {
        int nextId = this.nextMessageId.accumulateAndGet(1, (c, d) -> c < 65535 ? c + 1 : 1);
        return MqttMessageIdVariableHeader.from((int)nextId);
    }

    private io.netty.util.concurrent.Future<Void> createSubscription(String topic, MqttMessageHandler handler, boolean once, MqttQoS qos) {
        Optional<Map.Entry> subscriptionEntry;
        if (this.pendingSubscribeTopics.contains(topic) && (subscriptionEntry = this.pendingSubscriptions.entrySet().stream().filter(e -> ((MqttPendingSubscription)e.getValue()).getTopic().equals(topic)).findAny()).isPresent()) {
            ((MqttPendingSubscription)subscriptionEntry.get().getValue()).addHandler(handler, once);
            return ((MqttPendingSubscription)subscriptionEntry.get().getValue()).getFuture();
        }
        if (this.serverSubscriptions.contains(topic)) {
            MqttSubscription subscription = new MqttSubscription(topic, handler, once);
            CopyOnWriteArrayList l = (CopyOnWriteArrayList)this.subscriptions.computeIfAbsent((Object)topic, k -> new CopyOnWriteArrayList());
            l.addIfAbsent(subscription);
            l = (CopyOnWriteArrayList)this.handlerToSubscribtion.computeIfAbsent((Object)handler, k -> new CopyOnWriteArrayList());
            l.addIfAbsent(subscription);
            return this.channel.newSucceededFuture();
        }
        DefaultPromise future = new DefaultPromise((EventExecutor)this.eventLoop.next());
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttTopicSubscription subscription = new MqttTopicSubscription(topic, qos);
        MqttMessageIdVariableHeader variableHeader = this.getNewMessageId();
        MqttSubscribePayload payload = new MqttSubscribePayload(Collections.singletonList(subscription));
        MqttSubscribeMessage message = new MqttSubscribeMessage(fixedHeader, variableHeader, payload);
        MqttPendingSubscription pendingSubscription = new MqttPendingSubscription((Promise<Void>)future, topic, message);
        pendingSubscription.addHandler(handler, once);
        this.pendingSubscriptions.put(variableHeader.messageId(), (Object)pendingSubscription);
        this.pendingSubscribeTopics.add(topic);
        pendingSubscription.setSent(this.sendAndFlushPacket(message) != null);
        pendingSubscription.startRetransmitTimer(this.eventLoop.next(), this::sendAndFlushPacket);
        return future;
    }

    private void checkSubscribtions(String topic, Promise<Void> promise) {
        if ((!this.subscriptions.containsKey((Object)topic) || ((List)this.subscriptions.get((Object)topic)).size() == 0) && this.serverSubscriptions.contains(topic)) {
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
            MqttMessageIdVariableHeader variableHeader = this.getNewMessageId();
            MqttUnsubscribePayload payload = new MqttUnsubscribePayload(Collections.singletonList(topic));
            MqttUnsubscribeMessage message = new MqttUnsubscribeMessage(fixedHeader, variableHeader, payload);
            MqttPendingUnsubscription pendingUnsubscription = new MqttPendingUnsubscription(promise, topic, message);
            this.pendingServerUnsubscribes.put(variableHeader.messageId(), (Object)pendingUnsubscription);
            pendingUnsubscription.startRetransmissionTimer(this.eventLoop.next(), this::sendAndFlushPacket);
            this.sendAndFlushPacket(message);
        } else {
            promise.setSuccess(null);
        }
    }

    IntObjectHashMap<MqttPendingSubscription> getPendingSubscriptions() {
        return this.pendingSubscriptions;
    }

    MultiValueMap<String, MqttSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    Set<String> getPendingSubscribeTopics() {
        return this.pendingSubscribeTopics;
    }

    MultiValueMap<MqttMessageHandler, MqttSubscription> getHandlerToSubscribtion() {
        return this.handlerToSubscribtion;
    }

    Set<String> getServerSubscriptions() {
        return this.serverSubscriptions;
    }

    IntObjectHashMap<MqttPendingUnsubscription> getPendingServerUnsubscribes() {
        return this.pendingServerUnsubscribes;
    }

    ConcurrentMap<Integer, MqttPendingPublish> getPendingPublishes() {
        return this.pendingPublishes;
    }

    IntObjectHashMap<MqttIncomingQos2Publish> getQos2PendingIncomingPublishes() {
        return this.qos2PendingIncomingPublishes;
    }

    MqttMessageHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    @Override
    public void setWireLogging(boolean wireLogging) {
        this.wireLogging = wireLogging;
    }

    @Override
    public MqttTopicAliases getTopicAliases() {
        return this.clientAliases;
    }

    public boolean isPublishRetransmit() {
        return this.publishRetransmit;
    }

    public void setPublishRetransmit(boolean publishRetransmit) {
        this.publishRetransmit = publishRetransmit;
    }

    public int getPendingAbortTimeoutMinutes() {
        return this.pendingAbortTimeoutMinutes;
    }

    public void setPendingAbortTimeoutMinutes(int pendingAbortTimeoutMinutes) {
        this.pendingAbortTimeoutMinutes = pendingAbortTimeoutMinutes;
    }

    private class MqttChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final Promise<MqttConnectResult> connectFuture;
        private final String host;
        private final int port;
        private final SslContext sslContext;

        public MqttChannelInitializer(Promise<MqttConnectResult> connectFuture, String host, int port, SslContext sslContext) {
            this.connectFuture = connectFuture;
            this.host = host;
            this.port = port;
            this.sslContext = sslContext;
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            if (this.sslContext != null) {
                ch.pipeline().addLast(new ChannelHandler[]{this.sslContext.newHandler(ch.alloc(), this.host, this.port)});
            }
            if (MqttClientImpl.this.wireLogging) {
                ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler("net.solarnetwork.mqtt." + this.host + ":" + this.port)});
            }
            ch.pipeline().addLast("mqttDecoder", (ChannelHandler)new MqttDecoder(MqttClientImpl.this.clientConfig.getMaxBytesInMessage()));
            ch.pipeline().addLast("mqttEncoder", (ChannelHandler)MqttEncoder.INSTANCE);
            int timeout = MqttClientImpl.this.clientConfig.getTimeoutSeconds();
            int readTimeout = MqttClientImpl.this.clientConfig.getReadTimeoutSeconds();
            int writeTimeout = MqttClientImpl.this.clientConfig.getWriteTimeoutSeconds();
            if (readTimeout != 0 || writeTimeout != 0) {
                ch.pipeline().addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(readTimeout >= 0 ? readTimeout : timeout * 2, writeTimeout >= 0 ? writeTimeout : timeout, 0));
            }
            ch.pipeline().addLast("mqttPingHandler", (ChannelHandler)new MqttPingHandler(timeout, readTimeout != 0));
            ch.pipeline().addLast("mqttHandler", (ChannelHandler)new MqttChannelHandler(MqttClientImpl.this, this.connectFuture));
        }
    }
}

