/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.concurrent.Promise;
import java.util.function.Consumer;
import net.solarnetwork.common.mqtt.netty.client.RetransmissionHandler;

final class MqttPendingPublish {
    private final int messageId;
    private final Promise<Void> future;
    private final ByteBuf payload;
    private final MqttPublishMessage message;
    private final MqttQoS qos;
    private final long date;
    private final RetransmissionHandler<MqttPublishMessage> publishRetransmissionHandler;
    private final RetransmissionHandler<MqttMessage> pubrelRetransmissionHandler;
    private boolean sent = false;

    MqttPendingPublish(int messageId, Promise<Void> future, ByteBuf payload, MqttPublishMessage message, MqttQoS qos, boolean enableRetransmission) {
        this.messageId = messageId;
        this.future = future;
        this.payload = payload;
        this.message = message;
        this.qos = qos;
        if (qos != MqttQoS.AT_MOST_ONCE && enableRetransmission) {
            this.publishRetransmissionHandler = new RetransmissionHandler();
            this.publishRetransmissionHandler.setOriginalMessage(message);
            this.pubrelRetransmissionHandler = qos == MqttQoS.EXACTLY_ONCE ? new RetransmissionHandler() : null;
        } else {
            this.publishRetransmissionHandler = null;
            this.pubrelRetransmissionHandler = null;
        }
        this.date = System.currentTimeMillis();
    }

    int getMessageId() {
        return this.messageId;
    }

    Promise<Void> getFuture() {
        return this.future;
    }

    ByteBuf getPayload() {
        return this.payload;
    }

    boolean isSent() {
        return this.sent;
    }

    void setSent(boolean sent) {
        this.sent = sent;
    }

    MqttPublishMessage getMessage() {
        return this.message;
    }

    MqttQoS getQos() {
        return this.qos;
    }

    long getDate() {
        return this.date;
    }

    void startPublishRetransmissionTimer(EventLoop eventLoop, Consumer<Object> sendPacket) {
        this.publishRetransmissionHandler.setHandler((fixedHeader, originalMessage) -> sendPacket.accept(new MqttPublishMessage(fixedHeader, originalMessage.variableHeader(), this.payload.retain())));
        this.publishRetransmissionHandler.start(eventLoop);
    }

    void onPubackReceived() {
        if (this.publishRetransmissionHandler != null) {
            this.publishRetransmissionHandler.stop();
        }
    }

    void setPubrelMessage(MqttMessage pubrelMessage) {
        this.pubrelRetransmissionHandler.setOriginalMessage(pubrelMessage);
    }

    void startPubrelRetransmissionTimer(EventLoop eventLoop, Consumer<Object> sendPacket) {
        this.pubrelRetransmissionHandler.setHandler((fixedHeader, originalMessage) -> sendPacket.accept(new MqttMessage(fixedHeader, originalMessage.variableHeader())));
        this.pubrelRetransmissionHandler.start(eventLoop);
    }

    void onPubcompReceived() {
        this.pubrelRetransmissionHandler.stop();
    }

    void stop() {
        if (this.publishRetransmissionHandler != null) {
            this.publishRetransmissionHandler.stop();
        }
        if (this.pubrelRetransmissionHandler != null) {
            this.pubrelRetransmissionHandler.stop();
        }
    }
}

