/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty.client;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.util.concurrent.Promise;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.solarnetwork.common.mqtt.MqttMessageHandler;
import net.solarnetwork.common.mqtt.netty.client.RetransmissionHandler;

final class MqttPendingSubscription {
    private final Promise<Void> future;
    private final String topic;
    private final Set<MqttPendingHandler> handlers = new HashSet<MqttPendingHandler>();
    private final MqttSubscribeMessage subscribeMessage;
    private final RetransmissionHandler<MqttSubscribeMessage> retransmissionHandler = new RetransmissionHandler();
    private boolean sent = false;

    MqttPendingSubscription(Promise<Void> future, String topic, MqttSubscribeMessage message) {
        this.future = future;
        this.topic = topic;
        this.subscribeMessage = message;
        this.retransmissionHandler.setOriginalMessage(message);
    }

    Promise<Void> getFuture() {
        return this.future;
    }

    String getTopic() {
        return this.topic;
    }

    boolean isSent() {
        return this.sent;
    }

    void setSent(boolean sent) {
        this.sent = sent;
    }

    MqttSubscribeMessage getSubscribeMessage() {
        return this.subscribeMessage;
    }

    void addHandler(MqttMessageHandler handler, boolean once) {
        this.handlers.add(new MqttPendingHandler(handler, once));
    }

    Set<MqttPendingHandler> getHandlers() {
        return this.handlers;
    }

    void startRetransmitTimer(EventLoop eventLoop, Consumer<Object> sendPacket) {
        if (this.sent) {
            this.retransmissionHandler.setHandler((fixedHeader, originalMessage) -> sendPacket.accept(new MqttSubscribeMessage(fixedHeader, originalMessage.variableHeader(), originalMessage.payload())));
            this.retransmissionHandler.start(eventLoop);
        }
    }

    void onSubackReceived() {
        this.retransmissionHandler.stop();
    }

    final class MqttPendingHandler {
        private final MqttMessageHandler handler;
        private final boolean once;

        MqttPendingHandler(MqttMessageHandler handler, boolean once) {
            this.handler = handler;
            this.once = once;
        }

        MqttMessageHandler getHandler() {
            return this.handler;
        }

        boolean isOnce() {
            return this.once;
        }
    }
}

