/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty.client;

public enum MqttPubackReasonCode {
    Success(0),
    NoSubscribers(16),
    UnspecifiedError(-128),
    ImplementationSpecificError(-125),
    NotAuthorized(-121),
    TopicNameInvalid(-112),
    PacketIdentifierInUse(-111),
    QuotaExceeded(-105),
    PayloadFormatInvalid(-103);

    private final byte code;

    private MqttPubackReasonCode(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static MqttPubackReasonCode forCode(byte code) {
        switch (code) {
            case 0: {
                return Success;
            }
            case 16: {
                return NoSubscribers;
            }
            case -128: {
                return UnspecifiedError;
            }
            case -125: {
                return ImplementationSpecificError;
            }
            case -121: {
                return NotAuthorized;
            }
            case -112: {
                return TopicNameInvalid;
            }
            case -111: {
                return PacketIdentifierInUse;
            }
            case -105: {
                return QuotaExceeded;
            }
            case -103: {
                return PayloadFormatInvalid;
            }
        }
        throw new IllegalArgumentException("Unsupported reason code: " + code);
    }
}

