/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.solarnetwork.common.mqtt.MqttMessageHandler;

final class MqttSubscription {
    public static final Pattern SHARE_SUBSCRIPTION_PREFIX = Pattern.compile("(\\$share/[^/]+/).*", 2);
    private final String topic;
    private final Pattern topicRegex;
    private final MqttMessageHandler handler;
    private final boolean once;
    private boolean called;

    MqttSubscription(String topic, MqttMessageHandler handler, boolean once) {
        if (topic == null) {
            throw new NullPointerException("topic");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.topic = topic;
        this.handler = handler;
        this.once = once;
        Matcher shareMatch = SHARE_SUBSCRIPTION_PREFIX.matcher(topic);
        if (shareMatch.matches()) {
            topic = topic.substring(shareMatch.end(1));
        }
        this.topicRegex = Pattern.compile(topic.replace("+", "[^/]+").replace("#", ".+") + "$");
    }

    String getTopic() {
        return this.topic;
    }

    public MqttMessageHandler getHandler() {
        return this.handler;
    }

    boolean isOnce() {
        return this.once;
    }

    boolean isCalled() {
        return this.called;
    }

    boolean matches(String topic) {
        return this.topicRegex.matcher(topic).matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttSubscription that = (MqttSubscription)o;
        return this.once == that.once && this.topic.equals(that.topic) && this.handler.equals((Object)that.handler);
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.handler.hashCode();
        result = 31 * result + (this.once ? 1 : 0);
        return result;
    }

    void setCalled(boolean called) {
        this.called = called;
    }
}

