/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.common.mqtt.netty.client;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RetransmissionHandler<T extends MqttMessage> {
    private static final Logger log = LoggerFactory.getLogger(RetransmissionHandler.class);
    private ScheduledFuture<?> timer;
    private int timeout = 10;
    private BiConsumer<MqttFixedHeader, T> handler;
    private T originalMessage;

    RetransmissionHandler() {
    }

    void start(EventLoop eventLoop) {
        if (eventLoop == null) {
            throw new NullPointerException("eventLoop");
        }
        if (this.handler == null) {
            throw new NullPointerException("handler");
        }
        this.timeout = 10;
        this.startTimer(eventLoop);
    }

    private void startTimer(EventLoop eventLoop) {
        this.timer = eventLoop.schedule(() -> {
            if (log.isDebugEnabled()) {
                MqttMessageIdVariableHeader idHeader = this.originalMessage.variableHeader() instanceof MqttMessageIdVariableHeader ? (MqttMessageIdVariableHeader)this.originalMessage.variableHeader() : null;
                log.debug("Retransmitting {} message ID {} after timeout of {} seconds", new Object[]{this.originalMessage.fixedHeader().messageType(), idHeader != null ? Integer.valueOf(idHeader.messageId()) : "?", this.timeout});
            }
            this.timeout += 5;
            MqttFixedHeader fixedHeader = new MqttFixedHeader(this.originalMessage.fixedHeader().messageType(), true, this.originalMessage.fixedHeader().qosLevel(), this.originalMessage.fixedHeader().isRetain(), this.originalMessage.fixedHeader().remainingLength());
            this.handler.accept(fixedHeader, (MqttFixedHeader)this.originalMessage);
            this.startTimer(eventLoop);
        }, (long)this.timeout, TimeUnit.SECONDS);
    }

    void stop() {
        if (this.timer != null) {
            this.timer.cancel(true);
        }
    }

    void setHandler(BiConsumer<MqttFixedHeader, T> runnable) {
        this.handler = runnable;
    }

    void setOriginalMessage(T originalMessage) {
        this.originalMessage = originalMessage;
    }
}

