/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.cs;

import java.util.Collections;
import java.util.Set;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.AuthorizationInfo;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.AuthorizationService;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.v16.ActionErrorCode;
import net.solarnetwork.ocpp.v16.CentralSystemAction;
import net.solarnetwork.ocpp.v16.cs.CentralSystemUtils;
import net.solarnetwork.ocpp.xml.support.XmlDateUtils;
import ocpp.v16.cs.AuthorizeRequest;
import ocpp.v16.cs.AuthorizeResponse;
import ocpp.v16.cs.IdTagInfo;

public class AuthorizeProcessor
extends BaseActionMessageProcessor<AuthorizeRequest, AuthorizeResponse> {
    public static final Set<Action> SUPPORTED_ACTIONS = Collections.singleton(CentralSystemAction.Authorize);
    private final AuthorizationService authService;

    public AuthorizeProcessor(AuthorizationService authService) {
        super(AuthorizeRequest.class, AuthorizeResponse.class, SUPPORTED_ACTIONS);
        this.authService = authService;
    }

    public void processActionMessage(ActionMessage<AuthorizeRequest> message, ActionMessageResultHandler<AuthorizeRequest, AuthorizeResponse> resultHandler) {
        AuthorizeRequest req = (AuthorizeRequest)message.getMessage();
        if (req == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormationViolation, "Missing AuthorizeRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        try {
            AuthorizationInfo info = this.authService.authorize(message.getClientId(), req.getIdTag());
            IdTagInfo tagInfo = new IdTagInfo();
            tagInfo.setParentIdTag(info.getParentId());
            tagInfo.setStatus(CentralSystemUtils.statusForStatus(info.getStatus()));
            if (info.getExpiryDate() != null) {
                tagInfo.setExpiryDate(XmlDateUtils.newXmlCalendar(info.getExpiryDate().toEpochMilli()));
            }
            AuthorizeResponse res = new AuthorizeResponse();
            res.setIdTagInfo(tagInfo);
            resultHandler.handleActionMessageResult(message, (Object)res, null);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }
}

