/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.cs;

import java.util.Collections;
import java.util.Set;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.ChargePoint;
import net.solarnetwork.ocpp.domain.ChargePointInfo;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.service.cs.ChargePointManager;
import net.solarnetwork.ocpp.v16.ActionErrorCode;
import net.solarnetwork.ocpp.v16.CentralSystemAction;
import net.solarnetwork.ocpp.xml.support.XmlDateUtils;
import ocpp.v16.cs.BootNotificationRequest;
import ocpp.v16.cs.BootNotificationResponse;
import ocpp.v16.cs.RegistrationStatus;

public class BootNotificationProcessor
extends BaseActionMessageProcessor<BootNotificationRequest, BootNotificationResponse> {
    public static final Set<Action> SUPPORTED_ACTIONS = Collections.singleton(CentralSystemAction.BootNotification);
    public static final int DEFAULT_HEARTBEAT_INTERVAL_SECONDS = 300;
    private final ChargePointManager chargePointManager;
    private int heartbeatIntervalSeconds = 300;

    public BootNotificationProcessor(ChargePointManager chargePointManager) {
        super(BootNotificationRequest.class, BootNotificationResponse.class, SUPPORTED_ACTIONS);
        if (chargePointManager == null) {
            throw new IllegalArgumentException("The chargePointManager parameter must not be null.");
        }
        this.chargePointManager = chargePointManager;
    }

    public void processActionMessage(ActionMessage<BootNotificationRequest> message, ActionMessageResultHandler<BootNotificationRequest, BootNotificationResponse> resultHandler) {
        BootNotificationRequest req = (BootNotificationRequest)message.getMessage();
        if (req == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormationViolation, "Missing BootNotificationRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        ChargePointInfo info = new ChargePointInfo(message.getClientId().getIdentifier());
        info.setChargePointVendor(req.getChargePointVendor());
        info.setChargePointModel(req.getChargePointModel());
        info.setChargePointSerialNumber(req.getChargePointSerialNumber());
        info.setChargeBoxSerialNumber(req.getChargeBoxSerialNumber());
        info.setFirmwareVersion(req.getFirmwareVersion());
        info.setIccid(req.getIccid());
        info.setImsi(req.getImsi());
        info.setMeterType(req.getMeterType());
        info.setMeterSerialNumber(req.getMeterSerialNumber());
        try {
            ChargePoint cp = this.chargePointManager.registerChargePoint(message.getClientId(), info);
            BootNotificationResponse res = new BootNotificationResponse();
            res.setCurrentTime(XmlDateUtils.newXmlCalendar());
            if (cp.getRegistrationStatus() != null) {
                switch (cp.getRegistrationStatus()) {
                    case Accepted: {
                        res.setStatus(RegistrationStatus.ACCEPTED);
                        break;
                    }
                    case Rejected: {
                        res.setStatus(RegistrationStatus.REJECTED);
                        break;
                    }
                    default: {
                        res.setStatus(RegistrationStatus.PENDING);
                        break;
                    }
                }
            } else {
                res.setStatus(RegistrationStatus.PENDING);
            }
            res.setInterval(this.getHeartbeatIntervalSeconds());
            resultHandler.handleActionMessageResult(message, (Object)res, null);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }

    public int getHeartbeatIntervalSeconds() {
        return this.heartbeatIntervalSeconds;
    }

    public void setHeartbeatIntervalSeconds(int heartbeatIntervalSeconds) {
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
    }
}

