/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.cs;

import java.time.Instant;
import java.util.UUID;
import net.solarnetwork.ocpp.domain.Location;
import net.solarnetwork.ocpp.domain.Measurand;
import net.solarnetwork.ocpp.domain.ReadingContext;
import net.solarnetwork.ocpp.domain.SampledValue;
import ocpp.v16.cs.AuthorizationStatus;
import ocpp.v16.cs.Phase;
import ocpp.v16.cs.SampledValue;
import ocpp.v16.cs.UnitOfMeasure;

public final class CentralSystemUtils {
    private CentralSystemUtils() {
    }

    public static AuthorizationStatus statusForStatus(net.solarnetwork.ocpp.domain.AuthorizationStatus status) {
        switch (status) {
            case Accepted: {
                return AuthorizationStatus.ACCEPTED;
            }
            case Blocked: {
                return AuthorizationStatus.BLOCKED;
            }
            case ConcurrentTx: {
                return AuthorizationStatus.CONCURRENT_TX;
            }
            case Expired: {
                return AuthorizationStatus.EXPIRED;
            }
        }
        return AuthorizationStatus.INVALID;
    }

    public static net.solarnetwork.ocpp.domain.SampledValue sampledValue(UUID chargeSessionId, Instant timestamp, SampledValue value) {
        SampledValue.Builder result = net.solarnetwork.ocpp.domain.SampledValue.builder().withSessionId(chargeSessionId).withTimestamp(timestamp).withContext(CentralSystemUtils.readingContext(value.getContext())).withLocation(CentralSystemUtils.location(value.getLocation())).withMeasurand(CentralSystemUtils.measurand(value.getMeasurand())).withPhase(CentralSystemUtils.phase(value.getPhase())).withUnit(CentralSystemUtils.unit(value.getUnit())).withValue(value.getValue());
        return result.build();
    }

    public static net.solarnetwork.ocpp.domain.UnitOfMeasure unit(UnitOfMeasure unit) {
        try {
            return net.solarnetwork.ocpp.domain.UnitOfMeasure.valueOf((String)unit.value());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return net.solarnetwork.ocpp.domain.UnitOfMeasure.Unknown;
        }
    }

    public static net.solarnetwork.ocpp.domain.Phase phase(Phase phase) {
        if (phase == null) {
            return null;
        }
        try {
            return net.solarnetwork.ocpp.domain.Phase.valueOf((String)phase.value().replace("-", ""));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return net.solarnetwork.ocpp.domain.Phase.Unknown;
        }
    }

    public static Measurand measurand(ocpp.v16.cs.Measurand measurand) {
        try {
            return Measurand.valueOf((String)measurand.value().replace(".", ""));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Measurand.Unknown;
        }
    }

    public static Location location(ocpp.v16.cs.Location location) {
        try {
            return Location.valueOf((String)location.value());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Location.Outlet;
        }
    }

    public static ReadingContext readingContext(ocpp.v16.cs.ReadingContext context) {
        try {
            return ReadingContext.valueOf((String)context.value().replace(".", ""));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return ReadingContext.Unknown;
        }
    }
}

