/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.cs;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ChargeSession;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.service.cs.ChargeSessionManager;
import net.solarnetwork.ocpp.v16.ActionErrorCode;
import net.solarnetwork.ocpp.v16.CentralSystemAction;
import net.solarnetwork.ocpp.v16.cs.CentralSystemUtils;
import net.solarnetwork.ocpp.xml.support.XmlDateUtils;
import ocpp.v16.cs.MeterValue;
import ocpp.v16.cs.MeterValuesRequest;
import ocpp.v16.cs.MeterValuesResponse;

public class MeterValuesProcessor
extends BaseActionMessageProcessor<MeterValuesRequest, MeterValuesResponse> {
    public static final Set<Action> SUPPORTED_ACTIONS = Collections.singleton(CentralSystemAction.MeterValues);
    private final ChargeSessionManager chargeSessionManager;

    public MeterValuesProcessor(ChargeSessionManager chargeSessionManager) {
        super(MeterValuesRequest.class, MeterValuesResponse.class, SUPPORTED_ACTIONS);
        if (chargeSessionManager == null) {
            throw new IllegalArgumentException("The chargeSessionManager parameter must not be null.");
        }
        this.chargeSessionManager = chargeSessionManager;
    }

    public void processActionMessage(ActionMessage<MeterValuesRequest> message, ActionMessageResultHandler<MeterValuesRequest, MeterValuesResponse> resultHandler) {
        ChargePointIdentity chargePointId = message.getClientId();
        MeterValuesRequest req = (MeterValuesRequest)message.getMessage();
        if (req == null || chargePointId == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormationViolation, "Missing MeterValuesRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received MeterValues req: {}", (Object)JsonUtils.getJSONString((Object)req, (String)"{}"));
        }
        try {
            ChargeSession session = req.getTransactionId() != null ? this.chargeSessionManager.getActiveChargingSession(chargePointId, req.getTransactionId().toString()) : null;
            List values = req.getMeterValue();
            ArrayList newReadings = new ArrayList();
            if (values != null && !values.isEmpty()) {
                for (MeterValue mv : values) {
                    Instant ts = XmlDateUtils.timestamp(mv.getTimestamp(), Instant::now);
                    mv.getSampledValue().stream().map(v -> CentralSystemUtils.sampledValue(session != null ? (UUID)session.getId() : null, ts, v)).forEach(newReadings::add);
                }
            }
            if (!newReadings.isEmpty()) {
                this.log.debug("Saving charge point {} connector {} readings for session {} (txId {}): {}", new Object[]{chargePointId, req.getConnectorId(), session, req.getTransactionId(), newReadings});
                this.chargeSessionManager.addChargingSessionReadings(chargePointId, null, Integer.valueOf(req.getConnectorId()), newReadings);
            }
            resultHandler.handleActionMessageResult(message, (Object)new MeterValuesResponse(), null);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }
}

