/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.cs;

import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ChargeSession;
import net.solarnetwork.ocpp.domain.ChargeSessionStartInfo;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.AuthorizationException;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.service.cs.ChargeSessionManager;
import net.solarnetwork.ocpp.v16.ActionErrorCode;
import net.solarnetwork.ocpp.v16.CentralSystemAction;
import net.solarnetwork.ocpp.v16.cs.CentralSystemUtils;
import net.solarnetwork.ocpp.xml.support.XmlDateUtils;
import ocpp.v16.cs.AuthorizationStatus;
import ocpp.v16.cs.IdTagInfo;
import ocpp.v16.cs.StartTransactionRequest;
import ocpp.v16.cs.StartTransactionResponse;

public class StartTransactionProcessor
extends BaseActionMessageProcessor<StartTransactionRequest, StartTransactionResponse> {
    public static final Set<Action> SUPPORTED_ACTIONS = Collections.singleton(CentralSystemAction.StartTransaction);
    private final ChargeSessionManager chargeSessionManager;

    public StartTransactionProcessor(ChargeSessionManager chargeSessionManager) {
        super(StartTransactionRequest.class, StartTransactionResponse.class, SUPPORTED_ACTIONS);
        if (chargeSessionManager == null) {
            throw new IllegalArgumentException("The chargeSessionManager parameter must not be null.");
        }
        this.chargeSessionManager = chargeSessionManager;
    }

    public void processActionMessage(ActionMessage<StartTransactionRequest> message, ActionMessageResultHandler<StartTransactionRequest, StartTransactionResponse> resultHandler) {
        ChargePointIdentity chargePointId = message.getClientId();
        StartTransactionRequest req = (StartTransactionRequest)message.getMessage();
        if (req == null || chargePointId == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormationViolation, "Missing StartTransactionRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        ChargeSessionStartInfo info = ChargeSessionStartInfo.builder().withChargePointId(chargePointId).withAuthorizationId(req.getIdTag()).withConnectorId(req.getConnectorId()).withMeterStart((long)req.getMeterStart()).withTimestampStart(XmlDateUtils.timestamp(req.getTimestamp(), Instant::now)).withReservationId(req.getReservationId()).build();
        this.log.info("Received StartTransaction request: {}", (Object)info);
        try {
            ChargeSession session = this.chargeSessionManager.startChargingSession(info);
            IdTagInfo tagInfo = new IdTagInfo();
            tagInfo.setStatus(AuthorizationStatus.ACCEPTED);
            StartTransactionResponse res = new StartTransactionResponse();
            res.setIdTagInfo(tagInfo);
            res.setTransactionId(Integer.parseInt(session.getTransactionId()));
            resultHandler.handleActionMessageResult(message, (Object)res, null);
        }
        catch (AuthorizationException e) {
            IdTagInfo tagInfo = new IdTagInfo();
            tagInfo.setStatus(CentralSystemUtils.statusForStatus(e.getInfo().getStatus()));
            StartTransactionResponse res = new StartTransactionResponse();
            res.setIdTagInfo(tagInfo);
            if (e.getTransactionId() != null) {
                try {
                    res.setTransactionId(Integer.parseInt(e.getTransactionId()));
                }
                catch (NumberFormatException nfe) {
                    res.setTransactionId(0);
                }
            } else {
                res.setTransactionId(0);
            }
            resultHandler.handleActionMessageResult(message, (Object)res, null);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }
}

