/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.cs;

import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.ActionMessage;
import net.solarnetwork.ocpp.domain.ChargePointErrorCode;
import net.solarnetwork.ocpp.domain.ChargePointIdentity;
import net.solarnetwork.ocpp.domain.ChargePointStatus;
import net.solarnetwork.ocpp.domain.ErrorCode;
import net.solarnetwork.ocpp.domain.ErrorCodeException;
import net.solarnetwork.ocpp.domain.StatusNotification;
import net.solarnetwork.ocpp.service.ActionMessageResultHandler;
import net.solarnetwork.ocpp.service.BaseActionMessageProcessor;
import net.solarnetwork.ocpp.service.cs.ChargePointManager;
import net.solarnetwork.ocpp.v16.ActionErrorCode;
import net.solarnetwork.ocpp.v16.CentralSystemAction;
import net.solarnetwork.ocpp.xml.support.XmlDateUtils;
import net.solarnetwork.security.SecurityException;
import ocpp.v16.cs.StatusNotificationRequest;
import ocpp.v16.cs.StatusNotificationResponse;

public class StatusNotificationProcessor
extends BaseActionMessageProcessor<StatusNotificationRequest, StatusNotificationResponse> {
    public static final Set<Action> SUPPORTED_ACTIONS = Collections.singleton(CentralSystemAction.StatusNotification);
    private final ChargePointManager chargePointManager;

    public StatusNotificationProcessor(ChargePointManager chargePointManager) {
        super(StatusNotificationRequest.class, StatusNotificationResponse.class, SUPPORTED_ACTIONS);
        if (chargePointManager == null) {
            throw new IllegalArgumentException("The chargePointManager parameter must not be null.");
        }
        this.chargePointManager = chargePointManager;
    }

    public void processActionMessage(ActionMessage<StatusNotificationRequest> message, ActionMessageResultHandler<StatusNotificationRequest, StatusNotificationResponse> resultHandler) {
        ChargePointIdentity identity = message.getClientId();
        StatusNotificationRequest req = (StatusNotificationRequest)message.getMessage();
        if (req == null || identity == null) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.FormationViolation, "Missing StatusNotificationRequest message.");
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
            return;
        }
        StatusNotification info = StatusNotification.builder().withConnectorId(req.getConnectorId()).withStatus(this.statusValue(req)).withErrorCode(this.errorCode(req)).withTimestamp(XmlDateUtils.timestamp(req.getTimestamp(), Instant::now)).withInfo(req.getInfo()).withVendorId(req.getVendorId()).withVendorErrorCode(req.getVendorErrorCode()).build();
        try {
            this.chargePointManager.updateChargePointStatus(identity, info);
            resultHandler.handleActionMessageResult(message, (Object)new StatusNotificationResponse(), null);
        }
        catch (SecurityException e) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.SecurityError, e.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
        catch (Throwable t) {
            ErrorCodeException err = new ErrorCodeException((ErrorCode)ActionErrorCode.InternalError, "Internal error: " + t.getMessage());
            resultHandler.handleActionMessageResult(message, null, (Throwable)err);
        }
    }

    private ChargePointStatus statusValue(StatusNotificationRequest req) {
        if (req != null && req.getStatus() != null) {
            try {
                return ChargePointStatus.valueOf((String)req.getStatus().value());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ChargePointStatus.Unknown;
    }

    private ChargePointErrorCode errorCode(StatusNotificationRequest req) {
        if (req != null && req.getStatus() != null && req.getErrorCode() != null) {
            try {
                return ChargePointErrorCode.valueOf((String)req.getErrorCode().value());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ChargePointErrorCode.Unknown;
    }
}

