/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.v16.cs.json;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.xml.bind.JAXBElement;
import net.solarnetwork.ocpp.domain.Action;
import net.solarnetwork.ocpp.domain.SchemaValidationException;
import net.solarnetwork.ocpp.v16.CentralSystemAction;
import net.solarnetwork.ocpp.v16.json.BaseActionPayloadDecoder;
import ocpp.v16.cs.AuthorizeRequest;
import ocpp.v16.cs.AuthorizeResponse;
import ocpp.v16.cs.BootNotificationRequest;
import ocpp.v16.cs.BootNotificationResponse;
import ocpp.v16.cs.CentralSystemService;
import ocpp.v16.cs.DataTransferRequest;
import ocpp.v16.cs.DataTransferResponse;
import ocpp.v16.cs.DiagnosticsStatusNotificationRequest;
import ocpp.v16.cs.DiagnosticsStatusNotificationResponse;
import ocpp.v16.cs.FirmwareStatusNotificationRequest;
import ocpp.v16.cs.FirmwareStatusNotificationResponse;
import ocpp.v16.cs.HeartbeatRequest;
import ocpp.v16.cs.HeartbeatResponse;
import ocpp.v16.cs.MeterValuesRequest;
import ocpp.v16.cs.MeterValuesResponse;
import ocpp.v16.cs.ObjectFactory;
import ocpp.v16.cs.StartTransactionRequest;
import ocpp.v16.cs.StartTransactionResponse;
import ocpp.v16.cs.StatusNotificationRequest;
import ocpp.v16.cs.StatusNotificationResponse;
import ocpp.v16.cs.StopTransactionRequest;
import ocpp.v16.cs.StopTransactionResponse;

public class CentralServiceActionPayloadDecoder
extends BaseActionPayloadDecoder {
    protected final ObjectFactory jaxbObjectFactory = new ObjectFactory();

    public CentralServiceActionPayloadDecoder() {
        this(CentralServiceActionPayloadDecoder.defaultObjectMapper());
    }

    public CentralServiceActionPayloadDecoder(ObjectMapper mapper) {
        super(mapper, ObjectFactory.class, "ocpp/v16/cs/OCPP_CentralSystemService_1.6.wsdl", CentralSystemService.class.getClassLoader());
    }

    public <T> T decodeActionPayload(Action action, boolean forResult, JsonNode payload) throws IOException {
        Object result;
        if (payload.isNull() || payload.isObject() && payload.isEmpty()) {
            return null;
        }
        CentralSystemAction a = action instanceof CentralSystemAction ? (CentralSystemAction)action : CentralSystemAction.valueOf(action.getName());
        Class<T> clazz = this.messageClassForAction(a, forResult);
        try {
            result = this.mapper.treeToValue((TreeNode)payload, clazz);
        }
        catch (JsonMappingException e) {
            throw new SchemaValidationException((Object)payload, e.getMessage(), (Throwable)e);
        }
        this.validateActionMessage(a, forResult, result);
        return (T)result;
    }

    private <T> Class<T> messageClassForAction(CentralSystemAction action, boolean forResult) {
        Class clazz = null;
        switch (action) {
            case Authorize: {
                clazz = forResult ? AuthorizeResponse.class : AuthorizeRequest.class;
                break;
            }
            case BootNotification: {
                clazz = forResult ? BootNotificationResponse.class : BootNotificationRequest.class;
                break;
            }
            case DataTransfer: {
                clazz = forResult ? DataTransferResponse.class : DataTransferRequest.class;
                break;
            }
            case DiagnosticsStatusNotification: {
                clazz = forResult ? DiagnosticsStatusNotificationResponse.class : DiagnosticsStatusNotificationRequest.class;
                break;
            }
            case FirmwareStatusNotification: {
                clazz = forResult ? FirmwareStatusNotificationResponse.class : FirmwareStatusNotificationRequest.class;
                break;
            }
            case Heartbeat: {
                clazz = forResult ? HeartbeatResponse.class : HeartbeatRequest.class;
                break;
            }
            case MeterValues: {
                clazz = forResult ? MeterValuesResponse.class : MeterValuesRequest.class;
                break;
            }
            case StartTransaction: {
                clazz = forResult ? StartTransactionResponse.class : StartTransactionRequest.class;
                break;
            }
            case StatusNotification: {
                clazz = forResult ? StatusNotificationResponse.class : StatusNotificationRequest.class;
                break;
            }
            case StopTransaction: {
                clazz = forResult ? StopTransactionResponse.class : StopTransactionRequest.class;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action " + action.getName() + " not supported.");
            }
        }
        return clazz;
    }

    private <T> void validateActionMessage(CentralSystemAction action, boolean forResult, T obj) {
        JAXBElement el = null;
        switch (action) {
            case Authorize: {
                el = forResult ? this.jaxbObjectFactory.createAuthorizeResponse((AuthorizeResponse)obj) : this.jaxbObjectFactory.createAuthorizeRequest((AuthorizeRequest)obj);
                break;
            }
            case BootNotification: {
                el = forResult ? this.jaxbObjectFactory.createBootNotificationResponse((BootNotificationResponse)obj) : this.jaxbObjectFactory.createBootNotificationRequest((BootNotificationRequest)obj);
                break;
            }
            case DataTransfer: {
                el = forResult ? this.jaxbObjectFactory.createDataTransferResponse((DataTransferResponse)obj) : this.jaxbObjectFactory.createDataTransferRequest((DataTransferRequest)obj);
                break;
            }
            case DiagnosticsStatusNotification: {
                el = forResult ? this.jaxbObjectFactory.createDiagnosticsStatusNotificationResponse((DiagnosticsStatusNotificationResponse)obj) : this.jaxbObjectFactory.createDiagnosticsStatusNotificationRequest((DiagnosticsStatusNotificationRequest)obj);
                break;
            }
            case FirmwareStatusNotification: {
                el = forResult ? this.jaxbObjectFactory.createFirmwareStatusNotificationResponse((FirmwareStatusNotificationResponse)obj) : this.jaxbObjectFactory.createFirmwareStatusNotificationRequest((FirmwareStatusNotificationRequest)obj);
                break;
            }
            case Heartbeat: {
                el = forResult ? this.jaxbObjectFactory.createHeartbeatResponse((HeartbeatResponse)obj) : this.jaxbObjectFactory.createHeartbeatRequest((HeartbeatRequest)obj);
                break;
            }
            case MeterValues: {
                el = forResult ? this.jaxbObjectFactory.createMeterValuesResponse((MeterValuesResponse)obj) : this.jaxbObjectFactory.createMeterValuesRequest((MeterValuesRequest)obj);
                break;
            }
            case StartTransaction: {
                el = forResult ? this.jaxbObjectFactory.createStartTransactionResponse((StartTransactionResponse)obj) : this.jaxbObjectFactory.createStartTransactionRequest((StartTransactionRequest)obj);
                break;
            }
            case StatusNotification: {
                el = forResult ? this.jaxbObjectFactory.createStatusNotificationResponse((StatusNotificationResponse)obj) : this.jaxbObjectFactory.createStatusNotificationRequest((StatusNotificationRequest)obj);
                break;
            }
            case StopTransaction: {
                el = forResult ? this.jaxbObjectFactory.createStopTransactionResponse((StopTransactionResponse)obj) : this.jaxbObjectFactory.createStopTransactionRequest((StopTransactionRequest)obj);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action " + action.getName() + " not supported.");
            }
        }
        if (el != null) {
            this.schemaHelper.validate(this.jaxbContext, el);
        }
    }
}

