/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.xml.support;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.Text;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import net.solarnetwork.ocpp.xml.support.WSAddressingFromHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMACHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String SN_WS_NS = "urn://SolarNetwork/SolarNode/WS";
    public static final QName SN_WS_AUTH = new QName("urn://SolarNetwork/SolarNode/WS", "Authentication");
    public static final String SN_WS_TIMESTAMP = "ts";
    public static final QName OCPP_CS_CHARGE_BOX_IDENTITY = new QName("urn://Ocpp/Cs/2012/06/", "chargeBoxIdentity");
    public static final QName OCPP_CP_CHARGE_BOX_IDENTITY = new QName("urn://Ocpp/Cp/2012/06/", "chargeBoxIdentity");
    public static final String DEFAULT_SECRET = "changeit";
    private static final Pattern NON_WHITESPACE = Pattern.compile("\\S");
    private String secret = "changeit";
    private boolean required = true;
    private Mac hmac;
    private long maximumTimeSkew = 300000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean handleMessage(SOAPMessageContext context) {
        Boolean outboundProperty = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty != null && outboundProperty.booleanValue()) {
            try {
                this.addAuthenticationHeader(context);
            }
            catch (SOAPException e) {
                this.log.error("Error adding Authentication SOAP header", (Throwable)e);
            }
        } else {
            try {
                this.validateAuthenticationHeader(context);
            }
            catch (SOAPException e) {
                this.log.error("Error validating Authentication SOAP header", (Throwable)e);
            }
        }
        return true;
    }

    private Mac getHMAC() {
        Mac m = this.hmac;
        if (m == null) {
            try {
                m = Mac.getInstance("HmacSHA256");
                SecretKeySpec key = new SecretKeySpec(this.secret.getBytes(), "HmacSHA256");
                m.init(key);
                this.hmac = m;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
        }
        return m;
    }

    private DateFormat getTimestampDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    private String getTimestampString(long time) {
        DateFormat sdf = this.getTimestampDateFormat();
        return sdf.format(new Date(time));
    }

    private void addAuthenticationHeader(SOAPMessageContext context) throws SOAPException {
        this.addAuthenticationHeader(context, System.currentTimeMillis());
    }

    private void addAuthenticationHeader(SOAPMessageContext context, long date) throws SOAPException {
        SOAPMessage msg = context.getMessage();
        SOAPHeader head = msg.getSOAPHeader();
        SOAPElement auth = this.getAuthenticationHeader(head);
        String hashData = this.calculateHashData(context, date);
        String hash = this.hash(hashData);
        if (auth == null) {
            auth = head.addHeaderElement(SN_WS_AUTH);
        }
        auth.setTextContent(hash);
        if (!auth.hasAttribute(SN_WS_TIMESTAMP)) {
            auth.setAttribute(SN_WS_TIMESTAMP, this.getTimestampString(date));
        }
    }

    private String calculateHashData(SOAPMessageContext context, long date) throws SOAPException {
        SOAPMessage msg = context.getMessage();
        SOAPHeader head = msg.getSOAPHeader();
        SOAPBody body = msg.getSOAPBody();
        StringBuilder buf = new StringBuilder("\n");
        String ts = this.getTimestampString(date);
        buf.append(ts).append('\n');
        String cbIdent = null;
        Iterator itr = head.examineAllHeaderElements();
        while (itr.hasNext()) {
            SOAPHeaderElement header = (SOAPHeaderElement)itr.next();
            QName headerName = header.getElementQName();
            String hashKey = headerName.toString();
            String hashValue = "";
            if ("http://www.w3.org/2005/08/addressing".equals(headerName.getNamespaceURI())) {
                Node addr = null;
                Iterator children = header.getChildElements(WSAddressingFromHandler.WSA_ADDRESS);
                if (children.hasNext()) {
                    addr = (Node)children.next();
                }
                if (addr != null) {
                    addr.normalize();
                    hashValue = addr.getTextContent();
                } else {
                    header.normalize();
                    hashValue = header.getTextContent();
                }
            } else {
                if (SN_WS_AUTH.equals(headerName)) continue;
                header.normalize();
                hashValue = header.getTextContent();
            }
            if (cbIdent == null && (OCPP_CS_CHARGE_BOX_IDENTITY.equals(headerName) || OCPP_CP_CHARGE_BOX_IDENTITY.equals(headerName))) {
                cbIdent = hashValue;
            }
            buf.append(hashKey).append('=').append(hashValue).append('\n');
        }
        this.appendHashData((SOAPElement)body, buf);
        if (cbIdent != null) {
            buf.insert(0, cbIdent);
        }
        return buf.toString();
    }

    private SOAPElement getAuthenticationHeader(SOAPHeader head) throws SOAPException {
        SOAPElement auth = null;
        Iterator itr = head.getChildElements(SN_WS_AUTH);
        if (itr.hasNext()) {
            auth = (SOAPElement)itr.next();
        }
        return auth;
    }

    private void validateAuthenticationHeader(SOAPMessageContext context) throws SOAPException {
        String presentedHash;
        SOAPMessage msg = context.getMessage();
        SOAPHeader head = msg.getSOAPHeader();
        SOAPElement auth = this.getAuthenticationHeader(head);
        if (auth == null) {
            return;
        }
        Date timestamp = null;
        try {
            timestamp = (Date)this.getTimestampDateFormat().parseObject(auth.getAttribute(SN_WS_TIMESTAMP));
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date: " + e.getMessage());
        }
        long skew = Math.abs(timestamp.getTime() - System.currentTimeMillis());
        if (skew > this.maximumTimeSkew) {
            throw new RuntimeException("Time skew too big: " + skew);
        }
        String calculatedHashData = this.calculateHashData(context, timestamp.getTime());
        String calculatedHash = this.hash(calculatedHashData);
        if (!calculatedHash.equals(presentedHash = auth.getTextContent())) {
            throw new RuntimeException("Invalid Authentication value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hash(String data) {
        byte[] hash;
        Mac mac;
        this.log.debug("HMAC hash input:\n{}", (Object)data);
        Mac mac2 = mac = this.getHMAC();
        synchronized (mac2) {
            mac.reset();
            hash = mac.doFinal(data.getBytes());
        }
        return Base64.getEncoder().encodeToString(hash);
    }

    private void appendHashData(SOAPElement root, StringBuilder buf) {
        QName name = root.getElementQName();
        boolean first = true;
        Iterator itr = root.getChildElements();
        while (itr.hasNext()) {
            Text t;
            Object o = itr.next();
            if (o instanceof SOAPElement) {
                if (first) {
                    buf.append(name.toString()).append('\n');
                    first = false;
                }
                this.appendHashData((SOAPElement)o, buf);
                continue;
            }
            if (!(o instanceof Text) || (t = (Text)o).isComment()) continue;
            t.normalize();
            if (!NON_WHITESPACE.matcher(t.getTextContent()).find()) continue;
            buf.append(name.toString()).append('=').append(t.getTextContent()).append('\n');
        }
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return Collections.singleton(SN_WS_AUTH);
    }

    public void setSecret(String secret) {
        if (secret == null) {
            secret = "";
        }
        this.secret = secret;
        this.hmac = null;
    }

    public void setMaximumTimeSkew(long maximumTimeSkew) {
        this.maximumTimeSkew = maximumTimeSkew;
    }

    public long getMaximumTimeSkew() {
        return this.maximumTimeSkew;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

