/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.xml.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.solarnetwork.ocpp.domain.SchemaValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaValidationHelper {
    private final Schema schema;

    public static Schema schemaFromWsdl(String wsdlResource, ClassLoader classLoader) {
        DOMImplementationRegistry registry;
        Document wsdlDoc;
        DocumentBuilder dBuilder;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            dBuilder = dbFactory.newDocumentBuilder();
            wsdlDoc = dBuilder.parse(classLoader.getResourceAsStream(wsdlResource));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Error parsing WSDL resource [" + wsdlResource + "]: " + e.toString(), e);
        }
        NamedNodeMap attributes = wsdlDoc.getDocumentElement().getAttributes();
        HashMap<String, String> namespacesFromWsdlDocument = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            if (n.getNamespaceURI() == null || !n.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            namespacesFromWsdlDocument.put(n.getLocalName(), n.getNodeValue());
        }
        NodeList schemas = wsdlDoc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
        final HashMap<String, DOMSource> sources = new HashMap<String, DOMSource>();
        for (int i = 0; i < schemas.getLength(); ++i) {
            Document schema = dBuilder.newDocument();
            Element schemaElement = (Element)schema.importNode(schemas.item(i), true);
            String targetNs = schemaElement.getAttribute("targetNamespace");
            for (Map.Entry ns : namespacesFromWsdlDocument.entrySet()) {
                String name = (String)ns.getKey();
                String value = (String)ns.getValue();
                if (schemaElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", name) != null) continue;
                schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + name, value);
            }
            schema.appendChild(schemaElement);
            DOMSource domSource = new DOMSource(schema);
            sources.put(targetNs, domSource);
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error creating DOM registry when extracting schema from WSDL resource [" + wsdlResource + "]: " + e.toString(), e);
        }
        final DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        factory.setResourceResolver(new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                Source xmlSource = (Source)sources.get(namespaceURI);
                if (xmlSource != null) {
                    LSInput input = domImplementationLS.createLSInput();
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    StreamResult outputTarget = new StreamResult(outputStream);
                    try {
                        TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
                    input.setByteStream(is);
                    input.setSystemId(systemId);
                    return input;
                }
                return null;
            }
        });
        try {
            return factory.newSchema(sources.values().toArray(new DOMSource[sources.size()]));
        }
        catch (SAXException e) {
            throw new RuntimeException("Error parsing schema from WSDL resource [" + wsdlResource + "]: " + e.toString(), e);
        }
    }

    public SchemaValidationHelper(String schemaResource, ClassLoader classLoader) {
        if (schemaResource == null || schemaResource.isEmpty()) {
            throw new IllegalArgumentException("The schemaResource parameter must not be null.");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("The classLoader parameter must not be null.");
        }
        SchemaFactory f = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = f.newSchema(new StreamSource(classLoader.getResourceAsStream(schemaResource)));
        }
        catch (SAXException e) {
            throw new RuntimeException("Error parsing XML schema " + schemaResource + ": " + e.getMessage(), e);
        }
    }

    public SchemaValidationHelper(Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("The schema parameter must not be null.");
        }
        this.schema = schema;
    }

    public void validate(JAXBContext jaxbContext, Object object) {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setSchema(this.schema);
            marshaller.marshal(object, (ContentHandler)new DefaultHandler());
        }
        catch (MarshalException e) {
            Throwable root = e;
            while (root.getCause() != null) {
                root = root.getCause();
            }
            throw new SchemaValidationException(object, root.getMessage(), root);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

