/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.ocpp.xml.support;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSAddressingFromHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String WSA_NS = "http://www.w3.org/2005/08/addressing";
    public static final QName WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From");
    public static final QName WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");
    private String dynamicFromPath = "/ocpp/v15";
    private String networkInterfaceName;
    private String fromURL;
    private boolean preferIPv4Address = Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack", "true"));
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean handleMessage(SOAPMessageContext context) {
        String fromAddressValue;
        Boolean outboundProperty = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty != null && outboundProperty.booleanValue() && (fromAddressValue = this.resolveFromURL()) != null) {
            try {
                SOAPHeader header = context.getMessage().getSOAPHeader();
                SOAPHeaderElement from = null;
                Node fromAddr = null;
                Iterator itr = header.getChildElements(WSA_FROM);
                while (itr.hasNext()) {
                    Node n = (Node)itr.next();
                    if (!(n instanceof SOAPElement)) continue;
                    from = (SOAPElement)n;
                    break;
                }
                if (from == null) {
                    from = header.addHeaderElement(WSA_FROM);
                }
                if ((itr = from.getChildElements(WSA_ADDRESS)).hasNext()) {
                    fromAddr = (Node)itr.next();
                }
                if (fromAddr == null) {
                    fromAddr = from.addChildElement(WSA_ADDRESS);
                }
                fromAddr.setTextContent(fromAddressValue);
            }
            catch (SOAPException e) {
                this.log.error("Exception generating WS-Addressing From header to {}", (Object)fromAddressValue, (Object)e);
            }
        }
        return true;
    }

    private String resolveFromURL() {
        String fromPath = this.dynamicFromPath;
        if (fromPath != null) {
            InetAddress addr = this.getHostInetAddress();
            if (addr != null) {
                return "http://" + addr.getHostAddress() + fromPath;
            }
            return null;
        }
        return this.fromURL;
    }

    private InetAddress getHostInetAddress() {
        String nicName = this.networkInterfaceName;
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                if (nicName != null && !nicName.equalsIgnoreCase(nic.getName())) continue;
                Enumeration<InetAddress> addrs = nic.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress inet = addrs.nextElement();
                    if (this.preferIPv4Address && inet instanceof Inet6Address || inet.isAnyLocalAddress() || inet.isLinkLocalAddress() || inet.isLoopbackAddress() || inet.isMulticastAddress()) continue;
                    return inet;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return Collections.singleton(new QName(WSA_NS, "From"));
    }

    public String getFromURL() {
        return this.fromURL;
    }

    public void setFromURL(String url) {
        this.fromURL = url;
    }

    public String getDynamicFromPath() {
        return this.dynamicFromPath;
    }

    public void setDynamicFromPath(String dynamicFromPath) {
        this.dynamicFromPath = dynamicFromPath;
    }

    public String getNetworkInterfaceName() {
        return this.networkInterfaceName;
    }

    public void setNetworkInterfaceName(String networkInterfaceName) {
        this.networkInterfaceName = networkInterfaceName;
    }

    public boolean isPreferIPv4Address() {
        return this.preferIPv4Address;
    }

    public void setPreferIPv4Address(boolean preferIPv4Address) {
        this.preferIPv4Address = preferIPv4Address;
    }
}

