/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.tcp;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;

public class SimpleTransactionIdSupplier
implements IntSupplier {
    public static final SimpleTransactionIdSupplier INSTANCE = new SimpleTransactionIdSupplier();
    private static final AtomicInteger COUNTER = new AtomicInteger(1);

    @Override
    public int getAsInt() {
        int next;
        int result;
        while (!COUNTER.compareAndSet(result, next = (result = COUNTER.get()) < 65535 ? result + 1 : 1)) {
        }
        return result;
    }

    public int nextId() {
        return COUNTER.get();
    }

    public void reset() {
        COUNTER.set(1);
    }

    public void set(int value) {
        COUNTER.set(value);
    }
}

