/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.tcp.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import net.solarnetwork.io.modbus.AddressedModbusMessage;
import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.netty.msg.ModbusMessageUtils;
import net.solarnetwork.io.modbus.netty.msg.SimpleModbusMessageReply;
import net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage;

public class TcpModbusMessageDecoder
extends ReplayingDecoder<DecoderState> {
    public static final int FIXED_HEADER_LENGTH = 7;
    private final boolean controller;
    private final ConcurrentMap<Integer, TcpModbusMessage> pendingMessages;
    private int transactionId;
    private short unitId;

    public TcpModbusMessageDecoder(boolean controller, ConcurrentMap<Integer, TcpModbusMessage> pendingMessages) {
        super((Object)DecoderState.READ_FIXED_HEADER);
        this.controller = controller;
        if (pendingMessages == null) {
            throw new IllegalArgumentException("The pendingMessages argument must not be null.");
        }
        this.pendingMessages = pendingMessages;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((DecoderState)((Object)this.state())) {
            case READ_FIXED_HEADER: {
                this.readFixedHeader(ctx, in);
                break;
            }
            case READ_PAYLOAD: {
                this.readPayload(ctx, in, out);
            }
        }
    }

    private void readFixedHeader(ChannelHandlerContext ctx, ByteBuf in) {
        this.transactionId = in.readUnsignedShort();
        in.skipBytes(4);
        this.unitId = in.readUnsignedByte();
        this.checkpoint((Object)DecoderState.READ_PAYLOAD);
    }

    private void readPayload(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        TcpModbusMessage msg = null;
        if (this.controller) {
            TcpModbusMessage req = (TcpModbusMessage)this.pendingMessages.get(this.transactionId);
            AddressedModbusMessage addr = req != null ? req.unwrap(AddressedModbusMessage.class) : null;
            ModbusMessage payload = ModbusMessageUtils.decodeResponsePayload((int)this.unitId, (int)(addr != null ? addr.getAddress() : 0), (int)(addr != null ? addr.getCount() : 0), (ByteBuf)in);
            if (payload != null) {
                if (req != null) {
                    this.pendingMessages.remove(this.transactionId, req);
                    msg = new SimpleModbusMessageReply(req.unwrap(ModbusMessage.class), payload);
                } else {
                    msg = new TcpModbusMessage(this.transactionId, payload);
                }
            }
        } else {
            ModbusMessage payload = ModbusMessageUtils.decodeRequestPayload((int)this.unitId, (int)0, (int)0, (ByteBuf)in);
            if (payload != null) {
                TcpModbusMessage req = new TcpModbusMessage(System.currentTimeMillis(), this.transactionId, payload);
                this.pendingMessages.put(this.transactionId, req);
                msg = req;
            }
        }
        if (msg != null) {
            out.add(msg);
        }
        this.checkpoint((Object)DecoderState.READ_FIXED_HEADER);
    }

    static enum DecoderState {
        READ_FIXED_HEADER,
        READ_PAYLOAD;

    }
}

