/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.tcp.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntSupplier;
import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.ModbusMessageReply;
import net.solarnetwork.io.modbus.tcp.SimpleTransactionIdSupplier;
import net.solarnetwork.io.modbus.tcp.TcpModbusMessage;

public class TcpModbusMessageEncoder
extends MessageToMessageEncoder<ModbusMessage> {
    private final ConcurrentMap<Integer, net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage> pendingMessages;
    private final IntSupplier transactionIdSupplier;

    public TcpModbusMessageEncoder(ConcurrentMap<Integer, net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage> pendingMessages) {
        this(pendingMessages, SimpleTransactionIdSupplier.INSTANCE);
    }

    public TcpModbusMessageEncoder(ConcurrentMap<Integer, net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage> pendingMessages, IntSupplier transactionIdSupplier) {
        if (pendingMessages == null) {
            throw new IllegalArgumentException("The pendingMessages argument must not be null.");
        }
        this.pendingMessages = pendingMessages;
        if (transactionIdSupplier == null) {
            throw new IllegalArgumentException("The transactionIdSupplier argument must not be null.");
        }
        this.transactionIdSupplier = transactionIdSupplier;
    }

    protected void encode(ChannelHandlerContext ctx, ModbusMessage msg, List<Object> out) throws Exception {
        net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage tcp;
        if (msg instanceof net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage) {
            tcp = (net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage)msg;
        } else if (msg instanceof ModbusMessageReply) {
            ModbusMessageReply reply = (ModbusMessageReply)msg;
            ModbusMessage req = reply.getRequest();
            if (req instanceof TcpModbusMessage) {
                TcpModbusMessage tcpReq = (TcpModbusMessage)req;
                tcp = new net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage(tcpReq.getTransactionId(), (ModbusMessage)reply);
            } else {
                tcp = new net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage(this.transactionIdSupplier.getAsInt(), msg);
            }
        } else {
            int transactionId = this.transactionIdSupplier.getAsInt();
            tcp = new net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage(transactionId, msg);
            this.pendingMessages.put(transactionId, tcp);
        }
        int len = tcp.payloadLength();
        ByteBuf buf = ctx.alloc().buffer(len);
        tcp.encodeModbusPayload(buf);
        out.add(buf);
    }
}

