/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.tcp.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.IntSupplier;
import net.solarnetwork.io.modbus.ModbusClientConfig;
import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.netty.handler.NettyModbusClient;
import net.solarnetwork.io.modbus.tcp.SimpleTransactionIdSupplier;
import net.solarnetwork.io.modbus.tcp.TcpModbusClientConfig;
import net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessage;
import net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessageDecoder;
import net.solarnetwork.io.modbus.tcp.netty.TcpModbusMessageEncoder;

public class TcpNettyModbusClient
extends NettyModbusClient<TcpModbusClientConfig> {
    private final EventLoopGroup eventLoopGroup;
    private final boolean privateEventLoopGroup;
    private final Class<? extends Channel> channelClass;
    private final ConcurrentMap<Integer, TcpModbusMessage> pendingMessages;
    private final IntSupplier transactionIdSupplier;

    public TcpNettyModbusClient(TcpModbusClientConfig clientConfig) {
        this(clientConfig, null, new ConcurrentHashMap<ModbusMessage, NettyModbusClient.PendingMessage>(8, 0.9f, 2), null, NioSocketChannel.class, new ConcurrentHashMap<Integer, TcpModbusMessage>(8, 0.9f, 2), SimpleTransactionIdSupplier.INSTANCE);
    }

    public TcpNettyModbusClient(TcpModbusClientConfig clientConfig, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) {
        this(clientConfig, null, new ConcurrentHashMap<ModbusMessage, NettyModbusClient.PendingMessage>(8, 0.9f, 2), eventLoopGroup, channelClass, new ConcurrentHashMap<Integer, TcpModbusMessage>(8, 0.9f, 2), SimpleTransactionIdSupplier.INSTANCE);
    }

    public TcpNettyModbusClient(TcpModbusClientConfig clientConfig, ConcurrentMap<ModbusMessage, NettyModbusClient.PendingMessage> pending, ConcurrentMap<Integer, TcpModbusMessage> pendingMessages, IntSupplier transactionIdSupplier) {
        this(clientConfig, null, pending, null, null, pendingMessages, transactionIdSupplier);
    }

    public TcpNettyModbusClient(TcpModbusClientConfig clientConfig, ScheduledExecutorService scheduler, ConcurrentMap<ModbusMessage, NettyModbusClient.PendingMessage> pending, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass, ConcurrentMap<Integer, TcpModbusMessage> pendingMessages, IntSupplier transactionIdSupplier) {
        super((ModbusClientConfig)clientConfig, scheduler, pending);
        if (eventLoopGroup == null) {
            eventLoopGroup = new NioEventLoopGroup();
            this.privateEventLoopGroup = true;
        } else {
            this.privateEventLoopGroup = false;
        }
        this.eventLoopGroup = eventLoopGroup;
        Class<Object> clazz = this.channelClass = channelClass != null ? channelClass : NioSocketChannel.class;
        if (pendingMessages == null) {
            throw new IllegalArgumentException("The pendingMessages argument must not be null.");
        }
        this.pendingMessages = pendingMessages;
        if (transactionIdSupplier == null) {
            throw new IllegalArgumentException("The transactionIdSupplier argument must not be null.");
        }
        this.transactionIdSupplier = transactionIdSupplier;
    }

    protected synchronized ChannelFuture connect() throws IOException {
        String host = ((TcpModbusClientConfig)this.clientConfig).getHost();
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("No host configured, cannot connect.");
        }
        if (this.eventLoopGroup.isShutdown()) {
            throw new IOException("Client is stopped.");
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(this.channelClass)).remoteAddress(host, ((TcpModbusClientConfig)this.clientConfig).getPort()).handler((ChannelHandler)new HandlerInitializer());
        return bootstrap.connect();
    }

    public synchronized void stop() {
        super.stop();
        if (this.privateEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("modbusMessageEncoder", (ChannelHandler)new TcpModbusMessageEncoder(this.pendingMessages, this.transactionIdSupplier));
        pipeline.addLast("modbusMessageDecoder", (ChannelHandler)new TcpModbusMessageDecoder(true, this.pendingMessages));
        super.initChannel(channel);
    }

    private final class HandlerInitializer
    extends ChannelInitializer<SocketChannel> {
        private HandlerInitializer() {
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            TcpNettyModbusClient.this.initChannel((Channel)ch);
        }
    }
}

