/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.booter;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.booter.BasherForkConfiguration;
import net.sourceforge.basher.internal.impl.BasherBootHelper;
import org.apache.maven.surefire.booter.IsolatedClassLoader;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.output.FileOutputConsumerProxy;
import org.apache.maven.surefire.booter.output.ForkingStreamConsumer;
import org.apache.maven.surefire.booter.output.OutputConsumer;
import org.apache.maven.surefire.booter.output.StandardOutputConsumer;
import org.apache.maven.surefire.booter.output.SupressFooterOutputConsumerProxy;
import org.apache.maven.surefire.booter.output.SupressHeaderOutputConsumerProxy;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.IOUtil;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.StringUtils;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.CommandLineException;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.CommandLineUtils;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.Commandline;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.StreamConsumer;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.UrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasherBooter {
    private static final String REPORT_PROPERTY_PREFIX = "report.";
    private static final String PARAMS_SUFFIX = ".params";
    private static final String TYPES_SUFFIX = ".types";
    private List _reports = new ArrayList();
    private List<String> _classPathUrls = new ArrayList<String>();
    private List<String> _basherClassPathUrls = new ArrayList<String>();
    private List<String> _basherBootClassPathUrls = new ArrayList<String>();
    private boolean _failIfNoTasks = false;
    private int _forkedProcessTimeoutInSeconds = 0;
    private boolean _redirectTasksOutputToFile = false;
    private BasherForkConfiguration _forkConfiguration;
    public static final int BASHER_SUCCEEDED_EXIT_CODE = 0;
    public static final int BASHER_FAILED_EXIT_CODE = 255;
    public static final int NO_TASKS_EXIT_CODE = 254;
    private static Method _assertionStatusMethod;
    private File _reportsDirectory;
    private final boolean _isForked;
    private boolean _enableAssertions;
    private List<BasherContext> _basherContexts = new ArrayList<BasherContext>();
    private String _activeBasherContext;
    private String[] _includedFiles;
    private boolean _awaitShutdownEvent = false;

    public BasherBooter() {
        this._isForked = false;
    }

    private BasherBooter(boolean isForked) {
        this._isForked = isForked;
    }

    public int run() throws SurefireBooterForkException, SurefireExecutionException {
        int globalResult = 0;
        int result = this.forkBasherRun();
        if (result > globalResult) {
            globalResult = result;
        }
        return globalResult;
    }

    private int runBasherInProcess(Properties properties) throws SurefireExecutionException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader tasksClassLoader = this.useSystemClassLoader() ? ClassLoader.getSystemClassLoader() : this.createClassLoader(this._classPathUrls, null);
            ClassLoader basherClassLoader = this.createClassLoader(this._basherClassPathUrls, tasksClassLoader);
            Class<?> basherBootHelperClass = basherClassLoader.loadClass(BasherBootHelper.class.getName());
            Object basherBootHelper = basherBootHelperClass.newInstance();
            Method run = basherBootHelperClass.getMethod("run", Properties.class);
            Thread.currentThread().setContextClassLoader(tasksClassLoader);
            int n = (Integer)run.invoke(basherBootHelper, properties);
            return n;
        }
        catch (InvocationTargetException e) {
            throw new SurefireExecutionException(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            throw new SurefireExecutionException("Unable to instantiate and execute Basher", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private int forkBasherRun() throws SurefireBooterForkException {
        Properties properties = new Properties();
        this.setForkProperties(properties);
        return this.fork(properties, true, true);
    }

    private void setForkProperties(Properties properties) {
        String url;
        int i;
        this.addPropertiesForTypeHolder(this._reports, properties, REPORT_PROPERTY_PREFIX);
        this.serializeBasherContexts(properties);
        for (i = 0; i < this._includedFiles.length; ++i) {
            String includedFile = this._includedFiles[i];
            properties.setProperty("includedFile." + i, includedFile);
        }
        for (i = 0; i < this._classPathUrls.size(); ++i) {
            url = this._classPathUrls.get(i);
            properties.setProperty("classPathUrl." + i, url);
        }
        for (i = 0; i < this._basherClassPathUrls.size(); ++i) {
            url = this._basherClassPathUrls.get(i);
            properties.setProperty("basherClassPathUrl." + i, url);
        }
        properties.setProperty("reportingDirectory", this._reportsDirectory.getAbsolutePath());
        if (this._activeBasherContext != null) {
            properties.setProperty("activeBasherContext", this._activeBasherContext);
        }
        properties.setProperty("enableAssertions", String.valueOf(this._enableAssertions));
        properties.setProperty("useSystemClassLoader", String.valueOf(this.useSystemClassLoader()));
        properties.setProperty("useManifestOnlyJar", String.valueOf(this.useManifestOnlyJar()));
        properties.setProperty("failIfNoTasks", String.valueOf(this._failIfNoTasks));
        properties.setProperty("awaitShutdownEvent", String.valueOf(this._awaitShutdownEvent));
    }

    private File writePropertiesFile(String name, Properties properties) throws IOException {
        File file = File.createTempFile(name, "tmp");
        if (!this._forkConfiguration.isDebug()) {
            file.deleteOnExit();
        }
        this.writePropertiesFile(file, name, properties);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesFile(File file, String name, Properties properties) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            properties.store(out, name);
        }
        finally {
            IOUtil.close((OutputStream)out);
        }
    }

    public void serializeBasherContexts(Properties properties) {
        for (BasherContext basherContext : this._basherContexts) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLEncoder xmlEncoder = new XMLEncoder(new BufferedOutputStream(byteArrayOutputStream));
            xmlEncoder.writeObject(basherContext);
            xmlEncoder.flush();
            xmlEncoder.close();
            String basherContextSerialized = new String(byteArrayOutputStream.toByteArray());
            properties.put("basherContext." + basherContext.getName(), basherContextSerialized);
        }
    }

    private static List<BasherContext> deserializeBasherContexts(Properties properties) {
        ArrayList<BasherContext> basherContexts = new ArrayList<BasherContext>();
        for (Object o : properties.keySet()) {
            String key = (String)o;
            if (!key.startsWith("basherContext")) continue;
            XMLDecoder xmlDecoder = new XMLDecoder(new ByteArrayInputStream(properties.getProperty(key).getBytes()));
            BasherContext basherContext = (BasherContext)xmlDecoder.readObject();
            if (basherContext.getReportDirectory() == null) {
                basherContext.setReportDirectory(properties.getProperty("reportingDirectory"));
            }
            basherContexts.add(basherContext);
        }
        return basherContexts;
    }

    private void addPropertiesForTypeHolder(List typeHolderList, Properties properties, String propertyPrefix) {
        for (int i = 0; i < typeHolderList.size(); ++i) {
            Object[] report = (Object[])typeHolderList.get(i);
            String className = (String)report[0];
            Object[] params = (Object[])report[1];
            properties.setProperty(propertyPrefix + i, className);
            if (params == null) continue;
            String paramProperty = BasherBooter.convert(params[0]);
            String typeProperty = params[0].getClass().getName();
            for (int j = 1; j < params.length; ++j) {
                paramProperty = paramProperty + "|";
                typeProperty = typeProperty + "|";
                if (params[j] == null) continue;
                paramProperty = paramProperty + BasherBooter.convert(params[j]);
                typeProperty = typeProperty + params[j].getClass().getName();
            }
            properties.setProperty(propertyPrefix + i + PARAMS_SUFFIX, paramProperty);
            properties.setProperty(propertyPrefix + i + TYPES_SUFFIX, typeProperty);
        }
    }

    private static String convert(Object param) {
        if (param instanceof File[]) {
            Object[] files = (File[])param;
            return "[" + StringUtils.join((Object[])files, (String)",") + "]";
        }
        if (param instanceof Properties) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ((Properties)param).store(baos, "");
                return new String(baos.toByteArray(), "8859_1");
            }
            catch (Exception e) {
                throw new RuntimeException("bug in property conversion", e);
            }
        }
        return param.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int fork(Properties properties, boolean showHeading, boolean showFooter) throws SurefireBooterForkException {
        int returnCode;
        File basherProperties;
        File systemProperties = null;
        try {
            basherProperties = this.writePropertiesFile("basher", properties);
            if (this._forkConfiguration.getSystemProperties() != null) {
                systemProperties = this.writePropertiesFile("basher", this._forkConfiguration.getSystemProperties());
            }
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating properties files for forking", (Throwable)e);
        }
        ArrayList<String> bootClasspath = new ArrayList<String>(this._basherBootClassPathUrls.size() + this._classPathUrls.size());
        bootClasspath.addAll(this._basherBootClassPathUrls);
        if (this.useSystemClassLoader()) {
            bootClasspath.addAll(this._classPathUrls);
        }
        Commandline cli = this._forkConfiguration.createCommandLine(bootClasspath, this.useManifestOnlyJar());
        cli.createArg().setFile(basherProperties);
        if (systemProperties != null) {
            cli.createArg().setFile(systemProperties);
        }
        ForkingStreamConsumer out = this.getForkingStreamConsumer(showHeading, showFooter, this._redirectTasksOutputToFile);
        ForkingStreamConsumer err = this._redirectTasksOutputToFile ? out : this.getForkingStreamConsumer(showHeading, showFooter, this._redirectTasksOutputToFile);
        if (this._forkConfiguration.isDebug()) {
            System.out.println("Forking command line: " + cli);
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err, (int)this._forkedProcessTimeoutInSeconds);
        }
        catch (CommandLineException e) {
            throw new SurefireBooterForkException("Error while executing forked tasks.", (Throwable)e);
        }
        if (this._redirectTasksOutputToFile) {
            try {
                out.getOutputConsumer().testSetCompleted();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (basherProperties == null) return returnCode;
        if (!basherProperties.exists()) return returnCode;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(basherProperties);
            properties.load(inStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new SurefireBooterForkException("Unable to reload properties file from forked process", (Throwable)e);
                catch (IOException e2) {
                    throw new SurefireBooterForkException("Unable to reload properties file from forked process", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(inStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)inStream);
        return returnCode;
    }

    private ClassLoader createClassLoader(List<String> classPathUrls, ClassLoader parent) throws MalformedURLException {
        return this.createClassLoader(classPathUrls, parent, false);
    }

    private ClassLoader createClassLoader(List<String> classPathUrls, ClassLoader parent, boolean childDelegation) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String url : classPathUrls) {
            if (url == null) continue;
            File f = new File(url);
            urls.add(UrlUtils.getURL((File)f));
        }
        IsolatedClassLoader classLoader = new IsolatedClassLoader(parent, childDelegation);
        if (_assertionStatusMethod != null) {
            try {
                if (parent != null) {
                    _assertionStatusMethod.invoke((Object)parent, this._enableAssertions ? Boolean.TRUE : Boolean.FALSE);
                }
                _assertionStatusMethod.invoke((Object)classLoader, this._enableAssertions ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (IllegalAccessException e) {
                throw new NestedRuntimeException("Unable to access the assertion enablement method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new NestedRuntimeException("Unable to invoke the assertion enablement method", (Throwable)e);
            }
        }
        for (URL url : urls) {
            classLoader.addURL(url);
        }
        return classLoader;
    }

    private static List processStringList(String stringList) {
        String sl = stringList;
        if (sl.startsWith("[") && sl.endsWith("]")) {
            sl = sl.substring(1, sl.length() - 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = StringUtils.split((String)sl, (String)",");
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(stringArray[i].trim());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) throws IOException {
        Properties p = new Properties();
        if (file != null && file.exists()) {
            FileInputStream inStream = new FileInputStream(file);
            try {
                p.load(inStream);
            }
            finally {
                IOUtil.close((InputStream)inStream);
            }
        }
        return p;
    }

    public static void main(String[] args) throws Throwable {
        try {
            String url;
            if (args.length > 1) {
                BasherBooter.setSystemProperties(new File(args[1]));
            }
            File basherPropertiesFile = new File(args[0]);
            Properties p = BasherBooter.loadProperties(basherPropertiesFile);
            TreeMap<Integer, String> classPathUrls = new TreeMap<Integer, String>();
            TreeMap<Integer, String> basherClassPathUrls = new TreeMap<Integer, String>();
            BasherBooter basherBooter = new BasherBooter(true);
            BasherForkConfiguration basherForkConfiguration = new BasherForkConfiguration();
            ArrayList<String> includedFiles = new ArrayList<String>();
            basherForkConfiguration.setForkMode("never");
            basherBooter.setForkConfiguration(basherForkConfiguration);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.startsWith(REPORT_PROPERTY_PREFIX) && !name.endsWith(PARAMS_SUFFIX) && !name.endsWith(TYPES_SUFFIX)) {
                    String className = p.getProperty(name);
                    String params = p.getProperty(name + PARAMS_SUFFIX);
                    String types = p.getProperty(name + TYPES_SUFFIX);
                    basherBooter.addReport(className, BasherBooter.constructParamObjects(params, types));
                    continue;
                }
                if (name.startsWith("classPathUrl.")) {
                    classPathUrls.put(Integer.valueOf(name.substring(name.indexOf(46) + 1)), p.getProperty(name));
                    continue;
                }
                if (name.startsWith("includedFile.")) {
                    includedFiles.add(p.getProperty(name));
                    continue;
                }
                if (name.startsWith("basherClassPathUrl.")) {
                    basherClassPathUrls.put(Integer.valueOf(name.substring(name.indexOf(46) + 1)), p.getProperty(name));
                    continue;
                }
                if (name.startsWith("basherBootClassPathUrl.")) {
                    basherBooter.addBasherBootClassPathUrl(p.getProperty(name));
                    continue;
                }
                if ("enableAssertions".equals(name)) {
                    basherBooter._enableAssertions = Boolean.valueOf(p.getProperty("enableAssertions"));
                    continue;
                }
                if ("awaitShutdownEvent".equals(name)) {
                    basherBooter._awaitShutdownEvent = Boolean.valueOf(p.getProperty("awaitShutdownEvent"));
                    continue;
                }
                if ("useSystemClassLoader".equals(name)) {
                    basherBooter._forkConfiguration.setUseSystemClassLoader(Boolean.valueOf(p.getProperty("useSystemClassLoader")));
                    continue;
                }
                if ("useManifestOnlyJar".equals(name)) {
                    basherBooter._forkConfiguration.setUseManifestOnlyJar(Boolean.valueOf(p.getProperty("useManifestOnlyJar")));
                    continue;
                }
                if (!"failIfNoTasks".equals(name)) continue;
                basherBooter.setFailIfNoTasks(Boolean.valueOf(p.getProperty("failIfNoTasks")));
            }
            Iterator cpi = classPathUrls.keySet().iterator();
            while (cpi.hasNext()) {
                url = (String)classPathUrls.get(cpi.next());
                basherBooter.addClassPathUrl(url);
            }
            Iterator scpi = basherClassPathUrls.keySet().iterator();
            while (scpi.hasNext()) {
                url = (String)basherClassPathUrls.get(scpi.next());
                basherBooter.addBasherClassPathUrl(url);
            }
            String activeBasherContext = p.getProperty("activeBasherContext", "default");
            basherBooter.setBasherContexts(BasherBooter.deserializeBasherContexts(p));
            basherBooter.setActiveBasherContext(activeBasherContext);
            int result = basherBooter.runBasherInProcess(p);
            System.exit(result);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static Object[] constructParamObjects(String paramProperty, String typeProperty) {
        Object[] paramObjects = null;
        if (paramProperty != null) {
            String[] params = StringUtils.split((String)StringUtils.replace((String)StringUtils.replace((String)paramProperty, (String)"||", (String)"| |"), (String)"||", (String)"| |"), (String)"|");
            String[] types = StringUtils.split((String)StringUtils.replace((String)StringUtils.replace((String)typeProperty, (String)"||", (String)"| |"), (String)"||", (String)"| |"), (String)"|");
            paramObjects = new Object[params.length];
            for (int i = 0; i < types.length; ++i) {
                if (types[i].trim().length() == 0) {
                    params[i] = null;
                    continue;
                }
                if (types[i].equals(String.class.getName())) {
                    paramObjects[i] = params[i];
                    continue;
                }
                if (types[i].equals(File.class.getName())) {
                    paramObjects[i] = new File(params[i]);
                    continue;
                }
                if (types[i].equals(File[].class.getName())) {
                    List stringList = BasherBooter.processStringList(params[i]);
                    File[] fileList = new File[stringList.size()];
                    for (int j = 0; j < stringList.size(); ++j) {
                        fileList[j] = new File((String)stringList.get(j));
                    }
                    paramObjects[i] = fileList;
                    continue;
                }
                if (types[i].equals(ArrayList.class.getName())) {
                    paramObjects[i] = BasherBooter.processStringList(params[i]);
                    continue;
                }
                if (types[i].equals(Boolean.class.getName())) {
                    paramObjects[i] = Boolean.valueOf(params[i]);
                    continue;
                }
                if (types[i].equals(Integer.class.getName())) {
                    paramObjects[i] = Integer.valueOf(params[i]);
                    continue;
                }
                if (types[i].equals(Properties.class.getName())) {
                    Properties result = new Properties();
                    String value = params[i];
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(value.getBytes("8859_1"));
                        result.load(bais);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("bug in property conversion", e);
                    }
                    paramObjects[i] = result;
                    continue;
                }
                throw new IllegalArgumentException("Unknown parameter type: " + types[i]);
            }
        }
        return paramObjects;
    }

    private ForkingStreamConsumer getForkingStreamConsumer(boolean showHeading, boolean showFooter, boolean redirectTasksOutputToFile) {
        StandardOutputConsumer outputConsumer = new StandardOutputConsumer();
        if (redirectTasksOutputToFile) {
            outputConsumer = new FileOutputConsumerProxy((OutputConsumer)outputConsumer, this.getReportsDirectory());
        }
        if (!showHeading) {
            outputConsumer = new SupressHeaderOutputConsumerProxy((OutputConsumer)outputConsumer);
        }
        if (!showFooter) {
            outputConsumer = new SupressFooterOutputConsumerProxy((OutputConsumer)outputConsumer);
        }
        return new ForkingStreamConsumer((OutputConsumer)outputConsumer);
    }

    public void addReport(String report) {
        this.addReport(report, null);
    }

    public void addReport(String report, Object[] constructorParams) {
        this._reports.add(new Object[]{report, constructorParams});
    }

    public void addClassPathUrl(String path) {
        if (!this._classPathUrls.contains(path)) {
            this._classPathUrls.add(path);
        }
    }

    public void addBasherClassPathUrl(String path) {
        if (!this._basherClassPathUrls.contains(path)) {
            this._basherClassPathUrls.add(path);
        }
    }

    public void addBasherBootClassPathUrl(String path) {
        if (!this._basherBootClassPathUrls.contains(path)) {
            this._basherBootClassPathUrls.add(path);
        }
    }

    public void setFailIfNoTasks(boolean failIfNoTasks) {
        this._failIfNoTasks = failIfNoTasks;
    }

    public void setRedirectTasksOutputToFile(boolean redirectTasksOutputToFile) {
        this._redirectTasksOutputToFile = redirectTasksOutputToFile;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this._reportsDirectory = reportsDirectory;
    }

    public File getReportsDirectory() {
        return this._reportsDirectory;
    }

    public void setForkConfiguration(BasherForkConfiguration forkConfiguration) {
        this._forkConfiguration = forkConfiguration;
    }

    private final boolean useSystemClassLoader() {
        return this._forkConfiguration.isUseSystemClassLoader() && (this._isForked || this._forkConfiguration.isForking());
    }

    private final boolean useManifestOnlyJar() {
        return this._forkConfiguration.isUseSystemClassLoader() && this._forkConfiguration.isUseManifestOnlyJar();
    }

    private static void setSystemProperties(File file) throws IOException {
        Properties p = BasherBooter.loadProperties(file);
        for (String string : p.keySet()) {
            System.setProperty(string, p.getProperty(string));
        }
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this._enableAssertions = enableAssertions;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this._forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    public void setBasherContexts(List<BasherContext> basherContexts) {
        this._basherContexts = basherContexts;
    }

    public void setActiveBasherContext(String activeBasherContext) {
        this._activeBasherContext = activeBasherContext;
    }

    public boolean isForking() {
        return this._forkConfiguration.isForking();
    }

    public void setIncludedFiles(String[] includedFiles) {
        this._includedFiles = includedFiles;
    }

    public String[] getIncludedFiles() {
        return this._includedFiles;
    }

    public void setAwaitShutdownEvent(boolean awaitShutdownEvent) {
        this._awaitShutdownEvent = awaitShutdownEvent;
    }

    static {
        try {
            _assertionStatusMethod = ClassLoader.class.getMethod("setDefaultAssertionStatus", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            _assertionStatusMethod = null;
        }
    }
}

