/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.basher.yourkit;

import com.yourkit.api.Controller;
import net.sourceforge.basher.BasherContext;
import net.sourceforge.basher.ProfilerContext;
import net.sourceforge.basher.YourKitProfilerContext;
import net.sourceforge.basher.events.BasherEvent;
import net.sourceforge.basher.events.BasherEventListener;
import net.sourceforge.basher.events.CollectionEvent;
import net.sourceforge.basher.events.CollectionStartedEvent;
import net.sourceforge.basher.events.CollectionStoppedEvent;
import org.apache.commons.logging.Log;

public class YourKitController
implements BasherEventListener {
    private Controller _controller;
    private Log _log;
    private String _host = "localhost";
    private int _port = 10020;
    private String _filters = "com.sun.*\\njava.*\\njavax.*\\nsun.*\\njrockit.*\\nnet.sourceforge.basher.*";

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public void initializeService() throws Exception {
        this._log.info((Object)"Initializing YourKit Controller");
        this._log.info((Object)("Hostname: " + this._host));
        this._log.info((Object)("Port: " + this._port));
        this.connect();
    }

    public void basherEvent(BasherEvent basherEvent) {
        long[] longs;
        YourKitProfilerContext yourKitProfilerContext;
        BasherContext basherContext;
        if (basherEvent instanceof CollectionStartedEvent) {
            try {
                basherContext = this.getBasherContext(basherEvent);
                yourKitProfilerContext = this.extractYourkitProfilerContext(basherContext);
                if (yourKitProfilerContext == null) {
                    return;
                }
                if (this._controller == null) {
                    this._log.warn((Object)"Not connected to profiler, will not perform any action");
                    return;
                }
                if (yourKitProfilerContext.isGarbageCollectBeforeStart()) {
                    this._log.info((Object)"Forcing GC before starting profiling");
                    longs = this._controller.forceGC();
                    this._log.info((Object)"GC completed");
                    this._log.info((Object)("Memory Before: " + longs[0]));
                    this._log.info((Object)("Memory After: " + longs[1]));
                    this._log.info((Object)("Total Reclaimed: " + (longs[0] - longs[1])));
                }
                this._controller.startCPUProfiling(12L, this._filters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (basherEvent instanceof CollectionStoppedEvent) {
            basherContext = this.getBasherContext(basherEvent);
            try {
                yourKitProfilerContext = this.extractYourkitProfilerContext(basherContext);
                if (yourKitProfilerContext == null) {
                    return;
                }
                if (this._controller == null) {
                    this._log.warn((Object)"Not connected to profiler, will not perform any action");
                    return;
                }
                if (yourKitProfilerContext.isGarbageCollectBeforeStart()) {
                    this._log.info((Object)"Forcing GC before capturing snapshot");
                    longs = this._controller.forceGC();
                    this._log.info((Object)"GC completed");
                    this._log.info((Object)("Memory Before: " + longs[0]));
                    this._log.info((Object)("Memory After: " + longs[1]));
                    this._log.info((Object)("Total Reclaimed: " + (longs[0] - longs[1])));
                }
                this._log.info((Object)"Capturing snapshot");
                String s = this._controller.captureSnapshot(0L);
                this._log.info((Object)("Snapshot captured to: " + s));
                this._log.info((Object)"Stopping profiling");
                this._controller.stopCPUProfiling();
                this._log.info((Object)"Profiling stopped");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private YourKitProfilerContext extractYourkitProfilerContext(BasherContext basherContext) {
        ProfilerContext profilerContext = basherContext.getProfilerContext();
        if (profilerContext == null) {
            this._log.info((Object)"No profiler context defined in Basher context, will do nothing");
            return null;
        }
        if (!(profilerContext instanceof YourKitProfilerContext)) {
            this._log.info((Object)"Profiler context not applicable to YourKit, will do nothing");
            return null;
        }
        return (YourKitProfilerContext)profilerContext;
    }

    private void connect() {
        try {
            this._log.info((Object)"Connecting to profiling agent");
            this._controller = new Controller(this._host, this._port);
            this._log.info((Object)"Successfully connected to profiling agent");
        }
        catch (Exception e) {
            this._log.error((Object)("Error while setting up YourKit controller: " + e.getMessage()), (Throwable)e);
        }
    }

    private void disconnect(BasherContext basherContext) {
        if (this._controller == null) {
            this._log.warn((Object)"No YourKit controller available, will do nothing");
        }
        this._controller = null;
    }

    private BasherContext getBasherContext(BasherEvent basherEvent) {
        return ((CollectionEvent)basherEvent).getBasherContext();
    }
}

