/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowValueChooser;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonCollector;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonFinder;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.RedundantBranch;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.detect.NullArgumentWarningProperty;
import edu.umd.cs.findbugs.detect.NullDerefProperty;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.props.GeneralWarningProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNullDeref
implements Detector,
NullDerefAndRedundantComparisonCollector {
    private static final boolean DEBUG = Boolean.getBoolean("fnd.debug");
    private static final boolean DEBUG_NULLARG = Boolean.getBoolean("fnd.debug.nullarg");
    private static final boolean DEBUG_NULLRETURN = Boolean.getBoolean("fnd.debug.nullreturn");
    private static final boolean REPORT_SAFE_METHOD_TARGETS = true;
    private static final String METHOD = System.getProperty("fnd.method");
    private BugReporter bugReporter;
    private ParameterNullnessPropertyDatabase unconditionalDerefParamDatabase;
    private boolean checkedDatabases = false;
    private ClassContext classContext;
    private Method method;
    private IsNullValueDataflow invDataflow;
    private BitSet previouslyDeadBlocks;
    private NullnessAnnotation methodAnnotation;

    public FindNullDeref(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        try {
            Method[] methodList;
            JavaClass jclass = classContext.getJavaClass();
            for (Method method : methodList = jclass.getMethods()) {
                if (method.isAbstract() || method.isNative() || method.getCode() == null || METHOD != null && !method.getName().equals(METHOD)) continue;
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Checking for NP in ").append(method.getName()).toString());
                }
                this.analyzeMethod(classContext, method);
            }
        }
        catch (MissingClassException e) {
            this.bugReporter.reportMissingClass(e.getClassNotFoundException());
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("FindNullDeref caught dae exception", (Throwable)e);
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("FindNullDeref caught cfgb exception", (Throwable)e);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        if (!this.checkedDatabases) {
            this.checkDatabases();
            this.checkedDatabases = true;
        }
        this.method = method;
        this.methodAnnotation = this.getMethodNullnessAnnotation();
        if (DEBUG || DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("FND: ").append(SignatureConverter.convertMethodSignature((MethodGen)methodGen)).toString());
        }
        this.previouslyDeadBlocks = this.findPreviouslyDeadBlocks();
        this.invDataflow = classContext.getIsNullValueDataflow(method);
        NullDerefAndRedundantComparisonFinder worker = new NullDerefAndRedundantComparisonFinder(classContext, method, this.invDataflow, (NullDerefAndRedundantComparisonCollector)this);
        worker.execute();
        this.checkCallSitesAndReturnInstructions();
    }

    private BitSet findPreviouslyDeadBlocks() throws DataflowAnalysisException, CFGBuilderException {
        BitSet deadBlocks = new BitSet();
        ValueNumberDataflow vnaDataflow = this.classContext.getValueNumberDataflow(this.method);
        Iterator i = vnaDataflow.getCFG().blockIterator();
        while (i.hasNext()) {
            BasicBlock block = (BasicBlock)i.next();
            ValueNumberFrame vnaFrame = (ValueNumberFrame)vnaDataflow.getStartFact(block);
            if (!vnaFrame.isTop()) continue;
            deadBlocks.set(block.getId());
        }
        return deadBlocks;
    }

    private void checkDatabases() {
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        this.unconditionalDerefParamDatabase = analysisContext.getUnconditionalDerefParamDatabase();
    }

    private <DatabaseType extends PropertyDatabase<?, ?>> boolean isDatabaseNonEmpty(DatabaseType database) {
        return database != null && !database.isEmpty();
    }

    private NullnessAnnotation getMethodNullnessAnnotation() {
        if (this.method.getSignature().indexOf(")L") >= 0 || this.method.getSignature().indexOf(")[") >= 0) {
            if (DEBUG_NULLRETURN) {
                System.out.println(new StringBuffer().append("Checking return annotation for ").append(SignatureConverter.convertMethodSignature((JavaClass)this.classContext.getJavaClass(), (Method)this.method)).toString());
            }
            XMethod m = XFactory.createXMethod((JavaClass)this.classContext.getJavaClass(), (Method)this.method);
            return AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation((Object)m, false);
        }
        return NullnessAnnotation.UNKNOWN_NULLNESS;
    }

    private void checkCallSitesAndReturnInstructions() throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = this.classContext.getConstantPoolGen();
        TypeDataflow typeDataflow = this.classContext.getTypeDataflow(this.method);
        Iterator i = this.classContext.getCFG(this.method).locationIterator();
        while (i.hasNext()) {
            Location location = (Location)i.next();
            Instruction ins = location.getHandle().getInstruction();
            try {
                if (ins instanceof InvokeInstruction) {
                    this.examineCallSite(location, cpg, typeDataflow);
                    continue;
                }
                if (this.methodAnnotation == NullnessAnnotation.NONNULL && ins.getOpcode() == 176) {
                    this.examineReturnInstruction(location);
                    continue;
                }
                if (!(ins instanceof PUTFIELD)) continue;
                this.examinePutfieldInstruction(location, (PUTFIELD)ins, cpg);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }

    private void examineCallSite(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow) throws DataflowAnalysisException, CFGBuilderException, ClassNotFoundException {
        InvokeInstruction invokeInstruction = (InvokeInstruction)location.getHandle().getInstruction();
        String methodName = invokeInstruction.getName(cpg);
        String signature = invokeInstruction.getSignature(cpg);
        if (methodName.equals("equals") && signature.equals("(Ljava/lang/Object;)Z")) {
            return;
        }
        int returnTypeStart = signature.indexOf(41);
        if (returnTypeStart < 0) {
            return;
        }
        String paramList = signature.substring(0, returnTypeStart + 1);
        if (paramList.equals("()") || paramList.indexOf("L") < 0 && paramList.indexOf(91) < 0) {
            return;
        }
        IsNullValueFrame frame = this.classContext.getIsNullValueDataflow(this.method).getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        BitSet nullArgSet = frame.getArgumentSet(invokeInstruction, cpg, (DataflowValueChooser)new DataflowValueChooser<IsNullValue>(){

            public boolean choose(IsNullValue value) {
                return value.mightBeNull() && !value.isException();
            }

            public /* synthetic */ boolean choose(Object x0) {
                return this.choose((IsNullValue)x0);
            }
        });
        BitSet definitelyNullArgSet = frame.getArgumentSet(invokeInstruction, cpg, (DataflowValueChooser)new DataflowValueChooser<IsNullValue>(){

            public boolean choose(IsNullValue value) {
                return value.isDefinitelyNull();
            }

            public /* synthetic */ boolean choose(Object x0) {
                return this.choose((IsNullValue)x0);
            }
        });
        if (nullArgSet.isEmpty()) {
            return;
        }
        if (DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("Null arguments passed: ").append(nullArgSet).toString());
            System.out.println(new StringBuffer().append("Frame is: ").append(frame).toString());
            System.out.println(new StringBuffer().append("# arguments: ").append(frame.getNumArguments(invokeInstruction, cpg)).toString());
            XMethod xm = XFactory.createXMethod((InvokeInstruction)invokeInstruction, (ConstantPoolGen)cpg);
            System.out.print(new StringBuffer().append("Signature: ").append(xm.getSignature()).toString());
        }
        if (this.unconditionalDerefParamDatabase != null) {
            this.checkUnconditionallyDereferencedParam(location, cpg, typeDataflow, invokeInstruction, nullArgSet, definitelyNullArgSet);
        }
        if (DEBUG_NULLARG) {
            System.out.println("Checking nonnull params");
        }
        this.checkNonNullParam(location, cpg, typeDataflow, invokeInstruction, nullArgSet, definitelyNullArgSet);
    }

    private void examinePutfieldInstruction(Location location, PUTFIELD ins, ConstantPoolGen cpg) throws DataflowAnalysisException, CFGBuilderException {
        IsNullValueDataflow invDataflow = this.classContext.getIsNullValueDataflow(this.method);
        IsNullValueFrame frame = invDataflow.getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        IsNullValue tos = (IsNullValue)frame.getTopValue();
        if (tos.mightBeNull()) {
            XField field = XFactory.createXField((String)ins.getClassName(cpg), (String)ins.getFieldName(cpg), (String)ins.getSignature(cpg), (boolean)false, (int)0);
            NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation((Object)field, false);
            if (annotation == NullnessAnnotation.NONNULL) {
                MethodGen methodGen = this.classContext.getMethodGen(this.method);
                String sourceFile = this.classContext.getJavaClass().getSourceFileName();
                BugInstance warning = new BugInstance("NP_STORE_INTO_NONNULL_FIELD", tos.isDefinitelyNull() ? 1 : 2).addClassAndMethod(methodGen, sourceFile).addField(field).addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle());
                this.bugReporter.reportBug(warning);
            }
        }
    }

    private void examineReturnInstruction(Location location) throws DataflowAnalysisException, CFGBuilderException {
        IsNullValueDataflow invDataflow;
        IsNullValueFrame frame;
        if (DEBUG_NULLRETURN) {
            System.out.println(new StringBuffer().append("Checking null return at ").append(location).toString());
        }
        if (!(frame = (invDataflow = this.classContext.getIsNullValueDataflow(this.method)).getFactAtLocation(location)).isValid()) {
            return;
        }
        IsNullValue tos = (IsNullValue)frame.getTopValue();
        if (tos.mightBeNull()) {
            MethodGen methodGen = this.classContext.getMethodGen(this.method);
            String sourceFile = this.classContext.getJavaClass().getSourceFileName();
            BugInstance warning = new BugInstance("NP_NONNULL_RETURN_VIOLATION", tos.isDefinitelyNull() ? 1 : 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle());
            this.bugReporter.reportBug(warning);
        }
    }

    private void checkUnconditionallyDereferencedParam(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow, InvokeInstruction invokeInstruction, BitSet nullArgSet, BitSet definitelyNullArgSet) throws DataflowAnalysisException, ClassNotFoundException {
        int priority;
        String bugType;
        TypeFrame typeFrame = typeDataflow.getFactAtLocation(location);
        Set targetMethodSet = Hierarchy.resolveMethodCallTargets((InvokeInstruction)invokeInstruction, (TypeFrame)typeFrame, (ConstantPoolGen)cpg);
        if (DEBUG_NULLARG) {
            System.out.println(new StringBuffer().append("Possibly called methods: ").append(targetMethodSet).toString());
        }
        BitSet unconditionallyDereferencedNullArgSet = new BitSet();
        LinkedList<JavaClassAndMethod> dangerousCallTargetList = new LinkedList<JavaClassAndMethod>();
        LinkedList<JavaClassAndMethod> veryDangerousCallTargetList = new LinkedList<JavaClassAndMethod>();
        for (JavaClassAndMethod targetMethod : targetMethodSet) {
            BitSet targetUnconditionallyDereferencedNullArgSet;
            ParameterNullnessProperty property;
            if (DEBUG_NULLARG) {
                System.out.println(new StringBuffer().append("For target method ").append(targetMethod).toString());
            }
            if ((property = (ParameterNullnessProperty)this.unconditionalDerefParamDatabase.getProperty((Object)targetMethod.toXMethod())) == null) continue;
            if (DEBUG_NULLARG) {
                System.out.println(new StringBuffer().append("\tUnconditionally dereferenced params: ").append(property).toString());
            }
            if ((targetUnconditionallyDereferencedNullArgSet = property.getViolatedParamSet(nullArgSet)).isEmpty()) continue;
            dangerousCallTargetList.add(targetMethod);
            unconditionallyDereferencedNullArgSet.or(targetUnconditionallyDereferencedNullArgSet);
            if (property.getViolatedParamSet(definitelyNullArgSet).isEmpty()) continue;
            veryDangerousCallTargetList.add(targetMethod);
        }
        if (dangerousCallTargetList.isEmpty()) {
            return;
        }
        WarningPropertySet propertySet = new WarningPropertySet();
        HashSet safeCallTargetSet = new HashSet();
        safeCallTargetSet.addAll(targetMethodSet);
        safeCallTargetSet.removeAll(dangerousCallTargetList);
        if (safeCallTargetSet.isEmpty()) {
            propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.ALL_DANGEROUS_TARGETS);
            if (dangerousCallTargetList.size() == 1) {
                propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.MONOMORPHIC_CALL_SITE);
            }
        }
        boolean privateCall = safeCallTargetSet.isEmpty() && dangerousCallTargetList.size() == 1 && ((JavaClassAndMethod)dangerousCallTargetList.get(0)).getMethod().isPrivate();
        MethodGen methodGen = this.classContext.getMethodGen(this.method);
        String sourceFile = this.classContext.getJavaClass().getSourceFileName();
        if (privateCall || invokeInstruction.getOpcode() == 184 || invokeInstruction.getOpcode() == 183) {
            bugType = "NP_NULL_PARAM_DEREF_NONVIRTUAL";
            priority = 1;
        } else if (safeCallTargetSet.isEmpty()) {
            bugType = "NP_NULL_PARAM_DEREF_ALL_TARGETS_DANGEROUS";
            priority = 2;
        } else {
            bugType = "NP_NULL_PARAM_DEREF";
            priority = 3;
        }
        if (dangerousCallTargetList.size() > veryDangerousCallTargetList.size()) {
            ++priority;
        } else {
            propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.ACTUAL_PARAMETER_GUARANTEED_NULL);
        }
        BugInstance warning = new BugInstance(bugType, priority).addClassAndMethod(methodGen, sourceFile).addMethod(XFactory.createXMethod((InvokeInstruction)invokeInstruction, (ConstantPoolGen)cpg)).describe("METHOD_CALLED").addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle());
        this.addParamAnnotations(definitelyNullArgSet, unconditionallyDereferencedNullArgSet, propertySet, warning);
        for (JavaClassAndMethod dangerousCallTarget : veryDangerousCallTargetList) {
            warning.addMethod(dangerousCallTarget).describe("METHOD_DANGEROUS_TARGET_ACTUAL_GUARANTEED_NULL");
        }
        dangerousCallTargetList.removeAll(veryDangerousCallTargetList);
        for (JavaClassAndMethod dangerousCallTarget : dangerousCallTargetList) {
            warning.addMethod(dangerousCallTarget).describe("METHOD_DANGEROUS_TARGET");
        }
        for (JavaClassAndMethod safeMethod : safeCallTargetSet) {
            warning.addMethod(safeMethod).describe("METHOD_SAFE_TARGET");
        }
        this.decorateWarning(location, propertySet, warning);
        this.bugReporter.reportBug(warning);
    }

    private void decorateWarning(Location location, WarningPropertySet propertySet, BugInstance warning) {
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)this.classContext, (Method)this.method, (Location)location);
        }
        propertySet.decorateBugInstance(warning);
    }

    private void addParamAnnotations(BitSet definitelyNullArgSet, BitSet violatedParamSet, WarningPropertySet propertySet, BugInstance warning) {
        for (int i = 0; i < 32; ++i) {
            if (!violatedParamSet.get(i)) continue;
            boolean definitelyNull = definitelyNullArgSet.get(i);
            if (definitelyNull) {
                propertySet.addProperty((WarningProperty)NullArgumentWarningProperty.ARG_DEFINITELY_NULL);
            }
            warning.addInt(i + 1).describe(definitelyNull ? "INT_NULL_ARG" : "INT_MAYBE_NULL_ARG");
        }
    }

    private void checkNonNullParam(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow, InvokeInstruction invokeInstruction, BitSet nullArgSet, BitSet definitelyNullArgSet) throws ClassNotFoundException {
        XMethod m = XFactory.createXMethod((InvokeInstruction)invokeInstruction, (ConstantPoolGen)cpg);
        NullnessAnnotationDatabase db = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
        int i = nullArgSet.nextSetBit(0);
        while (i >= 0) {
            int paramNum = 0;
            String signature = invokeInstruction.getSignature(cpg);
            Type[] args = Type.getArgumentTypes((String)signature);
            for (int words = 0; words < i; words += args[paramNum++].getSize()) {
            }
            if (db.parameterMustBeNonNull(m, paramNum)) {
                boolean definitelyNull = definitelyNullArgSet.get(i);
                if (DEBUG_NULLARG) {
                    System.out.println(new StringBuffer().append("QQQ2: ").append(i).append(" -- ").append(paramNum).append(" is null").toString());
                    System.out.println(new StringBuffer().append("QQQ nullArgSet: ").append(nullArgSet).toString());
                    System.out.println(new StringBuffer().append("QQQ dnullArgSet: ").append(definitelyNullArgSet).toString());
                }
                MethodGen methodGen = this.classContext.getMethodGen(this.method);
                String sourceFile = this.classContext.getJavaClass().getSourceFileName();
                BugInstance warning = new BugInstance("NP_NONNULL_PARAM_VIOLATION", definitelyNull ? 1 : 2).addClassAndMethod(methodGen, sourceFile).addMethod(m).describe("METHOD_CALLED").addInt(i).describe("INT_NONNULL_PARAM").addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle());
                this.bugReporter.reportBug(warning);
            }
            i = nullArgSet.nextSetBit(i + 1);
        }
    }

    public void report() {
    }

    public void foundNullDeref(Location location, ValueNumber valueNumber, IsNullValue refValue) {
        WarningPropertySet propertySet = new WarningPropertySet();
        boolean onExceptionPath = refValue.isException();
        if (onExceptionPath) {
            propertySet.addProperty((WarningProperty)GeneralWarningProperty.ON_EXCEPTION_PATH);
        }
        if (refValue.isDefinitelyNull()) {
            String type = onExceptionPath ? "NP_ALWAYS_NULL_EXCEPTION" : "NP_ALWAYS_NULL";
            int priority = onExceptionPath ? 2 : 1;
            this.reportNullDeref(propertySet, this.classContext, this.method, location, type, priority);
        } else if (refValue.isNullOnSomePath()) {
            int priority;
            String type = onExceptionPath ? "NP_NULL_ON_SOME_PATH_EXCEPTION" : "NP_NULL_ON_SOME_PATH";
            int n = priority = onExceptionPath ? 3 : 2;
            if (refValue.isReturnValue()) {
                type = "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE";
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Reporting null on some path: value=").append(refValue).toString());
            }
            this.reportNullDeref(propertySet, this.classContext, this.method, location, type, priority);
        }
    }

    private void reportNullDeref(WarningPropertySet propertySet, ClassContext classContext, Method method, Location location, String type, int priority) {
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        BugInstance bugInstance = new BugInstance((Detector)this, type, priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(classContext, methodGen, sourceFile, location.getHandle());
        if (DEBUG) {
            bugInstance.addInt(location.getHandle().getPosition()).describe("INT_BYTECODE_OFFSET");
        }
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)classContext, (Method)method, (Location)location);
            propertySet.decorateBugInstance(bugInstance);
        }
        this.bugReporter.reportBug(bugInstance);
    }

    public static boolean isThrower(BasicBlock target) {
        int maxCount = 7;
        for (InstructionHandle ins = target.getFirstInstruction(); ins != null && maxCount-- > 0; ins = ins.getNext()) {
            Instruction i = ins.getInstruction();
            if (i instanceof ATHROW) {
                return true;
            }
            if (!(i instanceof InstructionTargeter) && !(i instanceof ReturnInstruction)) continue;
            return false;
        }
        return false;
    }

    public void foundRedundantNullCheck(Location location, RedundantBranch redundantBranch) {
        int priority;
        String warning;
        String sourceFile = this.classContext.getJavaClass().getSourceFileName();
        MethodGen methodGen = this.classContext.getMethodGen(this.method);
        boolean isChecked = redundantBranch.firstValue.isChecked();
        boolean wouldHaveBeenAKaboom = redundantBranch.firstValue.wouldHaveBeenAKaboom();
        Location locationOfKaBoom = redundantBranch.firstValue.getLocationOfKaBoom();
        boolean createdDeadCode = false;
        boolean infeasibleEdgeSimplyThrowsException = false;
        Edge infeasibleEdge = redundantBranch.infeasibleEdge;
        if (infeasibleEdge != null) {
            boolean empty;
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Check if ").append(redundantBranch).append(" creates dead code").toString());
            }
            BasicBlock target = (BasicBlock)infeasibleEdge.getTarget();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Target block is  ").append(target.isExceptionThrower() ? " exception thrower" : " not exception thrower").toString());
            }
            boolean bl = empty = !target.isExceptionThrower() && (target.isEmpty() || this.isGoto(target.getFirstInstruction().getInstruction()));
            if (!empty) {
                try {
                    if (this.classContext.getCFG(this.method).getNumIncomingEdges((AbstractVertex)target) > 1) {
                        if (DEBUG) {
                            System.out.println("Target of infeasible edge has multiple incoming edges");
                        }
                        empty = true;
                    }
                }
                catch (CFGBuilderException e) {
                    // empty catch block
                }
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Target block is  ").append(empty ? "empty" : "not empty").toString());
            }
            if (!empty && FindNullDeref.isThrower(target)) {
                infeasibleEdgeSimplyThrowsException = true;
            }
            if (!empty && !this.previouslyDeadBlocks.get(target.getId())) {
                if (DEBUG) {
                    System.out.println("target was alive previously");
                }
                IsNullValueFrame invFrame = (IsNullValueFrame)this.invDataflow.getStartFact(target);
                createdDeadCode = invFrame.isTop();
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("target is now ").append(createdDeadCode ? "dead" : "alive").toString());
                }
            }
        }
        boolean valueIsNull = true;
        if (redundantBranch.secondValue == null) {
            if (redundantBranch.firstValue.isDefinitelyNull()) {
                warning = "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE";
                priority = 2;
            } else {
                warning = "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE";
                valueIsNull = false;
                priority = isChecked ? 2 : 3;
            }
        } else {
            boolean bothNull;
            boolean bl = bothNull = redundantBranch.firstValue.isDefinitelyNull() && redundantBranch.secondValue.isDefinitelyNull();
            if (redundantBranch.secondValue.isChecked()) {
                isChecked = true;
            }
            if (redundantBranch.secondValue.wouldHaveBeenAKaboom()) {
                wouldHaveBeenAKaboom = true;
                locationOfKaBoom = redundantBranch.secondValue.getLocationOfKaBoom();
            }
            if (bothNull) {
                warning = "RCN_REDUNDANT_COMPARISON_TWO_NULL_VALUES";
                priority = 2;
            } else {
                warning = "RCN_REDUNDANT_COMPARISON_OF_NULL_AND_NONNULL_VALUE";
                int n = priority = isChecked ? 2 : 3;
            }
        }
        if (wouldHaveBeenAKaboom) {
            priority = 1;
            warning = "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE";
            if (locationOfKaBoom == null) {
                throw new NullPointerException("location of KaBoom is null");
            }
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append(createdDeadCode).append(" ").append(infeasibleEdgeSimplyThrowsException).append(" ").append(valueIsNull).append(" ").append(priority).toString());
        }
        priority = createdDeadCode && !infeasibleEdgeSimplyThrowsException ? (priority += 0) : (createdDeadCode && infeasibleEdgeSimplyThrowsException ? (valueIsNull ? (priority += 0) : ++priority) : ++priority);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("RCN").append(priority).append(" ").append(redundantBranch.firstValue).append(" =? ").append(redundantBranch.secondValue).append(" : ").append(warning).toString());
            if (isChecked) {
                System.out.println("isChecked");
            }
            if (wouldHaveBeenAKaboom) {
                System.out.println("wouldHaveBeenAKaboom");
            }
            if (createdDeadCode) {
                System.out.println("createdDeadCode");
            }
        }
        BugInstance bugInstance = new BugInstance((Detector)this, warning, priority).addClassAndMethod(methodGen, sourceFile);
        if (wouldHaveBeenAKaboom) {
            bugInstance.addSourceLine(this.classContext, methodGen, sourceFile, locationOfKaBoom.getHandle());
        }
        bugInstance.addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle()).describe("SOURCE_REDUNDANT_NULL_CHECK");
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertySet propertySet = new WarningPropertySet();
            WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)this.classContext, (Method)this.method, (Location)location);
            if (isChecked) {
                propertySet.addProperty((WarningProperty)NullDerefProperty.CHECKED_VALUE);
            }
            if (wouldHaveBeenAKaboom) {
                propertySet.addProperty((WarningProperty)NullDerefProperty.WOULD_HAVE_BEEN_A_KABOOM);
            }
            if (createdDeadCode) {
                propertySet.addProperty((WarningProperty)NullDerefProperty.CREATED_DEAD_CODE);
            }
            propertySet.decorateBugInstance(bugInstance);
            priority = propertySet.computePriority(2);
            bugInstance.setPriority(priority);
        }
        this.bugReporter.reportBug(bugInstance);
    }

    private boolean isGoto(Instruction instruction) {
        return instruction.getOpcode() == 167 || instruction.getOpcode() == 200;
    }
}

