/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowCFGPrinter;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationAnalysis;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.PolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.State;
import edu.umd.cs.findbugs.ba.obl.StateSet;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;

public class FindUnsatisfiedObligation
implements Detector {
    private static final boolean ENABLE;
    private static final boolean DEBUG;
    private static final boolean DEBUG_PRINTCFG;
    private static final String DEBUG_METHOD;
    private BugReporter bugReporter;
    private ObligationFactory factory;
    private PolicyDatabase database;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FindUnsatisfiedObligation(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.factory = new ObligationFactory();
        this.database = this.buildDatabase();
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        if (!ENABLE) {
            return;
        }
        Method[] arr$ = methodList = classContext.getJavaClass().getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            MethodGen methodGen;
            Method method = arr$[i$];
            if (DEBUG_METHOD != null && !method.getName().equals(DEBUG_METHOD) || (methodGen = classContext.getMethodGen(method)) == null) continue;
            this.analyzeMethod(classContext, method);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("*** Analyzing method " + SignatureConverter.convertMethodSignature((MethodGen)methodGen));
        }
        try {
            CFG cfg = classContext.getCFG(method);
            DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
            TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
            if (!$assertionsDisabled && typeDataflow == null) {
                throw new AssertionError();
            }
            ObligationAnalysis analysis = new ObligationAnalysis(dfs, typeDataflow, methodGen, this.factory, this.database, (RepositoryLookupFailureCallback)this.bugReporter);
            Dataflow dataflow = new Dataflow(cfg, (DataflowAnalysis)analysis);
            dataflow.execute();
            if (DEBUG_PRINTCFG) {
                System.out.println("Dataflow CFG:");
                DataflowCFGPrinter.printCFG((Dataflow)dataflow, (PrintStream)System.out);
            }
            StateSet factAtExit = (StateSet)dataflow.getStartFact(cfg.getExit());
            HashSet<Obligation> leakedObligationSet = new HashSet<Obligation>();
            Iterator i = factAtExit.stateIterator();
            while (i.hasNext()) {
                State state = (State)i.next();
                for (int id = 0; id < this.factory.getMaxObligationTypes(); ++id) {
                    if (state.getObligationSet().getCount(id) <= 0) continue;
                    leakedObligationSet.add(this.factory.getObligationById(id));
                }
            }
            Iterator i$ = leakedObligationSet.iterator();
            while (i$.hasNext()) {
                Obligation obligation = (Obligation)i$.next();
                this.bugReporter.reportBug(new BugInstance((Detector)this, "OS_OPEN_STREAM", 2).addClassAndMethod(methodGen, classContext.getJavaClass().getSourceFileName()).addClass(obligation.getClassName()).describe("CLASS_REFTYPE"));
            }
        }
        catch (CFGBuilderException e) {
            this.bugReporter.logError("Error building CFG for " + SignatureConverter.convertMethodSignature((MethodGen)methodGen), (Throwable)e);
        }
        catch (DataflowAnalysisException e) {
            this.bugReporter.logError("ObligationAnalysis error while analyzing " + SignatureConverter.convertMethodSignature((MethodGen)methodGen), (Throwable)e);
        }
    }

    public void report() {
    }

    private PolicyDatabase buildDatabase() {
        PolicyDatabase result = new PolicyDatabase();
        Obligation inputStreamObligation = this.factory.addObligation("java.io.InputStream");
        Obligation outputStreamObligation = this.factory.addObligation("java.io.OutputStream");
        result.addEntry("java.io.FileInputStream", "<init>", "(Ljava/lang/String;)V", false, 0, inputStreamObligation);
        result.addEntry("java.io.FileOutputStream", "<init>", "(Ljava/lang/String;)V", false, 0, outputStreamObligation);
        result.addEntry("java.io.InputStream", "close", "()V", false, 1, inputStreamObligation);
        result.addEntry("java.io.OutputStream", "close", "()V", false, 1, outputStreamObligation);
        return result;
    }

    static {
        $assertionsDisabled = !FindUnsatisfiedObligation.class.desiredAssertionStatus();
        ENABLE = SystemProperties.getBoolean((String)"oa.enable");
        DEBUG = SystemProperties.getBoolean((String)"oa.debug");
        DEBUG_PRINTCFG = SystemProperties.getBoolean((String)"oa.printcfg");
        DEBUG_METHOD = SystemProperties.getProperty((String)"oa.method");
    }
}

