/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.htmlunit.xpath.XPathHelper;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.w3c.dom.Document;

public abstract class AbstractXPathTest {
    public <T> List<T> getByXpath(String xml, String xPath) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(IOUtils.toInputStream((String)xml, (Charset)StandardCharsets.UTF_8));
        return XPathHelper.getByXPath(doc, xPath, null, false);
    }

    public <T> List<T> getByXpath(String xPath) throws Exception {
        return this.getByXpath("<root></root>", xPath);
    }

    public void assertGetByXpathException(String xml, String xPath, String exMsg, String exCauseMsg) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(IOUtils.toInputStream((String)xml, (Charset)StandardCharsets.UTF_8));
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> XPathHelper.getByXPath(doc, xPath, null, false));
        Assertions.assertEquals((Object)exMsg, (Object)exception.getMessage());
        Assertions.assertEquals((Object)exCauseMsg, (Object)exception.getCause().getMessage());
    }

    public void assertGetByXpathException(String xPath, String exMsg, String exCauseMsg) throws Exception {
        this.assertGetByXpathException("<root></root>", xPath, exMsg, exCauseMsg);
    }
}

