/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.compiler.Compiler;
import net.sourceforge.htmlunit.xpath.compiler.FunctionTable;
import net.sourceforge.htmlunit.xpath.compiler.XPathParser;
import net.sourceforge.htmlunit.xpath.objects.XObject;
import net.sourceforge.htmlunit.xpath.res.XPATHMessages;
import net.sourceforge.htmlunit.xpath.xml.utils.DefaultErrorHandler;
import net.sourceforge.htmlunit.xpath.xml.utils.PrefixResolver;
import net.sourceforge.htmlunit.xpath.xml.utils.WrappedRuntimeException;

class XPathAdapter {
    private final Expression mainExp_;
    private FunctionTable funcTable_;

    private void initFunctionTable() {
        this.funcTable_ = new FunctionTable();
    }

    XPathAdapter(String exprString, PrefixResolver prefixResolver, ErrorListener errorListener, boolean caseSensitive) throws TransformerException {
        this.initFunctionTable();
        ErrorListener errListener = errorListener;
        if (errListener == null) {
            errListener = new DefaultErrorHandler();
        }
        XPathParser parser = new XPathParser(errListener);
        Compiler compiler = new Compiler(errorListener, this.funcTable_);
        parser.initXPath(compiler, exprString, prefixResolver);
        this.mainExp_ = compiler.compile(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XObject execute(XPathContext xpathContext, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        XObject xobj;
        block11: {
            xpathContext.pushNamespaceContext(namespaceContext);
            xpathContext.pushCurrentNodeAndExpression(contextNode);
            xobj = null;
            try {
                xobj = this.mainExp_.execute(xpathContext);
            }
            catch (TransformerException te) {
                te.setLocator((SourceLocator)this.mainExp_);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.error(te);
                    break block11;
                }
                throw te;
            }
            catch (Exception e) {
                Exception unwrapped = e;
                while (unwrapped instanceof WrappedRuntimeException) {
                    unwrapped = ((WrappedRuntimeException)unwrapped).getException();
                }
                String msg = unwrapped.getMessage();
                if (msg == null || msg.isEmpty()) {
                    msg = XPATHMessages.createXPATHMessage((String)"ER_XPATH_ERROR", null);
                }
                TransformerException te = new TransformerException(msg, (SourceLocator)this.mainExp_, unwrapped);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.fatalError(te);
                    break block11;
                }
                throw te;
            }
            finally {
                xpathContext.popNamespaceContext();
                xpathContext.popCurrentNodeAndExpression();
            }
        }
        return xobj;
    }
}

