/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath;

import java.util.List;
import net.sourceforge.htmlunit.xpath.AbstractXPathTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Element;

public class XPathGeneralTest
extends AbstractXPathTest {
    @Test
    public void simpleSearch() throws Exception {
        List hits = this.getByXpath("<root><element/></root>", "//element");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void pipeSearch() throws Exception {
        List hits = this.getByXpath("<root><element/><element2/></root>", "//element | //element2");
        Assertions.assertEquals((int)2, (int)hits.size());
    }

    @Test
    public void mathSearch() throws Exception {
        List hits = this.getByXpath("<root><p/><p/></root>", "//p[position()=(1+5-(2*2))div 2]");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void gtSearch() throws Exception {
        List hits = this.getByXpath("<root><p/><p/></root>", "//p[position()>1]");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void gteSearch() throws Exception {
        List hits = this.getByXpath("<root><p/><p/></root>", "//p[position()>=1]");
        Assertions.assertEquals((int)2, (int)hits.size());
    }

    @Test
    public void ltSearch() throws Exception {
        List hits = this.getByXpath("<root><p/><p/></root>", "//p[position()<2]");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void lteSearch() throws Exception {
        List hits = this.getByXpath("<root><p/><p/></root>", "//p[position()<=2]");
        Assertions.assertEquals((int)2, (int)hits.size());
    }

    @Test
    public void eqSearch() throws Exception {
        List hits = this.getByXpath("<root><p/><p/></root>", "//p[position()=2]");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void neqSearch() throws Exception {
        List hits = this.getByXpath("<root><p/><p/><p/><p/></root>", "//p[position()!=2]");
        Assertions.assertEquals((int)3, (int)hits.size());
    }

    @Test
    public void andSearch() throws Exception {
        List hits = this.getByXpath("<root><p a='1' b='2'/><p/><p/><p/></root>", "//p[@a=1 and @b=2]");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void orSearch() throws Exception {
        List hits = this.getByXpath("<root><p a='1'/><p b='2'/><p/><p/></root>", "//p[@a=1 or @b=2]");
        Assertions.assertEquals((int)2, (int)hits.size());
    }

    @Test
    public void modSearch() throws Exception {
        List hits = this.getByXpath("<root><p a='1'/><p a='2'/><p a='3'/><p a='4'/></root>", "//p[@a mod 2 = 0]");
        Assertions.assertEquals((int)2, (int)hits.size());
    }

    @Test
    public void numberSearch() throws Exception {
        List hits = this.getByXpath("<root><p a='1'/><p a='2'/><p a='3'/><p a='4'/></root>", "//p[@a=number('  4\t')]");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void attributeSearch() throws Exception {
        List hits = this.getByXpath("<root><p/><p name='test'/><p/><p/></root>", "//p[@name='test']");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void attributeSearchDoubleQuotes() throws Exception {
        List hits = this.getByXpath("<root><p/><p name='test'/><p/><p/></root>", "//p[@name=\"test\"]");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void parentOfSelection() throws Exception {
        String xml = "<html>\n<a id='a1'><img src='1.gif'></img></a><a id='a2'><img src='1.gif'></img></a></html>";
        List hits = this.getByXpath("<html>\n<a id='a1'><img src='1.gif'></img></a><a id='a2'><img src='1.gif'></img></a></html>", "(/html/a/img[contains(@src,'gif')])[2]/..");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"a2", (Object)((Element)hits.get(0)).getAttribute("id"));
    }

    @Test
    public void pathWithParentheses() throws Exception {
        List hits = this.getByXpath("<root><child></child></root>", "(/root)/child");
        Assertions.assertEquals((int)1, (int)hits.size());
    }

    @Test
    public void evaluateWithMultiNodeAnswer() throws Exception {
        List hits = this.getByXpath("(/descendant-or-self::node())");
        Assertions.assertEquals((int)2, (int)hits.size());
    }

    @Test
    public void evaluateString() throws Exception {
        List hits = this.getByXpath("string(/*)");
        Assertions.assertEquals((int)1, (int)hits.size());
        Assertions.assertEquals((Object)"", hits.get(0));
    }

    @Test
    public void errorMissingDoubleQuotes() throws Exception {
        this.assertGetByXpathException("<root><p/><p name='test'/><p/><p/></root>", "//p[@name=\"test]", "Could not retrieve XPath >//p[@name=\"test]< on [#document: null]", "misquoted literal... expected double quote!");
    }

    @Test
    public void errorMissingSingleQuotes() throws Exception {
        this.assertGetByXpathException("<root><p/><p name='test'/><p/><p/></root>", "//p[@name=test']", "Could not retrieve XPath >//p[@name=test']< on [#document: null]", "misquoted literal... expected single quote!");
    }
}

