/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.XPathAdapter;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.objects.XBoolean;
import net.sourceforge.htmlunit.xpath.objects.XNodeSet;
import net.sourceforge.htmlunit.xpath.objects.XNumber;
import net.sourceforge.htmlunit.xpath.objects.XObject;
import net.sourceforge.htmlunit.xpath.objects.XString;
import net.sourceforge.htmlunit.xpath.xml.utils.PrefixResolver;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathHelper {
    private XPathHelper() {
    }

    public static <T> List<T> getByXPath(Node node, String xpathExpr, PrefixResolver resolver, boolean caseSensitive) {
        ArrayList<Object> list;
        block8: {
            if (xpathExpr == null) {
                throw new IllegalArgumentException("Null is not a valid XPath expression");
            }
            list = new ArrayList<Object>();
            try {
                XObject result = XPathHelper.evaluateXPath(node, xpathExpr, resolver, caseSensitive);
                if (result instanceof XNodeSet) {
                    NodeList nodelist = result.nodelist();
                    for (int i = 0; i < nodelist.getLength(); ++i) {
                        list.add(nodelist.item(i));
                    }
                    break block8;
                }
                if (result instanceof XNumber) {
                    list.add(result.num());
                    break block8;
                }
                if (result instanceof XBoolean) {
                    list.add(result.bool());
                    break block8;
                }
                if (result instanceof XString) {
                    list.add(result.str());
                    break block8;
                }
                throw new RuntimeException("Unproccessed " + result.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve XPath >" + xpathExpr + "< on " + node, e);
            }
        }
        return list;
    }

    private static XObject evaluateXPath(Node contextNode, String str, PrefixResolver prefixResolver, boolean caseSensitive) throws TransformerException {
        XPathContext xpathSupport = new XPathContext();
        XPathAdapter xpath = new XPathAdapter(str, prefixResolver, null, caseSensitive);
        int ctxtNode = xpathSupport.getDTMHandleFromNode(contextNode);
        return xpath.execute(xpathSupport, ctxtNode, prefixResolver);
    }
}

